/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.formats.tiff.GeotiffReader;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class GeotiffRasterReader
extends AbstractDataRasterReader {
    private static final String[] geotiffMimeTypes = new String[]{"image/tiff", "image/geotiff"};
    private static final String[] geotiffSuffixes = new String[]{"tif", "tiff", "gtif"};

    public GeotiffRasterReader() {
        super(geotiffMimeTypes, geotiffSuffixes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCanRead(DataSource dataSource) {
        String string = GeotiffRasterReader.pathFor(dataSource);
        if (string == null) {
            return false;
        }
        GeotiffReader geotiffReader = null;
        try {
            geotiffReader = new GeotiffReader(string);
            boolean bl = geotiffReader.isGeotiff();
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (geotiffReader != null) {
                geotiffReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataRaster[] doRead(DataSource dataSource) throws IOException {
        String string = GeotiffRasterReader.pathFor(dataSource);
        if (string == null) {
            String string2 = Logging.getMessage("DataRaster.CannotRead", dataSource);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        GeotiffReader geotiffReader = null;
        try {
            DataRaster[] dataRasterArray;
            geotiffReader = new GeotiffReader(string);
            BufferedImage bufferedImage = geotiffReader.read();
            bufferedImage = BufferedImageRaster.toCompatibleImage(bufferedImage);
            Object object = dataSource.getValue("gov.nasa.worldwind.avKey.Sector");
            if (object == null || !(object instanceof Sector)) {
                dataRasterArray = new AVListImpl();
                this.readGeotiffSector(geotiffReader, (AVList)dataRasterArray);
                object = dataRasterArray.getValue("gov.nasa.worldwind.avKey.Sector");
            }
            dataRasterArray = new DataRaster[]{new BufferedImageRaster((Sector)object, bufferedImage)};
            return dataRasterArray;
        }
        finally {
            if (geotiffReader != null) {
                geotiffReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReadMetadata(DataSource dataSource, AVList aVList) throws IOException {
        String string = GeotiffRasterReader.pathFor(dataSource);
        if (string == null) {
            String string2 = Logging.getMessage("DataRaster.CannotRead", dataSource);
            Logging.logger().severe(string2);
            throw new IOException(string2);
        }
        GeotiffReader geotiffReader = null;
        try {
            Object object;
            Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.Width");
            Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.Height");
            if (object2 == null || object3 == null || !(object2 instanceof Integer) || !(object3 instanceof Integer)) {
                geotiffReader = new GeotiffReader(string);
                this.readGeotiffDimension(geotiffReader, aVList);
            }
            if ((object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object instanceof Sector)) {
                this.readGeotiffSector(geotiffReader, aVList);
            }
        }
        finally {
            if (geotiffReader != null) {
                geotiffReader.close();
            }
        }
    }

    private void readGeotiffDimension(GeotiffReader geotiffReader, AVList aVList) throws IOException {
        int n = geotiffReader.getWidth(0);
        int n2 = geotiffReader.getHeight(0);
        aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
        aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
    }

    private void readGeotiffSector(GeotiffReader geotiffReader, AVList aVList) throws IOException {
        if (!geotiffReader.getGeoCodec().hasGeoKey(2048) || geotiffReader.getGeoCodec().hasGeoKey(3072)) {
            String string = Logging.getMessage("generic.ProjectionUnsupported");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        int n = geotiffReader.getWidth(0);
        int n2 = geotiffReader.getHeight(0);
        double[] dArray = geotiffReader.getGeoCodec().getBoundingBox(n, n2);
        Sector sector = new Sector(Angle.fromDegreesLatitude(dArray[3]), Angle.fromDegreesLatitude(dArray[1]), Angle.fromDegreesLongitude(dArray[0]), Angle.fromDegreesLongitude(dArray[2]));
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
    }
}

