/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.BasicDataIODescriptor;
import gov.nasa.worldwind.formats.tiff.GeotiffImageReaderSpi;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

public class ImageIOReader
extends BasicDataIODescriptor {
    public ImageIOReader() {
        super(ImageIO.getReaderMIMETypes(), ImageIOReader.getImageIOReaderSuffixes());
    }

    public boolean canRead(Object object) {
        if (object == null) {
            return false;
        }
        String string = ImageIOReader.getSuffixFor(object);
        if (string != null && !this.matchesFormatSuffix(string)) {
            return false;
        }
        return this.doCanRead(object);
    }

    public BufferedImage read(Object object) throws IOException {
        if (!this.canRead(object)) {
            String string = Logging.getMessage("generic.InvalidDataSource", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        return this.doRead(object);
    }

    public void readMetadata(Object object, AVList aVList) throws IOException {
        if (!this.canRead(object)) {
            String string = Logging.getMessage("generic.InvalidDataSource", object);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.AVListIsNull");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        this.doReadMetadata(object, aVList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doCanRead(Object object) {
        ImageInputStream imageInputStream = null;
        ImageReader imageReader = null;
        try {
            imageInputStream = ImageIOReader.createInputStream(object);
            if (imageInputStream != null) {
                imageReader = ImageIOReader.readerFor(imageInputStream);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            try {
                if (imageInputStream != null) {
                    imageInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return imageReader != null;
    }

    protected BufferedImage doRead(Object object) throws IOException {
        ImageInputStream imageInputStream = ImageIOReader.createInputStream(object);
        return ImageIO.read(imageInputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReadMetadata(Object object, AVList aVList) throws IOException {
        ImageInputStream imageInputStream = ImageIOReader.createInputStream(object);
        ImageReader imageReader = ImageIOReader.readerFor(imageInputStream);
        try {
            if (imageReader == null) {
                String string = Logging.getMessage("generic.UnrecognizedImageSourceType", object);
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            imageReader.setInput(imageInputStream, true, true);
            int n = imageReader.getWidth(0);
            int n2 = imageReader.getHeight(0);
            aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
            aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
        }
        finally {
            if (imageReader != null) {
                imageReader.dispose();
            }
            imageInputStream.close();
        }
    }

    protected static ImageInputStream createInputStream(Object object) throws IOException {
        if (object instanceof URL) {
            object = ((URL)object).openStream();
        } else if (object instanceof CharSequence) {
            object = ImageIOReader.openInputStream(object.toString());
        }
        return ImageIO.createImageInputStream(object);
    }

    protected static InputStream openInputStream(String string) throws IOException {
        Object object = WWIO.getFileOrResourceAsStream(string, null);
        if (object == null) {
            return null;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof Exception) {
            String string2 = Logging.getMessage("generic.ExceptionAttemptingToReadImageFile", string);
            Logging.logger().log(Level.SEVERE, string2, object);
            throw new IOException(string2);
        }
        return (InputStream)object;
    }

    protected static ImageReader readerFor(ImageInputStream imageInputStream) {
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    protected static String[] getImageIOReaderSuffixes() {
        String[] stringArray;
        Iterator<ImageReaderSpi> iterator;
        try {
            iterator = IIORegistry.getDefaultInstance().getServiceProviders(ImageReaderSpi.class, true);
        }
        catch (Exception exception) {
            return new String[0];
        }
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            stringArray = iterator.next();
            String[] stringArray2 = stringArray.getFileSuffixes();
            hashSet.addAll(Arrays.asList(stringArray2));
        }
        stringArray = new String[hashSet.size()];
        hashSet.toArray(stringArray);
        return stringArray;
    }

    static {
        IIORegistry.getDefaultInstance().registerServiceProvider(GeotiffImageReaderSpi.inst());
    }
}

