/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.AbstractDataRasterReader;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.formats.nitfs.NITFSImageSegment;
import gov.nasa.worldwind.formats.nitfs.NITFSSegmentType;
import gov.nasa.worldwind.formats.rpf.RPFDataSeries;
import gov.nasa.worldwind.formats.rpf.RPFFile;
import gov.nasa.worldwind.formats.rpf.RPFFrameFileComponents;
import gov.nasa.worldwind.formats.rpf.RPFFrameFilename;
import gov.nasa.worldwind.formats.rpf.RPFFrameTransform;
import gov.nasa.worldwind.formats.rpf.RPFImageFile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;

public class RPFRasterReader
extends AbstractDataRasterReader {
    public RPFRasterReader() {
        super("RPF Imagery");
    }

    public boolean canRead(DataSource dataSource) {
        if (dataSource == null || dataSource.getSource() == null) {
            return false;
        }
        return this.doCanRead(dataSource);
    }

    protected boolean doCanRead(DataSource dataSource) {
        if (!(dataSource.getSource() instanceof File)) {
            return false;
        }
        File file = (File)dataSource.getSource();
        String string = file.getName().toUpperCase();
        return RPFFrameFilename.isFilename(string);
    }

    protected DataRaster[] doRead(DataSource dataSource) throws IOException {
        if (!(dataSource.getSource() instanceof File)) {
            String string = Logging.getMessage("DataRaster.CannotRead", dataSource);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File file = (File)dataSource.getSource();
        RPFFrameFilename rPFFrameFilename = RPFFrameFilename.parseFilename(file.getName().toUpperCase());
        if (rPFFrameFilename.getZoneCode() == '9' || rPFFrameFilename.getZoneCode() == 'J') {
            return this.readPolarImage(dataSource, rPFFrameFilename);
        }
        return this.readNonPolarImage(dataSource);
    }

    protected void doReadMetadata(DataSource dataSource, AVList aVList) throws IOException {
        Object object;
        if (!(dataSource.getSource() instanceof File)) {
            String string = Logging.getMessage("DataRaster.CannotRead", dataSource);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        File file = (File)dataSource.getSource();
        RPFImageFile rPFImageFile = null;
        Object object2 = aVList.getValue("gov.nasa.worldwind.avkey.Width");
        Object object3 = aVList.getValue("gov.nasa.worldwind.avkey.Height");
        if (object2 == null || object3 == null || !(object2 instanceof Integer) || !(object3 instanceof Integer)) {
            rPFImageFile = RPFImageFile.load(file);
            this.readFileSize(rPFImageFile, aVList);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object instanceof Sector)) {
            this.readFileSector(file, rPFImageFile, aVList);
        }
    }

    private DataRaster[] readNonPolarImage(DataSource dataSource) throws IOException {
        Object object;
        File file = (File)dataSource.getSource();
        RPFImageFile rPFImageFile = RPFImageFile.load(file);
        BufferedImage bufferedImage = rPFImageFile.getBufferedImage();
        bufferedImage = BufferedImageRaster.toCompatibleImage(bufferedImage);
        Object object2 = dataSource.getValue("gov.nasa.worldwind.avKey.Sector");
        if (object2 == null || !(object2 instanceof Sector)) {
            object = new AVListImpl();
            this.readFileSector(file, rPFImageFile, (AVList)object);
            object2 = object.getValue("gov.nasa.worldwind.avKey.Sector");
        }
        object = new BufferedImageRaster((Sector)object2, bufferedImage);
        return new DataRaster[]{object};
    }

    private DataRaster[] readPolarImage(DataSource dataSource, RPFFrameFilename rPFFrameFilename) throws IOException {
        File file = (File)dataSource.getSource();
        RPFImageFile rPFImageFile = RPFImageFile.load(file);
        BufferedImage bufferedImage = rPFImageFile.getBufferedImage();
        RPFDataSeries rPFDataSeries = RPFDataSeries.dataSeriesFor(rPFFrameFilename.getDataSeriesCode());
        RPFFrameTransform rPFFrameTransform = RPFFrameTransform.createFrameTransform(rPFFrameFilename.getZoneCode(), rPFDataSeries.rpfDataType, rPFDataSeries.scaleOrGSD);
        RPFFrameTransform.RPFImage[] rPFImageArray = rPFFrameTransform.deproject(rPFFrameFilename.getFrameNumber(), bufferedImage);
        DataRaster[] dataRasterArray = new DataRaster[rPFImageArray.length];
        for (int i = 0; i < rPFImageArray.length; ++i) {
            BufferedImage bufferedImage2 = BufferedImageRaster.toCompatibleImage(rPFImageArray[i].getImage());
            dataRasterArray[i] = new BufferedImageRaster(rPFImageArray[i].getSector(), bufferedImage2);
        }
        return dataRasterArray;
    }

    private void readFileSize(RPFImageFile rPFImageFile, AVList aVList) {
        int n = rPFImageFile.getImageSegment().numSignificantCols;
        int n2 = rPFImageFile.getImageSegment().numSignificantRows;
        aVList.setValue("gov.nasa.worldwind.avkey.Width", n);
        aVList.setValue("gov.nasa.worldwind.avkey.Height", n2);
    }

    private void readFileSector(File file, RPFImageFile rPFImageFile, AVList aVList) {
        Sector sector = this.sectorFromFilename(file);
        if (sector == null) {
            sector = this.sectorFromHeader(file, rPFImageFile);
        }
        aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
    }

    private Sector sectorFromFilename(File file) {
        Sector sector = null;
        try {
            RPFFrameFilename rPFFrameFilename = RPFFrameFilename.parseFilename(file.getName().toUpperCase());
            RPFDataSeries rPFDataSeries = RPFDataSeries.dataSeriesFor(rPFFrameFilename.getDataSeriesCode());
            if (rPFDataSeries.scaleOrGSD > 0.0) {
                RPFFrameTransform rPFFrameTransform = RPFFrameTransform.createFrameTransform(rPFFrameFilename.getZoneCode(), rPFDataSeries.rpfDataType, rPFDataSeries.scaleOrGSD);
                sector = rPFFrameTransform.computeFrameCoverage(rPFFrameFilename.getFrameNumber());
            }
        }
        catch (Exception exception) {
            String string = String.format("Exception while computing file sector: %s", file);
            Logging.logger().log(Level.SEVERE, string, exception);
            sector = null;
        }
        return sector;
    }

    private Sector sectorFromHeader(File file, RPFFile rPFFile) {
        Sector sector;
        try {
            Angle angle;
            if (rPFFile == null) {
                rPFFile = RPFImageFile.load(file);
            }
            NITFSImageSegment nITFSImageSegment = (NITFSImageSegment)rPFFile.getNITFSSegment(NITFSSegmentType.IMAGE_SEGMENT);
            RPFFrameFileComponents rPFFrameFileComponents = nITFSImageSegment.getUserDefinedImageSubheader().getRPFFrameFileComponents();
            Angle angle2 = rPFFrameFileComponents.swLowerleft.getLatitude();
            Angle angle3 = rPFFrameFileComponents.neUpperRight.getLatitude();
            Angle angle4 = rPFFrameFileComponents.swLowerleft.getLongitude();
            if (Angle.crossesLongitudeBoundary(angle4, angle = rPFFrameFileComponents.neUpperRight.getLongitude()) && angle4.compareTo(angle) > 0) {
                double d = 360.0 + angle.degrees;
                angle = Angle.fromDegrees(d);
            }
            sector = new Sector(angle2, angle3, angle4, angle);
        }
        catch (Exception exception) {
            String string = String.format("Exception while getting file sector: %s", file);
            Logging.logger().log(Level.SEVERE, string, exception);
            sector = null;
        }
        return sector;
    }
}

