/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.cache.Cacheable;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.logging.Level;

public class ReadableDataRaster
implements DataRaster {
    private DataSource dataSource;
    private DataRasterReader rasterReader;
    private MemoryCache rasterCache;
    private CacheListener cacheListener;

    public ReadableDataRaster(DataSource dataSource, DataRasterReader dataRasterReader, MemoryCache memoryCache) throws IOException {
        if (dataSource == null) {
            String string = Logging.getMessage("nullValue.DataSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRasterReader == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.dataSource = dataSource;
        this.rasterReader = dataRasterReader;
        this.rasterCache = memoryCache;
        if (this.rasterCache != null) {
            this.cacheListener = new CacheListener(this.dataSource);
            this.rasterCache.addCacheListener(this.cacheListener);
        }
        if (!this.rasterReader.canRead(this.dataSource)) {
            String string = Logging.getMessage("DataRaster.CannotRead", this.dataSource);
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        this.assembleMetadata();
    }

    public ReadableDataRaster(DataSource dataSource, DataRasterReader dataRasterReader) throws IOException {
        this(dataSource, dataRasterReader, null);
    }

    public static DataRasterReader findReaderFor(DataSource dataSource, DataRasterReader[] dataRasterReaderArray) {
        if (dataSource == null) {
            String string = Logging.getMessage("nullValue.DataSourceIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dataRasterReaderArray == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        for (DataRasterReader dataRasterReader : dataRasterReaderArray) {
            if (dataRasterReader == null || !dataRasterReader.canRead(dataSource)) continue;
            return dataRasterReader;
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public DataRasterReader getReader() {
        return this.rasterReader;
    }

    public MemoryCache getCache() {
        return this.rasterCache;
    }

    public int getWidth() {
        DataSource dataSource = this.getDataSource();
        return (Integer)dataSource.getValue("gov.nasa.worldwind.avkey.Width");
    }

    public int getHeight() {
        DataSource dataSource = this.getDataSource();
        return (Integer)dataSource.getValue("gov.nasa.worldwind.avkey.Height");
    }

    public Sector getSector() {
        DataSource dataSource = this.getDataSource();
        return (Sector)dataSource.getValue("gov.nasa.worldwind.avKey.Sector");
    }

    public void drawOnCanvas(DataRaster dataRaster) {
        DataRaster[] dataRasterArray = null;
        try {
            dataRasterArray = this.getDataRasters();
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("DataRaster.CannotRead", this.getDataSource());
            Logging.logger().log(Level.SEVERE, string, iOException);
        }
        if (dataRasterArray != null) {
            for (DataRaster dataRaster2 : dataRasterArray) {
                dataRaster2.drawOnCanvas(dataRaster);
            }
        }
    }

    protected boolean isMissingMetadata() {
        DataSource dataSource = this.getDataSource();
        Object object = dataSource.getValue("gov.nasa.worldwind.avkey.Width");
        if (object == null || !(object instanceof Integer)) {
            return true;
        }
        object = dataSource.getValue("gov.nasa.worldwind.avkey.Height");
        if (object == null || !(object instanceof Integer)) {
            return true;
        }
        object = dataSource.getValue("gov.nasa.worldwind.avKey.Sector");
        return object == null || !(object instanceof Sector);
    }

    protected void assembleMetadata() throws IOException {
        if (!this.isMissingMetadata()) {
            return;
        }
        DataSource dataSource = this.getDataSource();
        this.getReader().readMetadata(dataSource, dataSource);
        if (this.isMissingMetadata()) {
            String string = Logging.getMessage("DataRaster.MissingMetadata", this.getDataSource());
            Logging.logger().severe(string);
            throw new IOException(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataRaster[] getDataRasters() throws IOException {
        DataSource dataSource = this.getDataSource();
        MemoryCache memoryCache = this.getCache();
        DataRaster[] dataRasterArray = (DataRaster[])memoryCache.getObject(dataSource);
        if (dataRasterArray == null && !memoryCache.contains(dataSource)) {
            try {
                dataRasterArray = this.getReader().read(dataSource);
            }
            finally {
                memoryCache.add(dataSource, dataRasterArray, ReadableDataRaster.getSizeInBytes(dataRasterArray));
            }
        }
        return dataRasterArray;
    }

    private static long getSizeInBytes(DataRaster[] dataRasterArray) {
        long l = 0L;
        if (dataRasterArray != null) {
            for (DataRaster dataRaster : dataRasterArray) {
                if (dataRaster == null || !(dataRaster instanceof Cacheable)) continue;
                l += ((Cacheable)((Object)dataRaster)).getSizeInBytes();
            }
        }
        return l;
    }

    private static class CacheListener
    implements MemoryCache.CacheListener {
        private Object key;

        private CacheListener(Object object) {
            this.key = object;
        }

        public void entryRemoved(Object object, Object object2) {
            if (object != this.key) {
                return;
            }
            if (object2 == null || !(object2 instanceof DataRaster[])) {
                String string = MessageFormat.format("Cannot dispose {0}", object2);
                Logging.logger().warning(string);
                return;
            }
            try {
                this.dispose((DataRaster[])object2);
            }
            catch (Exception exception) {
                String string = Logging.getMessage("generic.ExceptionWhileDisposing", object2);
                Logging.logger().log(Level.SEVERE, string, exception);
            }
        }

        private void dispose(DataRaster[] dataRasterArray) {
            for (DataRaster dataRaster : dataRasterArray) {
                if (dataRaster == null || !(dataRaster instanceof Disposable)) continue;
                ((Disposable)((Object)dataRaster)).dispose();
            }
        }
    }
}

