/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.BILRasterReader;
import gov.nasa.worldwind.data.BILRasterWriter;
import gov.nasa.worldwind.data.BufferedDataRaster;
import gov.nasa.worldwind.data.ByteBufferRaster;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterWriter;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.data.TiledRasterProducer;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TiledElevationProducer
extends TiledRasterProducer {
    private static final String DEFAULT_FORMAT_SUFFIX = ".bil";
    private static DataRasterReader[] readers = new DataRasterReader[]{new BILRasterReader()};

    public TiledElevationProducer(MemoryCache memoryCache, int n) {
        super(memoryCache, n);
    }

    public TiledElevationProducer() {
    }

    @Override
    public String getDataSourceDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("DataStoreProducer.TiledElevation.Description"));
        stringBuilder.append(" (").append(super.getDataSourceDescription()).append(")");
        return stringBuilder.toString();
    }

    @Override
    protected DataRaster createDataRaster(int n, int n2, Sector sector, AVList aVList) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataType", aVList.getValue("gov.nasa.worldwind.avkey.PixelType"));
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ByteOrder", aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder"));
        ByteBufferRaster byteBufferRaster = new ByteBufferRaster(n, n2, sector, aVListImpl);
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue");
        if (object != null && object instanceof Double) {
            Double d = (Double)object;
            byteBufferRaster.fill(d);
            byteBufferRaster.setTransparentValue(d);
        }
        return byteBufferRaster;
    }

    @Override
    protected DataRasterReader[] getDataRasterReaders() {
        return readers;
    }

    @Override
    protected DataRasterWriter[] getDataRasterWriters() {
        return new DataRasterWriter[]{new BILRasterWriter()};
    }

    @Override
    protected String validateDataSource(DataSource dataSource) {
        if (dataSource.getSource() instanceof DataRaster && !(dataSource.getSource() instanceof BufferedDataRaster)) {
            return Logging.getMessage("DataStoreProducer.InvalidDataSource", dataSource);
        }
        return super.validateDataSource(dataSource);
    }

    @Override
    protected void initProductionParameters(AVList aVList) {
        super.initProductionParameters(aVList);
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey");
        if (object == null || !(object instanceof String) || ((String)object).length() == 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", DEFAULT_FORMAT_SUFFIX);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.ByteOrder")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", "gov.nasa.worldwind.avkey.LittleEndian");
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.PixelType")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelType", "gov.nasa.worldwind.avkey.Float32");
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.MissingDataValue")) == null || !(object instanceof Double)) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataValue", -9999.0);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataType")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.TiledElevations");
        }
    }

    @Override
    protected LatLon computeRasterTileDelta(int n, int n2, Iterable<? extends DataRaster> iterable) {
        LatLon latLon = this.computeSmallestPixelSize(iterable);
        double d = (double)(n2 - 1) * latLon.getLatitude().degrees;
        double d2 = (double)(n - 1) * latLon.getLongitude().degrees;
        return LatLon.fromDegrees(d, d2);
    }
}

