/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.cache.MemoryCache;
import gov.nasa.worldwind.data.BufferedImageRaster;
import gov.nasa.worldwind.data.DDSRasterWriter;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataRasterReader;
import gov.nasa.worldwind.data.DataRasterWriter;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.data.GeotiffRasterReader;
import gov.nasa.worldwind.data.ImageIORasterReader;
import gov.nasa.worldwind.data.ImageIORasterWriter;
import gov.nasa.worldwind.data.RPFRasterReader;
import gov.nasa.worldwind.data.TiledRasterProducer;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;

public class TiledImageProducer
extends TiledRasterProducer {
    private static final String DEFAULT_FORMAT_SUFFIX = ".dds";
    private static DataRasterReader[] readers = new DataRasterReader[]{new ImageIORasterReader(), new GeotiffRasterReader(), new RPFRasterReader()};

    public TiledImageProducer(MemoryCache memoryCache, int n) {
        super(memoryCache, n);
    }

    public TiledImageProducer() {
    }

    public String getDataSourceDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("DataStoreProducer.TiledImagery.Description"));
        stringBuilder.append(" (").append(super.getDataSourceDescription()).append(")");
        return stringBuilder.toString();
    }

    protected DataRaster createDataRaster(int n, int n2, Sector sector, AVList aVList) {
        int n3 = 3;
        BufferedImageRaster bufferedImageRaster = new BufferedImageRaster(n, n2, n3, sector);
        return bufferedImageRaster;
    }

    protected DataRasterReader[] getDataRasterReaders() {
        return readers;
    }

    protected DataRasterWriter[] getDataRasterWriters() {
        return new DataRasterWriter[]{new ImageIORasterWriter(), new DDSRasterWriter()};
    }

    protected String validateDataSource(DataSource dataSource) {
        if (dataSource.getSource() instanceof DataRaster && !(dataSource.getSource() instanceof BufferedImageRaster)) {
            return Logging.getMessage("DataStoreProducer.InvalidDataSource", dataSource);
        }
        return super.validateDataSource(dataSource);
    }

    protected void initProductionParameters(AVList aVList) {
        super.initProductionParameters(aVList);
        Object object = aVList.getValue("gov.nasa.worldwind.avkey.FormatSuffixKey");
        if (object == null || !(object instanceof String) || ((String)object).length() == 0) {
            aVList.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", DEFAULT_FORMAT_SUFFIX);
        }
        if ((object = aVList.getValue("gov.nasa.worldwind.avkey.DataType")) == null) {
            aVList.setValue("gov.nasa.worldwind.avkey.DataType", "gov.nasa.worldwind.avkey.TiledImagery");
        }
    }
}

