/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.data;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.data.AbstractDataDescriptorWriter;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class WWDotNetLayerSetWriter
extends AbstractDataDescriptorWriter {
    public static final String MIME_TYPE = "text/xml";

    public String getMimeType() {
        return MIME_TYPE;
    }

    public boolean matchesMimeType(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(this.getMimeType());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Logging.getMessage("DataDescriptor.WWDotNetLayerSet.Name"));
        stringBuilder.append("(*").append(WWIO.makeSuffixForMimeType(this.getMimeType())).append(")");
        return stringBuilder.toString();
    }

    protected void doWrite(Writer writer, DataDescriptor dataDescriptor) throws IOException {
        Object object;
        Object object2;
        String string = "Unnamed Data Set";
        String string2 = "";
        Sector sector = Sector.FULL_SPHERE;
        LatLon latLon = LatLon.ZERO;
        Integer n = 0;
        Integer n2 = 0;
        Integer n3 = 0;
        File file = null;
        String string3 = dataDescriptor.getName();
        if (string3 != null) {
            string = string3;
        }
        if ((string3 = dataDescriptor.getStringValue("gov.nasa.worldwind.avkey.FormatSuffixKey")) != null) {
            string2 = string3;
        }
        if ((object2 = dataDescriptor.getValue("gov.nasa.worldwind.avKey.Sector")) != null && object2 instanceof Sector) {
            sector = (Sector)object2;
        }
        if ((object2 = dataDescriptor.getValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta")) != null && object2 instanceof LatLon) {
            latLon = (LatLon)object2;
        }
        if ((object2 = dataDescriptor.getValue("gov.nasa.worldwind.avkey.NumLevels")) != null && object2 instanceof Integer) {
            n = (Integer)object2;
        }
        if ((object2 = dataDescriptor.getValue("gov.nasa.worldwind.avkey.TileWidthKey")) != null && object2 instanceof Integer) {
            n2 = (Integer)object2;
        }
        if ((object2 = dataDescriptor.getValue("gov.nasa.worldwind.avkey.TileHeightKey")) != null && object2 instanceof Integer) {
            n3 = (Integer)object2;
        }
        if ((string3 = this.getPathValue(dataDescriptor, "gov.nasa.worldwind.avkey.WorldWindDotNetPermanentDirectory")) != null) {
            file = new File(string3);
        }
        if (file == null) {
            object = "";
            string3 = this.getPathValue(dataDescriptor, "gov.nasa.worldwind.avkey.FileStoreLocation");
            if (string3 != null) {
                object = (String)object + string3;
            }
            string3 = this.getPathValue(dataDescriptor, "gov.nasa.worldwind.avkey.DataCacheNameKey");
            object = (String)object + string3;
            file = new File((String)object);
        }
        object = new PrintWriter(writer);
        ((PrintWriter)object).println("<?xml version=\"1.0\"?>");
        ((PrintWriter)object).print("<LayerSet Name=\"" + string + "\" ShowOnlyOneLayer=\"false\" ShowAtStartup=\"true\"");
        ((PrintWriter)object).print(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        ((PrintWriter)object).println(" xsi:noNamespaceSchemaLocation=\"LayerSet.xsd\">");
        ((PrintWriter)object).println("    <QuadTileSet ShowAtStartup=\"true\">");
        ((PrintWriter)object).print("          <Name>");
        ((PrintWriter)object).print(string);
        ((PrintWriter)object).println("</Name>");
        ((PrintWriter)object).println("        <DistanceAboveSurface>0</DistanceAboveSurface>");
        ((PrintWriter)object).println("        <BoundingBox>");
        ((PrintWriter)object).print("            <North><Value>");
        ((PrintWriter)object).print(sector.getMaxLatitude().degrees);
        ((PrintWriter)object).println("</Value></North>");
        ((PrintWriter)object).print("            <South><Value>");
        ((PrintWriter)object).print(sector.getMinLatitude().degrees);
        ((PrintWriter)object).println("</Value></South>");
        ((PrintWriter)object).print("            <West><Value>");
        ((PrintWriter)object).print(sector.getMinLongitude().degrees);
        ((PrintWriter)object).println("</Value></West>");
        ((PrintWriter)object).print("            <East><Value>");
        ((PrintWriter)object).print(sector.getMaxLongitude().degrees);
        ((PrintWriter)object).println("</Value></East>");
        ((PrintWriter)object).println("        </BoundingBox>");
        ((PrintWriter)object).println("        <Opacity>255</Opacity>");
        ((PrintWriter)object).println("        <TerrainMapped>true</TerrainMapped>");
        ((PrintWriter)object).println("        <RenderStruts>false</RenderStruts>");
        ((PrintWriter)object).println("        <ImageAccessor>");
        ((PrintWriter)object).print("            <LevelZeroTileSizeDegrees>");
        ((PrintWriter)object).print(latLon.getLatitude().degrees);
        ((PrintWriter)object).println("</LevelZeroTileSizeDegrees>");
        ((PrintWriter)object).print("            <NumberLevels>");
        ((PrintWriter)object).print(n);
        ((PrintWriter)object).println("</NumberLevels>");
        ((PrintWriter)object).print("            <TextureSizePixels>");
        ((PrintWriter)object).print(Math.max(n2, n3));
        ((PrintWriter)object).println("</TextureSizePixels>");
        ((PrintWriter)object).print("            <ImageFileExtension>");
        ((PrintWriter)object).print(WWDotNetLayerSetWriter.stripLeadingPeriod(string2));
        ((PrintWriter)object).println("</ImageFileExtension>");
        ((PrintWriter)object).print("            <PermanentDirectory>");
        ((PrintWriter)object).print(file.getAbsolutePath());
        ((PrintWriter)object).println("</PermanentDirectory>");
        ((PrintWriter)object).println("        </ImageAccessor>");
        ((PrintWriter)object).println("    </QuadTileSet>");
        ((PrintWriter)object).println("</LayerSet>");
        ((PrintWriter)object).flush();
    }

    private String getPathValue(AVList aVList, String string) {
        String string2 = null;
        Object object = aVList.getValue(string);
        if (object != null && object instanceof File) {
            string2 = ((File)object).getPath();
        } else if (object != null && object instanceof String) {
            string2 = (String)object;
        }
        return string2;
    }

    private static String stripLeadingPeriod(String string) {
        if (string.startsWith(".")) {
            return string.substring(Math.min(1, string.length()), string.length());
        }
        return string;
    }
}

