/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.examples.LayerPanel;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.AirspaceLayer;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.airspaces.Airspace;
import gov.nasa.worldwind.render.airspaces.AirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.BasicAirspaceAttributes;
import gov.nasa.worldwind.render.airspaces.Box;
import gov.nasa.worldwind.render.airspaces.Cake;
import gov.nasa.worldwind.render.airspaces.CappedCylinder;
import gov.nasa.worldwind.render.airspaces.Curtain;
import gov.nasa.worldwind.render.airspaces.Orbit;
import gov.nasa.worldwind.render.airspaces.PartialCappedCylinder;
import gov.nasa.worldwind.render.airspaces.PolyArc;
import gov.nasa.worldwind.render.airspaces.Polygon;
import gov.nasa.worldwind.render.airspaces.Route;
import gov.nasa.worldwind.render.airspaces.SphereAirspace;
import gov.nasa.worldwind.render.airspaces.TrackAirspace;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Airspaces
extends ApplicationTemplate {
    public static final String DRAW_AIRSPACE_EXTENT = "gov.nasa.worldwind.avkey.DrawAirspaceExtent";
    public static final String DRAW_AIRSPACE_WIREFRAME = "gov.nasa.worldwind.avkey.DrawAirspaceWireframe";
    public static final String ACTION_COMMAND_LOAD_DEMO_AIRSPACES = "ActionCommandLoadDemoAirspaces";
    public static final String ACTION_COMMAND_ZOOM_TO_DEMO_AIRSPACES = "ActionCommandZoomToDemoAirspaces";
    public static final String ACTION_COMMAND_SAVE_AIRSPACES = "ActionCommandSaveAirspaces";
    public static final String ACTION_COMMAND_READ_AIRSPACES = "ActionCommandReadAirspaces";
    public static final String ACTION_COMMAND_VERTICAL_EXAGGERATION = "ActionCommandVerticalExaggeration";
    public static final String AIRSPACE_LAYER_NAME = "Airspaces";
    public static final String ANNOTATION_LAYER_NAME = "Annotations";
    public static final String DESCRIPTION = "Description";
    private static final double[] SAN_JUAN_COUNTY_1 = new double[]{-123.025486, 48.717966, -123.019699, 48.721312, -123.009787, 48.722291, -123.007511, 48.718863, -123.005086, 48.694342, -123.014449, 48.684978, -123.021215, 48.681416, -123.042337, 48.675663, -123.041645, 48.678633, -123.035672, 48.68535, -123.03636, 48.69008, -123.047058, 48.695772, -123.070427, 48.699971, -123.040179, 48.717296, -123.025486, 48.717966};
    private static final double[] SAN_JUAN_COUNTY_2 = new double[]{-122.906298643435, 48.7142756789313, -122.894599, 48.71503, -122.883606017278, 48.7133157521183, -122.879724954535, 48.7127105384329, -122.875938, 48.71212, -122.836802504198, 48.6993713019117, -122.834290842953, 48.6985531083446, -122.833124, 48.698173, -122.831410808922, 48.6973051154063, -122.82568362967, 48.6944037865925, -122.808804479515, 48.6858529865323, -122.805788100163, 48.6843249204562, -122.802545, 48.682682, -122.800267, 48.67962, -122.761393485795, 48.6676429790988, -122.744791626046, 48.6625279071718, -122.743049, 48.661991, -122.742776245752, 48.6616237548803, -122.742082, 48.660689, -122.755031, 48.649512, -122.762709974974, 48.6457601003223, -122.774165127982, 48.6401631834124, -122.783875, 48.635419, -122.792147, 48.633502, -122.806316669653, 48.621771378491, -122.807583040252, 48.6207229903106, -122.809622, 48.619035, -122.80958330326, 48.6188448346238, -122.808864, 48.61531, -122.79901, 48.604683, -122.79877, 48.602352, -122.800217, 48.60169, -122.801521572817, 48.600075268642, -122.804869, 48.595932, -122.804736685678, 48.5955635328447, -122.802617338743, 48.5896616038081, -122.801096, 48.585425, -122.796913105296, 48.5828999845133, -122.787753320193, 48.5773706559316, -122.786586, 48.576666, -122.771206, 48.562426, -122.770349, 48.558106, -122.772384, 48.552143, -122.782618, 48.545191, -122.788503, 48.530393, -122.787596684858, 48.5246062248558, -122.787347, 48.523012, -122.777467, 48.517799, -122.779073275586, 48.5091830812273, -122.779124, 48.508911, -122.799155517055, 48.4953208059023, -122.799759583816, 48.4949109824973, -122.800414, 48.494467, -122.809344417182, 48.490749639512, -122.816332, 48.487841, -122.816392492828, 48.48768965307, -122.817912, 48.483888, -122.818113811431, 48.4811078199731, -122.818435504082, 48.4766761409594, -122.818482000648, 48.4760355983364, -122.81973, 48.458843, -122.8131, 48.452856, -122.810699656295, 48.4489394154454, -122.807708, 48.444058, -122.80671619552, 48.4419671792455, -122.802509, 48.433098, -122.803004619265, 48.4309676207466, -122.80332683408, 48.4295826064757, -122.803521, 48.428748, -122.806510124273, 48.4265382433425, -122.812173045928, 48.4223518403418, -122.812208, 48.422326, -122.825307995692, 48.4240652785748, -122.825803, 48.424131, -122.85254248494, 48.4208474850799, -122.863360429977, 48.4195190793902, -122.866475017092, 48.4191366190217, -122.866865338919, 48.419088688871, -122.867939205531, 48.4189568218194, -122.86799681456, 48.4189497476327, -122.874135, 48.418196, -122.874527604161, 48.4182203541858, -122.883759, 48.418793, -122.888474856222, 48.4206350791676, -122.893646, 48.422655, -122.889016, 48.435947, -122.903214, 48.436979, -122.913888, 48.443231, -122.917771, 48.439781, -122.927683717092, 48.4399602096806, -122.928004, 48.439966, -122.927964788402, 48.4400111660268, -122.91646, 48.453263, -122.920099, 48.458428, -122.926901, 48.460874, -122.937881, 48.456221, -122.950555015899, 48.4535630706048, -122.962009, 48.451161, -123.001288, 48.4556628590224, -123.026267878952, 48.4585258619868, -123.029013724265, 48.4588405698076, -123.033178635901, 48.4593179201736, -123.038888830654, 48.4599723790898, -123.039156, 48.460003, -123.058154, 48.471522, -123.067675, 48.479497, -123.070563309358, 48.4802266082759, -123.070833040893, 48.4802947444538, -123.076030355349, 48.481607624471, -123.099948917862, 48.4876496300162, -123.119451, 48.492576, -123.129287766067, 48.4982542349179, -123.134915117353, 48.5015026015408, -123.141478, 48.505291, -123.14482270173, 48.5083136865329, -123.148640952156, 48.5117643302889, -123.150537321568, 48.5134781244465, -123.151065, 48.513955, -123.152147442285, 48.5153416540207, -123.152738173008, 48.5160984048828, -123.163234, 48.529544, -123.164057, 48.535622, -123.161853, 48.539255, -123.161750942688, 48.5414834733667, -123.16147, 48.547618, -123.167656573858, 48.5526319405021, -123.172412, 48.556486, -123.176266, 48.562131, -123.176243708612, 48.5624730166654, -123.175852, 48.568483, -123.171958, 48.572255, -123.173061, 48.579086, -123.184941, 48.58697, -123.195467450664, 48.586350555389, -123.196697396232, 48.5862781774168, -123.197754, 48.586216, -123.198045125962, 48.586452281282, -123.20268, 48.590214, -123.203026, 48.596178, -123.195725, 48.607055, -123.179996129946, 48.6207472995959, -123.178425, 48.622115, -123.151643, 48.623686, -123.139705244805, 48.6227863453916, -123.135644582323, 48.6201710055677, -123.131377372596, 48.6205150057834, -123.107362, 48.622451, -123.10164791887, 48.6162765822218, -123.098626049648, 48.6130112657825, -123.098462, 48.612834, -123.098254, 48.610092, -123.102074, 48.604035, -123.101552, 48.59782, -123.100979011718, 48.597692305347, -123.08799197019, 48.5947980476233, -123.079379694944, 48.5928787387418, -123.079368517922, 48.5928762478604, -123.079334903513, 48.5928687566419, -123.078354245955, 48.5926502098924, -123.078029433353, 48.5925778230151, -123.077161967252, 48.5923845018144, -123.07472713592, 48.591841881744, -123.074611, 48.591816, -123.06004, 48.582105, -123.056818600556, 48.5785370170628, -123.055637295811, 48.5772286182611, -123.049834129163, 48.5708011012966, -123.048403, 48.569216, -123.037067007025, 48.5647482308128, -123.033669, 48.563409, -123.025587194622, 48.562285888132, -123.015046, 48.560821, -123.014957175286, 48.5608244377565, -123.005887152572, 48.5611754721491, -122.994982694655, 48.561597504142, -122.987296, 48.561895, -122.98611, 48.569984, -122.989649, 48.574668, -122.995026, 48.578162, -123.001291973563, 48.5798454915671, -123.003071284953, 48.5803235426935, -123.0048, 48.580788, -123.016647, 48.580244, -123.023206615953, 48.5845746092944, -123.028982347697, 48.5883877041088, -123.033093576815, 48.5911019067628, -123.034101, 48.591767, -123.024902, 48.594484, -123.023433, 48.599477, -123.041189, 48.611947, -123.046453150843, 48.6114965755598, -123.04653, 48.61149, -123.048652, 48.621002, -123.040078194353, 48.6254322142389, -123.023495, 48.634001, -123.015592, 48.642567, -123.014829, 48.647503, -123.009977399319, 48.654981685575, -123.009924, 48.655064, -123.001295006939, 48.6600601213626, -122.99988983534, 48.6608737050326, -122.988884, 48.667246, -122.984853, 48.672686, -122.970595802002, 48.6809490071059, -122.949116, 48.693398, -122.941316, 48.702904, -122.942367, 48.706723, -122.927109877131, 48.7110138483226, -122.918837934242, 48.7133402143466, -122.918252, 48.713505, -122.908658361456, 48.714123538823, -122.907454714043, 48.7142011426071, -122.906298643435, 48.7142756789313};
    private static final double[] SAN_JUAN_COUNTY_3 = new double[]{-123.172066, 48.679866, -123.14799, 48.668001, -123.133285875321, 48.6583191438863, -123.130962, 48.656789, -123.122016049879, 48.647064627471, -123.106165, 48.633473, -123.119677246557, 48.6329724058636, -123.134956336931, 48.6372395392956, -123.170932260699, 48.6515091289271, -123.197404105632, 48.6620089945159, -123.215917, 48.669352, -123.229744313989, 48.678544158148, -123.233070031572, 48.6807550374269, -123.237148, 48.683466, -123.237135383772, 48.6835850832961, -123.236567, 48.68895, -123.213499856684, 48.6896934099409, -123.212892, 48.689713, -123.212464368268, 48.6895683569085, -123.202992056872, 48.6863644216061, -123.197953, 48.68466, -123.186997647353, 48.6848970569698, -123.186076, 48.684917, -123.184143390981, 48.6842202399606, -123.183803136584, 48.6840975686572, -123.172066, 48.679866};
    private static final double[] SNOHOMISH_COUNTY = new double[]{-121.835846, 48.298013, -121.706923, 48.298052, -121.684141, 48.298531, -121.636515, 48.298531, -121.577636, 48.299232, -121.577236, 48.297432, -121.568862, 48.297267, -121.56018, 48.297096, -121.534083, 48.296375, -121.534083, 48.296375, -121.52672, 48.296236, -121.52672, 48.296236, -121.428086, 48.295934, -121.414025, 48.295934, -121.414025, 48.295934, -121.4136, 48.295934, -121.4136, 48.295934, -121.126218, 48.296042, -121.014631, 48.295602, -121.014631, 48.295602, -121.001414, 48.295548, -121.001414, 48.295548, -121.000315, 48.294748, -121.000315, 48.294148, -121.001215, 48.289547, -121.002615, 48.285947, -121.009915, 48.284547, -121.011315, 48.283047, -121.011615, 48.280447, -121.010115, 48.278147, -121.004314, 48.272947, -121.004614, 48.269947, -121.003914, 48.267247, -120.999864, 48.262452, -120.991213, 48.255847, -120.986913, 48.254348, -120.982613, 48.251548, -120.980813, 48.249548, -120.980613, 48.247048, -120.980113, 48.246148, -120.972213, 48.235148, -120.964613, 48.230648, -120.962013, 48.230148, -120.959613, 48.228248, -120.959313, 48.227048, -120.962613, 48.220847, -120.964613, 48.214547, -120.963912, 48.211047, -120.963184, 48.210733, -120.963184, 48.210733, -120.951312, 48.209147, -120.946812, 48.201447, -120.940338, 48.199957, -120.932512, 48.197248, -120.923112, 48.191348, -120.919512, 48.188148, -120.916112, 48.179648, -120.911411, 48.176048, -120.908811, 48.172848, -120.906211, 48.163848, -120.906211, 48.163848, -120.915811, 48.159447, -120.923511, 48.160647, -120.927712, 48.161847, -120.930812, 48.161647, -120.933112, 48.159246, -120.932512, 48.157146, -120.932812, 48.156946, -120.939112, 48.155146, -120.941712, 48.155546, -120.947212, 48.155146, -120.954512, 48.152546, -120.955012, 48.151845, -120.955112, 48.149845, -120.959312, 48.145745, -120.962412, 48.143845, -120.964612, 48.141145, -120.964112, 48.133345, -120.961612, 48.130945, -120.958112, 48.129245, -120.956112, 48.126345, -120.956377, 48.124581, -120.956377, 48.124581, -120.956712, 48.123645, -120.955611, 48.121145, -120.951411, 48.116545, -120.948511, 48.115545, -120.945973, 48.115335, -120.945973, 48.115335, -120.946411, 48.113445, -120.947611, 48.112144, -120.950611, 48.111644, -120.952911, 48.110544, -120.952911, 48.110544, -120.954211, 48.108944, -120.956611, 48.108144, -120.961976, 48.109348, -120.962911, 48.109744, -120.971012, 48.109244, -120.971812, 48.108344, -120.970812, 48.106744, -120.971811, 48.103543, -120.974911, 48.101943, -120.979712, 48.097043, -120.980011, 48.095443, -120.980911, 48.094443, -120.984212, 48.093243, -120.985812, 48.093743, -120.998412, 48.088542, -121.004012, 48.081242, -121.015012, 48.075241, -121.022612, 48.078241, -121.031412, 48.07824, -121.035612, 48.07654, -121.036412, 48.07534, -121.040012, 48.07314, -121.047812, 48.070439, -121.052112, 48.070239, -121.052112, 48.070239, -121.062436, 48.070214, -121.062436, 48.070214, -121.071913, 48.067338, -121.080613, 48.061838, -121.082313, 48.061838, -121.089213, 48.064838, -121.094513, 48.064637, -121.099513, 48.063137, -121.100513, 48.062637, -121.101713, 48.060437, -121.103813, 48.058137, -121.107913, 48.056737, -121.114413, 48.057736, -121.116913, 48.057136, -121.120013, 48.051636, -121.122913, 48.049936, -121.128626, 48.047925, -121.1315, 48.043986, -121.138507, 48.043897, -121.153476, 48.040703, -121.153248, 48.038597, -121.149034, 48.033895, -121.149001, 48.030341, -121.141174, 48.02549, -121.130671, 48.020375, -121.129399, 48.018426, -121.128654, 48.015236, -121.125737, 48.010431, -121.123536, 48.008395, -121.118123, 48.006471, -121.117212, 47.999835, -121.118112, 47.997635, -121.119612, 47.996735, -121.121213, 47.996535, -121.124313, 47.994335, -121.130413, 47.987034, -121.13426, 47.985546, -121.13426, 47.985546, -121.139988, 47.983334, -121.147013, 47.981434, -121.148382, 47.978526, -121.148382, 47.978526, -121.148715, 47.97773, -121.148613, 47.970133, -121.155413, 47.961833, -121.158813, 47.959233, -121.163213, 47.957933, -121.164613, 47.956233, -121.164713, 47.953633, -121.163313, 47.951833, -121.161413, 47.947633, -121.161913, 47.944733, -121.166313, 47.938133, -121.170213, 47.937033, -121.170913, 47.936433, -121.172713, 47.933732, -121.172813, 47.931532, -121.172813, 47.931532, -121.170813, 47.924932, -121.178913, 47.919532, -121.179513, 47.918832, -121.179413, 47.917532, -121.173013, 47.914932, -121.171913, 47.914032, -121.171213, 47.912632, -121.172813, 47.908732, -121.175613, 47.906632, -121.180113, 47.899232, -121.178113, 47.895832, -121.176813, 47.895032, -121.175113, 47.885732, -121.166012, 47.879232, -121.163112, 47.879232, -121.160112, 47.880732, -121.157812, 47.878833, -121.157912, 47.876633, -121.157512, 47.875733, -121.155007, 47.871829, -121.152512, 47.869933, -121.151712, 47.867933, -121.151649, 47.866206, -121.151649, 47.866206, -121.150012, 47.861833, -121.147612, 47.859433, -121.147012, 47.856933, -121.150712, 47.854533, -121.152612, 47.852132, -121.153712, 47.845832, -121.149212, 47.843832, -121.138612, 47.842933, -121.133212, 47.840333, -121.126611, 47.839233, -121.123211, 47.838133, -121.121311, 47.837033, -121.121211, 47.833133, -121.120511, 47.831733, -121.119111, 47.831033, -121.119111, 47.831033, -121.107411, 47.828833, -121.091611, 47.832434, -121.078011, 47.834334, -121.076611, 47.832034, -121.075211, 47.831134, -121.070111, 47.830134, -121.07071, 47.826034, -121.075011, 47.821634, -121.078706, 47.818709, -121.078706, 47.818709, -121.081711, 47.815534, -121.082111, 47.812634, -121.086345, 47.807326, -121.086345, 47.807326, -121.093611, 47.799733, -121.099711, 47.796933, -121.103211, 47.796733, -121.106411, 47.795033, -121.109211, 47.792333, -121.109211, 47.788733, -121.111511, 47.787633, -121.115711, 47.787233, -121.120411, 47.784133, -121.120511, 47.782433, -121.11901, 47.779933, -121.11901, 47.779933, -121.18714, 47.780107, -121.192721333333, 47.7797896666667, -121.195512, 47.779131, -121.232875, 47.779297, -121.232875, 47.779297, -121.243947, 47.779347, -121.243947, 47.779347, -121.455615, 47.780328, -121.455715, 47.778328, -121.485155, 47.77794, -121.500513, 47.777733, -121.584519, 47.777526, -121.584537, 47.776726, -121.610457, 47.776788, -121.610457, 47.776788, -121.645526, 47.776871, -121.645526, 47.776871, -121.666777, 47.776922, -121.751227, 47.777123, -121.751227, 47.777123, -121.763454, 47.776911, -121.763454, 47.776911, -121.83885, 47.777163, -121.83885, 47.777163, -121.849653, 47.777223, -121.850431, 47.777215, -121.863172, 47.777223, -121.863172, 47.777223, -121.864759, 47.777223, -121.864759, 47.777223, -121.887572, 47.776544, -121.922989, 47.776925, -121.928146, 47.776971, -121.928146, 47.776971, -121.932762, 47.776894, -121.932762, 47.776894, -121.943467, 47.776674, -121.943467, 47.776674, -121.960557, 47.776329, -121.960557, 47.776329, -121.967149, 47.776138, -121.967149, 47.776138, -121.967576, 47.776192, -121.967576, 47.776192, -121.96766, 47.776188, -121.96766, 47.776188, -121.96791, 47.776177, -121.968079, 47.776169, -121.968079, 47.776169, -121.975389, 47.775887, -121.975389, 47.775887, -121.999651, 47.775284, -121.999651, 47.775284, -122.001512, 47.775284, -122.001512, 47.775284, -122.010148, 47.775339, -122.010148, 47.775339, -122.014113, 47.775364, -122.014113, 47.775364, -122.023485, 47.775431, -122.036019, 47.775707, -122.045062, 47.775564, -122.053927, 47.775429, -122.053927, 47.775429, -122.054706, 47.775429, -122.067798, 47.77562, -122.074267, 47.775734, -122.076342, 47.775765, -122.0806, 47.775726, -122.0806, 47.775726, -122.082232, 47.775673, -122.083026, 47.775642, -122.083026, 47.775642, -122.091044, 47.775672, -122.093211, 47.775671, -122.093211, 47.775671, -122.094518, 47.77567, -122.094518, 47.77567, -122.095362, 47.77567, -122.095362, 47.77567, -122.100848, 47.775667, -122.100848, 47.775667, -122.101443, 47.775667, -122.101443, 47.775667, -122.102608, 47.775666, -122.102608, 47.775666, -122.1059, 47.775664, -122.107258, 47.775664, -122.108921, 47.775664, -122.108921, 47.775664, -122.111873, 47.775662, -122.111873, 47.775662, -122.112797, 47.775661, -122.11641, 47.775658, -122.11641, 47.775658, -122.118122, 47.775657, -122.118122, 47.775657, -122.131641, 47.775794, -122.131641, 47.775794, -122.151767, 47.776019, -122.151767, 47.776019, -122.152866, 47.77602, -122.152866, 47.77602, -122.153636, 47.77602, -122.153636, 47.77602, -122.154036, 47.77602, -122.154536, 47.77612, -122.154836, 47.77602, -122.154836, 47.77602, -122.158036, 47.77602, -122.158036, 47.77602, -122.164036, 47.77602, -122.166936, 47.77612, -122.169564, 47.77612, -122.169836, 47.77612, -122.171921, 47.77612, -122.171921, 47.77612, -122.175429, 47.77612, -122.181537, 47.77632, -122.187252, 47.776236, -122.191037, 47.77622, -122.191037, 47.77622, -122.201737, 47.77642, -122.201737, 47.77642, -122.203237, 47.77642, -122.203237, 47.77642, -122.207037, 47.77642, -122.212437, 47.77652, -122.212437, 47.77652, -122.216937, 47.77652, -122.220261, 47.776574, -122.223137, 47.77662, -122.223137, 47.77662, -122.226137, 47.77662, -122.226137, 47.77662, -122.227282, 47.776637, -122.227282, 47.776637, -122.231138, 47.776694, -122.231138, 47.776694, -122.232937, 47.77672, -122.232937, 47.77672, -122.237537, 47.77682, -122.237537, 47.77682, -122.237596, 47.77682, -122.237596, 47.77682, -122.243862, 47.776891, -122.245475, 47.776817, -122.248692, 47.776671, -122.248692, 47.776671, -122.249137, 47.776819, -122.249137, 47.776819, -122.253138, 47.776919, -122.257838, 47.776919, -122.257838, 47.776919, -122.260738, 47.776919, -122.260738, 47.776919, -122.263338, 47.776919, -122.263338, 47.776919, -122.265175, 47.776832, -122.265175, 47.776832, -122.265438, 47.776819, -122.265438, 47.776819, -122.266838, 47.777019, -122.271038, 47.777019, -122.281539, 47.777019, -122.281539, 47.777019, -122.284239, 47.777019, -122.287039, 47.777119, -122.288478, 47.777236, -122.290339, 47.777319, -122.293739, 47.777219, -122.297939, 47.777319, -122.303039, 47.777419, -122.304039, 47.777419, -122.305739, 47.777319, -122.305739, 47.777319, -122.308339, 47.777419, -122.30964, 47.777419, -122.30964, 47.777419, -122.31374, 47.777419, -122.31804, 47.777519, -122.32304, 47.777519, -122.32464, 47.777519, -122.32654, 47.777619, -122.32994, 47.777619, -122.33534, 47.777619, -122.337541, 47.777619, -122.346241, 47.777719, -122.347641, 47.777719, -122.347641, 47.777719, -122.351741, 47.777719, -122.351741, 47.777719, -122.356141, 47.777719, -122.358041, 47.777819, -122.358041, 47.777819, -122.361541, 47.777719, -122.364141, 47.777819, -122.364141, 47.777819, -122.366842, 47.777819, -122.372142, 47.777819, -122.372142, 47.777819, -122.377442, 47.777919, -122.377442, 47.777919, -122.380042, 47.777919, -122.380042, 47.777919, -122.382742, 47.777919, -122.386961, 47.777919, -122.386961, 47.777919, -122.388142, 47.777919, -122.388142, 47.777919, -122.389442, 47.777919, -122.389442, 47.777919, -122.393142, 47.778019, -122.394543, 47.777919, -122.396421740573, 47.7779275945007, -122.396421740573, 47.7779275945007, -122.397043, 47.779719, -122.396534465244, 47.7854364424491, -122.394944, 47.803318, -122.392044, 47.807718, -122.384862811656, 47.8138072035186, -122.380307756354, 47.8176696086589, -122.374217477324, 47.8228337885573, -122.360724049282, 47.8342753808922, -122.353244, 47.840618, -122.350684564244, 47.8413056096062, -122.348752434043, 47.8418246893617, -122.346544, 47.842418, -122.341304034102, 47.8458319171763, -122.339944, 47.846718, -122.339827791549, 47.8468805870871, -122.339804214125, 47.8469135742284, -122.33751141739, 47.8501214230407, -122.33638786629, 47.8516933818662, -122.33595, 47.852306, -122.335784639446, 47.8527477876357, -122.33512517318, 47.8545096591012, -122.333337627946, 47.8592853771399, -122.333244646775, 47.8595337914727, -122.333166059793, 47.8597437493864, -122.331377698213, 47.8645216484286, -122.329545, 47.869418, -122.330145, 47.875318, -122.33289861563, 47.8793114719903, -122.333512967759, 47.8802024452958, -122.333543, 47.880246, -122.333519287997, 47.880329853273, -122.333419884438, 47.8806813762436, -122.329940049111, 47.8929871937493, -122.328546, 47.897917, -122.327964226333, 47.8991241434502, -122.327508748944, 47.9000692301347, -122.325851976752, 47.9035069273256, -122.324721848515, 47.9058518717186, -122.322126419367, 47.9112372225398, -122.321988336234, 47.9115237362806, -122.321847, 47.911817, -122.321670246555, 47.9120287856595, -122.317894659318, 47.9165526874842, -122.313758740151, 47.9215083383773, -122.311922524155, 47.9237084890754, -122.310747, 47.925117, -122.309747, 47.929117, -122.311148, 47.936717, -122.308432988273, 47.9449282549786, -122.307396400753, 47.9480633001614, -122.307048, 47.949117, -122.30478381513, 47.9496947375965, -122.292823906295, 47.9527464711706, -122.291553132752, 47.9530707263417, -122.278047, 47.956517, -122.265513875538, 47.9578074284483, -122.260369648484, 47.958337085435, -122.259748739263, 47.9584010151379, -122.249007, 47.959507, -122.240423047546, 47.9646724921948, -122.240210295359, 47.9648005182721, -122.233273935967, 47.9689745523765, -122.231285123904, 47.9701713429279, -122.230046, 47.970917, -122.226346, 47.976417, -122.228793923343, 47.9809913163084, -122.229977428044, 47.9832028744728, -122.229988452089, 47.9832234745734, -122.232135020607, 47.9872346636528, -122.232141937724, 47.9872475893342, -122.232229101693, 47.9874104684412, -122.232391, 47.987713, -122.23022, 48.007154, -122.228767, 48.012468, -122.225088297986, 48.0165060261282, -122.224979, 48.016626, -122.225798126625, 48.0182263284835, -122.230710998705, 48.0278246114484, -122.231761, 48.029876, -122.232321504034, 48.0301023219974, -122.254599886597, 48.0390979540272, -122.262767321792, 48.04239582547, -122.281087, 48.049793, -122.283631375812, 48.0522213158429, -122.288294092955, 48.0566713463202, -122.293714987741, 48.0618449706844, -122.298354311474, 48.0662726748267, -122.305396518801, 48.0729936566653, -122.305838, 48.073415, -122.305965092455, 48.0735118308217, -122.321709, 48.085507, -122.326119, 48.092877, -122.343241, 48.097631, -122.363352984442, 48.1233057283549, -122.363842, 48.12393, -122.365078, 48.125822, -122.365061393677, 48.126041563845, -122.365057215413, 48.1260968076112, -122.364525958075, 48.1331209337108, -122.364098326614, 48.1387749493718, -122.363797, 48.142759, -122.363828056996, 48.1430392344557, -122.364744, 48.151304, -122.365735739464, 48.1537351928586, -122.367846276966, 48.1589090554402, -122.368583107934, 48.1607153546274, -122.37014407346, 48.1645419727863, -122.370204412539, 48.1646898906043, -122.370224407165, 48.1647389062914, -122.370253, 48.164809, -122.369253922575, 48.1662291530152, -122.364124285504, 48.173520749613, -122.363479, 48.174438, -122.362044, 48.187568, -122.372492, 48.193022, -122.372500330439, 48.1930342087307, -122.372618769131, 48.1932077873503, -122.376763295846, 48.1992818262957, -122.378057879514, 48.201179112079, -122.382102, 48.207106, -122.385703, 48.217811, -122.387682622564, 48.2199814020855, -122.388193386812, 48.2205413895339, -122.388771591929, 48.2211753172402, -122.390597938308, 48.2231776716597, -122.394813168535, 48.2277991306402, -122.395512417791, 48.2285657677103, -122.395512417791, 48.2285657677103, -122.394763, 48.23011, -122.394763, 48.23011, -122.392536, 48.234574, -122.392612, 48.237877, -122.394565, 48.239624, -122.399113, 48.242005, -122.404259, 48.249452, -122.404259, 48.249452, -122.405756181268, 48.2521938138136, -122.405756181268, 48.2521938138136, -122.395328, 48.257187, -122.392058, 48.269628, -122.371693, 48.287839, -122.376818, 48.296099, -122.378210535294, 48.2975904179386, -122.378210535294, 48.2975904179386, -122.36565, 48.297613, -122.36565, 48.297613, -122.365342, 48.297613, -122.365342, 48.297613, -122.35297, 48.297553, -122.335067, 48.297485, -122.335067, 48.297485, -122.324656, 48.297532, -122.304895, 48.297715, -122.304895, 48.297715, -122.30445, 48.297715, -122.30445, 48.297715, -122.292087, 48.297759, -122.292087, 48.297759, -122.275001, 48.297675, -122.25301, 48.297567, -122.25301, 48.297567, -122.251997, 48.297561, -122.251997, 48.297561, -122.226185, 48.297375, -122.205616, 48.297327, -122.205616, 48.297327, -122.204964, 48.297326, -122.204964, 48.297326, -122.201531, 48.297315, -122.1874, 48.29726, -122.1874, 48.29726, -122.184618, 48.297258, -122.184618, 48.297258, -122.175875, 48.297261, -122.175875, 48.297261, -122.170401, 48.29732, -122.170401, 48.29732, -122.169406, 48.297331, -122.169406, 48.297331, -122.164651, 48.297403, -122.164651, 48.297403, -122.140276, 48.297769, -122.035569, 48.297692, -122.0009, 48.297527, -122.0009, 48.297527, -122.000793, 48.297543, -122.000793, 48.297543, -121.998002, 48.29755, -121.98166, 48.297596, -121.98166, 48.297596, -121.97207, 48.297624, -121.97207, 48.297624, -121.945086, 48.297675, -121.93572, 48.297696, -121.92403, 48.297722, -121.92403, 48.297722, -121.915424, 48.297698, -121.915424, 48.297698, -121.905052, 48.297651, -121.876247, 48.297518, -121.859728, 48.297943, -121.859728, 48.297943, -121.857286, 48.297951, -121.857286, 48.297951, -121.85648, 48.297953, -121.835921, 48.298013, -121.835921, 48.298013, -121.835846, 48.298013};

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            String string = "ExceptionWhileSettingSystemLookAndFeel";
            Logging.logger().log(Level.WARNING, string, exception);
        }
        Airspaces.start("World Wind Airspaces", AppFrame.class);
    }

    private static Iterable<LatLon> makeLatLon(double[] dArray, int n, int n2) {
        int n3 = (int)Math.floor((double)n2 / 2.0);
        LatLon[] latLonArray = new LatLon[n3];
        for (int i = 0; i < n3; ++i) {
            double d = dArray[n + 2 * i];
            double d2 = dArray[n + 2 * i + 1];
            latLonArray[i] = LatLon.fromDegrees(d2, d);
        }
        return Arrays.asList(latLonArray);
    }

    private static Iterable<LatLon> makeLatLon(double[] dArray) {
        return Airspaces.makeLatLon(dArray, 0, dArray.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AirspacesController
    implements ActionListener {
        private JFileChooser fileChooser;
        private JButton readButton;
        private JButton saveButton;
        private AppFrame frame;
        private WorldWindowGLCanvas wwd;
        private AirspaceLayer airspaceLayer;
        private AnnotationLayer annotationLayer;
        private Airspace lastHighlit;
        private Airspace lastToolTip;
        private AirspaceAttributes lastAttrs;
        private Annotation lastAnnotation;
        private BasicDragger dragger;

        public AirspacesController(WorldWindowGLCanvas worldWindowGLCanvas) {
            this.wwd = worldWindowGLCanvas;
            this.airspaceLayer = new AirspaceLayer();
            this.annotationLayer = new AnnotationLayer();
            this.airspaceLayer.setName(Airspaces.AIRSPACE_LAYER_NAME);
            this.annotationLayer.setName(Airspaces.ANNOTATION_LAYER_NAME);
            ApplicationTemplate.insertBeforePlacenames(this.wwd, this.airspaceLayer);
            ApplicationTemplate.insertBeforePlacenames(this.wwd, this.annotationLayer);
            this.initializeSelectionMonitoring();
            String string = Configuration.getStringValue(Airspaces.DRAW_AIRSPACE_EXTENT);
            if (string != null) {
                this.airspaceLayer.setDrawExtents(Boolean.parseBoolean(string));
            }
            if ((string = Configuration.getStringValue(Airspaces.DRAW_AIRSPACE_WIREFRAME)) != null) {
                this.airspaceLayer.setDrawWireframe(Boolean.parseBoolean(string));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (Airspaces.ACTION_COMMAND_LOAD_DEMO_AIRSPACES.equalsIgnoreCase(actionEvent.getActionCommand())) {
                this.airspaceLayer.removeAllAirspaces();
                this.doLoadDemoAirspaces();
            } else if (Airspaces.ACTION_COMMAND_ZOOM_TO_DEMO_AIRSPACES.equalsIgnoreCase(actionEvent.getActionCommand())) {
                this.doZoomToAirspaces();
            } else if (Airspaces.ACTION_COMMAND_SAVE_AIRSPACES.equalsIgnoreCase(actionEvent.getActionCommand())) {
                this.doSaveAirspaces();
            } else if (Airspaces.ACTION_COMMAND_READ_AIRSPACES.equalsIgnoreCase(actionEvent.getActionCommand())) {
                this.doReadAirspaces();
            } else if (Airspaces.ACTION_COMMAND_VERTICAL_EXAGGERATION.equalsIgnoreCase(actionEvent.getActionCommand())) {
                Double d = (Double)actionEvent.getSource();
                this.doSetVerticalExaggeration(d);
            }
        }

        public void setAirspaces(Collection<Airspace> collection) {
            this.airspaceLayer.removeAllAirspaces();
            if (collection != null) {
                for (Airspace airspace : collection) {
                    if (airspace == null) continue;
                    this.airspaceLayer.addAirspace(airspace);
                }
            }
        }

        public void initializeSelectionMonitoring() {
            this.dragger = new BasicDragger(this.wwd);
            this.wwd.addSelectListener(new SelectListener(){

                public void selected(SelectEvent selectEvent) {
                    if (!(AirspacesController.this.lastHighlit == null || selectEvent.getTopObject() != null && selectEvent.getTopObject().equals(AirspacesController.this.lastHighlit))) {
                        AirspacesController.this.lastHighlit.setAttributes(AirspacesController.this.lastAttrs);
                        AirspacesController.this.lastHighlit = null;
                    }
                    if (!(AirspacesController.this.lastToolTip == null || selectEvent.getTopObject() != null && selectEvent.getTopObject().equals(AirspacesController.this.lastHighlit))) {
                        AirspacesController.this.annotationLayer.removeAnnotation(AirspacesController.this.lastAnnotation);
                        AirspacesController.this.lastToolTip = null;
                    }
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !AirspacesController.this.dragger.isDragging()) {
                        if (selectEvent.getTopObject() != null && selectEvent.getTopPickedObject().getParentLayer() != null && selectEvent.getTopPickedObject().getParentLayer() == AirspacesController.this.airspaceLayer) {
                            AirspacesController.this.highlight(selectEvent.getTopObject());
                            AirspacesController.this.wwd.redraw();
                        }
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Hover") && !AirspacesController.this.dragger.isDragging()) {
                        if (selectEvent.getTopObject() != null && selectEvent.getTopPickedObject().getParentLayer() != null && selectEvent.getTopPickedObject().getParentLayer() == AirspacesController.this.airspaceLayer) {
                            AirspacesController.this.popupToolTip(selectEvent.getTopObject(), selectEvent);
                            AirspacesController.this.wwd.redraw();
                        }
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                        PickedObjectList pickedObjectList;
                        AirspacesController.this.dragger.selected(selectEvent);
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AirspacesController.this.wwd.getObjectsAtCurrentPosition()) != null) {
                            AirspacesController.this.highlight(pickedObjectList.getTopObject());
                            AirspacesController.this.wwd.repaint();
                        }
                    }
                }
            });
        }

        private void highlight(Object object) {
            if (this.lastHighlit == object) {
                return;
            }
            if (this.lastHighlit == null && object instanceof Airspace) {
                this.lastHighlit = (Airspace)object;
                this.lastAttrs = this.lastHighlit.getAttributes();
                BasicAirspaceAttributes basicAirspaceAttributes = new BasicAirspaceAttributes(this.lastAttrs);
                basicAirspaceAttributes.setMaterial(Material.WHITE);
                this.lastHighlit.setAttributes(basicAirspaceAttributes);
            }
        }

        private void popupToolTip(Object object, SelectEvent selectEvent) {
            if (this.lastToolTip == object) {
                return;
            }
            if (this.lastToolTip == null && object instanceof Airspace) {
                this.lastToolTip = (Airspace)object;
                this.lastAnnotation = this.createToolTip((Airspace)object, selectEvent);
                this.annotationLayer.addAnnotation(this.lastAnnotation);
            }
        }

        private Annotation createToolTip(Airspace airspace, SelectEvent selectEvent) {
            Object object = airspace.getValue(Airspaces.DESCRIPTION);
            if (object == null) {
                object = airspace.getClass().getName();
            }
            Point point = selectEvent.getPickPoint();
            AnnotationAttributes annotationAttributes = new AnnotationAttributes();
            annotationAttributes.setBackgroundColor(Color.WHITE);
            annotationAttributes.setBorderColor(Color.BLACK);
            annotationAttributes.setTextColor(Color.BLACK);
            annotationAttributes.setOpacity(0.8);
            annotationAttributes.setDistanceMaxScale(1.0);
            annotationAttributes.setDistanceMinScale(1.0);
            Position position = this.wwd.getView().computePositionFromScreenPoint(point.x, point.y);
            if (position != null) {
                double[] dArray = airspace.getAltitudes();
                position = new Position(position.getLatitude(), position.getLongitude(), dArray[1]);
                return new GlobeAnnotation(object.toString(), position, annotationAttributes);
            }
            return new ScreenAnnotation(object.toString(), point, annotationAttributes);
        }

        private void setupDefaultMaterial(Airspace airspace, Color color) {
            Color color2 = this.makeBrighter(color);
            airspace.getAttributes().setDrawOutline(true);
            airspace.getAttributes().setMaterial(new Material(color));
            airspace.getAttributes().setOutlineMaterial(new Material(color2));
            airspace.getAttributes().setOpacity(0.8);
            airspace.getAttributes().setOutlineOpacity(0.9);
            airspace.getAttributes().setOutlineWidth(3.0);
        }

        private Color makeBrighter(Color color) {
            float[] fArray = new float[3];
            Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
            float f = fArray[0];
            float f2 = fArray[1];
            float f3 = fArray[2];
            f2 /= 3.0f;
            f3 *= 3.0f;
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            int n = Color.HSBtoRGB(f, f2, f3);
            return new Color(n);
        }

        public void doLoadDemoAirspaces() {
            ArrayList<Airspace> arrayList = new ArrayList<Airspace>();
            CappedCylinder cappedCylinder = new CappedCylinder();
            cappedCylinder.setCenter(LatLon.fromDegrees(47.7477, -123.6372));
            cappedCylinder.setRadius(30000.0);
            cappedCylinder.setAltitudes(5000.0, 10000.0);
            cappedCylinder.setTerrainConforming(true, true);
            cappedCylinder.setValue(Airspaces.DESCRIPTION, "30,000m Radius Cylinder. Top & bottom terrain conformance.");
            this.setupDefaultMaterial(cappedCylinder, Color.BLUE);
            arrayList.add(cappedCylinder);
            cappedCylinder = new CappedCylinder();
            cappedCylinder.setCenter(LatLon.fromDegrees(0.0, 0.0));
            cappedCylinder.setRadius(3000000.0);
            cappedCylinder.setAltitudes(100000.0, 500000.0);
            cappedCylinder.setTerrainConforming(true, false);
            cappedCylinder.setValue(Airspaces.DESCRIPTION, "3,000,000m Cylinder.");
            this.setupDefaultMaterial(cappedCylinder, Color.RED);
            arrayList.add(cappedCylinder);
            PartialCappedCylinder partialCappedCylinder = new PartialCappedCylinder();
            partialCappedCylinder.setCenter(LatLon.fromDegrees(46.7477, -123.6372));
            partialCappedCylinder.setAltitudes(5000.0, 10000.0);
            partialCappedCylinder.setTerrainConforming(false, true);
            partialCappedCylinder.setRadii(15000.0, 30000.0);
            partialCappedCylinder.setAzimuths(Angle.fromDegrees(0.0), Angle.fromDegrees(90.0));
            partialCappedCylinder.setValue(Airspaces.DESCRIPTION, "Partial Cylinder from 0 to 90 degrees.");
            this.setupDefaultMaterial(partialCappedCylinder, Color.DARK_GRAY);
            arrayList.add(partialCappedCylinder);
            partialCappedCylinder = new PartialCappedCylinder();
            partialCappedCylinder.setCenter(LatLon.fromDegrees(46.7477, -122.6372));
            partialCappedCylinder.setAltitudes(5000.0, 10000.0);
            partialCappedCylinder.setTerrainConforming(true, true);
            partialCappedCylinder.setRadii(15000.0, 30000.0);
            partialCappedCylinder.setAzimuths(Angle.fromDegrees(90.0), Angle.fromDegrees(0.0));
            partialCappedCylinder.setValue(Airspaces.DESCRIPTION, "Partial Cylinder from 90 to 0 degrees.");
            this.setupDefaultMaterial(partialCappedCylinder, Color.GRAY);
            arrayList.add(partialCappedCylinder);
            Cake cake = new Cake();
            cake.setLayers(Arrays.asList(new Cake.Layer(LatLon.fromDegrees(46.7477, -121.6372), 10000.0, Angle.fromDegrees(190.0), Angle.fromDegrees(170.0), 10000.0, 15000.0), new Cake.Layer(LatLon.fromDegrees(46.7477, -121.6372), 15000.0, Angle.fromDegrees(190.0), Angle.fromDegrees(90.0), 16000.0, 21000.0), new Cake.Layer(LatLon.fromDegrees(46.7477, -121.6372), 12500.0, Angle.fromDegrees(270.0), Angle.fromDegrees(60.0), 22000.0, 27000.0)));
            cake.getLayers().get(0).setTerrainConforming(false, false);
            cake.getLayers().get(1).setTerrainConforming(false, false);
            cake.getLayers().get(2).setTerrainConforming(false, true);
            cake.setValue(Airspaces.DESCRIPTION, "3 layer Cake.");
            this.setupDefaultMaterial(cake, Color.YELLOW);
            arrayList.add(cake);
            cake = new Cake();
            cake.setLayers(Arrays.asList(new Cake.Layer(LatLon.fromDegrees(36.0, -121.0), 10000.0, Angle.fromDegrees(0.0), Angle.fromDegrees(360.0), 10000.0, 15000.0), new Cake.Layer(LatLon.fromDegrees(36.1, -121.1), 15000.0, Angle.fromDegrees(0.0), Angle.fromDegrees(360.0), 16000.0, 21000.0), new Cake.Layer(LatLon.fromDegrees(35.9, -120.9), 12500.0, Angle.fromDegrees(0.0), Angle.fromDegrees(360.0), 22000.0, 27000.0)));
            cake.getLayers().get(0).setTerrainConforming(true, true);
            cake.getLayers().get(1).setTerrainConforming(true, true);
            cake.getLayers().get(2).setTerrainConforming(true, true);
            cake.setValue(Airspaces.DESCRIPTION, "3 layer Cake. With disjoint layers.");
            this.setupDefaultMaterial(cake, Color.MAGENTA);
            arrayList.add(cake);
            Orbit orbit = new Orbit();
            orbit.setLocations(LatLon.fromDegrees(45.7477, -123.6372), LatLon.fromDegrees(45.7477, -122.6372));
            orbit.setAltitudes(10000.0, 20000.0);
            orbit.setWidth(30000.0);
            orbit.setOrbitType("Left");
            orbit.setTerrainConforming(false, true);
            orbit.setValue(Airspaces.DESCRIPTION, "LEFT Orbit.");
            this.setupDefaultMaterial(orbit, Color.LIGHT_GRAY);
            arrayList.add(orbit);
            orbit = new Orbit();
            orbit.setLocations(LatLon.fromDegrees(45.7477, -123.6372), LatLon.fromDegrees(45.7477, -122.6372));
            orbit.setAltitudes(15000.0, 25000.0);
            orbit.setWidth(30000.0);
            orbit.setOrbitType("Center");
            orbit.setTerrainConforming(true, false);
            orbit.setValue(Airspaces.DESCRIPTION, "CENTER Orbit.");
            this.setupDefaultMaterial(orbit, Color.GRAY);
            arrayList.add(orbit);
            orbit = new Orbit();
            orbit.setLocations(LatLon.fromDegrees(45.7477, -123.6372), LatLon.fromDegrees(45.7477, -122.6372));
            orbit.setAltitudes(10000.0, 20000.0);
            orbit.setWidth(30000.0);
            orbit.setOrbitType("Right");
            orbit.setTerrainConforming(true, true);
            orbit.setValue(Airspaces.DESCRIPTION, "RIGHT Orbit.");
            this.setupDefaultMaterial(orbit, Color.DARK_GRAY);
            arrayList.add(orbit);
            orbit = new Orbit();
            orbit.setLocations(LatLon.fromDegrees(34.0489, -118.2481), LatLon.fromDegrees(40.7137, -74.0065));
            orbit.setAltitudes(10000.0, 100000.0);
            orbit.setWidth(500000.0);
            orbit.setOrbitType("Center");
            orbit.setTerrainConforming(true, false);
            orbit.setValue(Airspaces.DESCRIPTION, "Orbit From L.A. to N.Y.");
            this.setupDefaultMaterial(orbit, Color.RED);
            arrayList.add(orbit);
            Curtain curtain = new Curtain();
            curtain.setLocations(Airspaces.makeLatLon(SNOHOMISH_COUNTY));
            curtain.setAltitudes(5000.0, 10000.0);
            curtain.setTerrainConforming(true, false);
            curtain.setValue(Airspaces.DESCRIPTION, "Curtain around Snohomish County, WA.");
            this.setupDefaultMaterial(curtain, Color.GREEN);
            arrayList.add(curtain);
            curtain = new Curtain();
            curtain.setLocations(Airspaces.makeLatLon(SAN_JUAN_COUNTY_2));
            curtain.setAltitudes(5000.0, 10000.0);
            curtain.setTerrainConforming(true, true);
            curtain.setValue(Airspaces.DESCRIPTION, "Curtain around San Juan County, WA.");
            this.setupDefaultMaterial(curtain, Color.GREEN);
            arrayList.add(curtain);
            curtain = new Curtain();
            curtain.setLocations(Arrays.asList(LatLon.fromDegrees(27.0, -112.0), LatLon.fromDegrees(35.0, 138.0)));
            curtain.setAltitudes(1000.0, 100000.0);
            curtain.setTerrainConforming(true, false);
            curtain.setValue(Airspaces.DESCRIPTION, "Great arc Curtain from America to Japan.");
            this.setupDefaultMaterial(curtain, Color.MAGENTA);
            arrayList.add(curtain);
            curtain = new Curtain();
            curtain.setLocations(Arrays.asList(LatLon.fromDegrees(27.0, -112.0), LatLon.fromDegrees(35.0, 138.0)));
            curtain.setPathType("gov.nasa.worldwind.avkey.RhumbLine");
            curtain.setAltitudes(1000.0, 100000.0);
            curtain.setTerrainConforming(false, true);
            curtain.setValue(Airspaces.DESCRIPTION, "Rhumb Curtain from America to Japan.");
            this.setupDefaultMaterial(curtain, Color.CYAN);
            arrayList.add(curtain);
            Polygon polygon = new Polygon();
            polygon.setLocations(Airspaces.makeLatLon(SAN_JUAN_COUNTY_1));
            polygon.setAltitudes(5000.0, 10000.0);
            polygon.setTerrainConforming(true, true);
            polygon.setValue(Airspaces.DESCRIPTION, "Polygon of San Juan County, WA.");
            this.setupDefaultMaterial(polygon, Color.GREEN);
            arrayList.add(polygon);
            polygon = new Polygon();
            polygon.setLocations(Airspaces.makeLatLon(SAN_JUAN_COUNTY_3));
            polygon.setAltitudes(5000.0, 10000.0);
            polygon.setTerrainConforming(true, true);
            polygon.setValue(Airspaces.DESCRIPTION, "Polygon of San Juan County, WA.");
            this.setupDefaultMaterial(polygon, Color.GREEN);
            arrayList.add(polygon);
            polygon = new Polygon();
            polygon.setLocations(Arrays.asList(LatLon.fromDegrees(40.1323, -122.0911), LatLon.fromDegrees(38.0062, -120.7711), LatLon.fromDegrees(37.0562, -119.6226), LatLon.fromDegrees(36.9231, -118.1829), LatLon.fromDegrees(37.8211, -118.8557), LatLon.fromDegrees(39.0906, -120.0304), LatLon.fromDegrees(40.2609, -120.8295)));
            polygon.setAltitudes(10000.0, 100000.0);
            polygon.setTerrainConforming(true, true);
            polygon.setValue(Airspaces.DESCRIPTION, "Polygon over the Sierra Nevada mountains.");
            this.setupDefaultMaterial(polygon, Color.LIGHT_GRAY);
            arrayList.add(polygon);
            PolyArc polyArc = new PolyArc();
            polyArc.setLocations(Arrays.asList(LatLon.fromDegrees(45.5, -122.0), LatLon.fromDegrees(46.0, -122.0), LatLon.fromDegrees(46.0, -121.0), LatLon.fromDegrees(45.5, -121.0)));
            polyArc.setAltitudes(5000.0, 10000.0);
            polyArc.setRadius(30000.0);
            polyArc.setAzimuths(Angle.fromDegrees(-45.0), Angle.fromDegrees(135.0));
            polyArc.setTerrainConforming(true, true);
            this.setupDefaultMaterial(polyArc, Color.GRAY);
            arrayList.add(polyArc);
            Route route = new Route();
            route.setAltitudes(5000.0, 20000.0);
            route.setWidth(20000.0);
            route.setLocations(Arrays.asList(LatLon.fromDegrees(43.0, -121.0), LatLon.fromDegrees(44.0, -121.0), LatLon.fromDegrees(44.0, -120.0), LatLon.fromDegrees(43.0, -120.0)));
            route.setTerrainConforming(false, true);
            this.setupDefaultMaterial(route, Color.GREEN);
            arrayList.add(route);
            TrackAirspace trackAirspace = new TrackAirspace();
            trackAirspace.setEnableInnerCaps(false);
            double d = 100000.0;
            double d2 = 100000.0;
            double d3 = 150000.0;
            double d4 = 250000.0;
            trackAirspace.addLeg(LatLon.fromDegrees(40.4705, -117.9242), LatLon.fromDegrees(42.6139, -108.3518), d3, d4, d, d2);
            Box box = trackAirspace.addLeg(LatLon.fromDegrees(42.6139, -108.3518), LatLon.fromDegrees(44.9305, -97.6665), d3 / 2.0, d4 / 2.0, d, d2);
            box.setTerrainConforming(false, false);
            box = trackAirspace.addLeg(LatLon.fromDegrees(44.9305, -97.6665), LatLon.fromDegrees(47.0121, -94.9218), d3 / 2.0, d4 / 2.0, d, d2);
            box.setTerrainConforming(false, false);
            box = trackAirspace.addLeg(LatLon.fromDegrees(47.0121, -94.9218), LatLon.fromDegrees(44.7964, -68.423), d3 / 4.0, d4 / 4.0, d, d2);
            box.setTerrainConforming(true, false);
            this.setupDefaultMaterial(trackAirspace, Color.ORANGE);
            arrayList.add(trackAirspace);
            trackAirspace = new TrackAirspace();
            d = 80000.0;
            d2 = 80000.0;
            d3 = 150000.0;
            d4 = 250000.0;
            trackAirspace.addLeg(LatLon.fromDegrees(29.997, -108.6046), LatLon.fromDegrees(33.5132, -107.7544), d3 / 6.0, d4 / 6.0, d, d2).setTerrainConforming(false, false);
            trackAirspace.addLeg(LatLon.fromDegrees(29.4047, -103.0465), LatLon.fromDegrees(34.4955, -102.2151), d3 / 4.0, d4 / 4.0, d, d2).setTerrainConforming(false, true);
            trackAirspace.addLeg(LatLon.fromDegrees(28.9956, -99.8026), LatLon.fromDegrees(36.0133, -98.3489), d3 / 2.0, d4 / 2.0, d, d2).setTerrainConforming(true, true);
            trackAirspace.addLeg(LatLon.fromDegrees(28.5986, -96.6126), LatLon.fromDegrees(36.8515, -95.0324), d3, d4, d, d2).setTerrainConforming(true, false);
            trackAirspace.addLeg(LatLon.fromDegrees(30.4647, -94.1764), LatLon.fromDegrees(35.5636, -92.9371), d3 / 2.0, d4 / 2.0, d, d2).setTerrainConforming(false, false);
            trackAirspace.addLeg(LatLon.fromDegrees(31.0959, -90.9424), LatLon.fromDegrees(35.147, -89.4267), d3 / 4.0, d4 / 4.0, d, d2).setTerrainConforming(false, true);
            trackAirspace.addLeg(LatLon.fromDegrees(31.5107, -88.5723), LatLon.fromDegrees(34.2444, -87.4563), d3 / 6.0, d4 / 6.0, d, d2).setTerrainConforming(true, true);
            this.setupDefaultMaterial(trackAirspace, Color.MAGENTA);
            arrayList.add(trackAirspace);
            SphereAirspace sphereAirspace = new SphereAirspace();
            sphereAirspace.setLocation(LatLon.fromDegrees(47.7477, -122.6372));
            sphereAirspace.setAltitude(5000.0);
            sphereAirspace.setTerrainConforming(true);
            sphereAirspace.setRadius(5000.0);
            this.setupDefaultMaterial(sphereAirspace, Color.ORANGE);
            arrayList.add(sphereAirspace);
            sphereAirspace = new SphereAirspace();
            sphereAirspace.setLocation(LatLon.fromDegrees(47.7477, -121.6372));
            sphereAirspace.setAltitude(0.0);
            sphereAirspace.setTerrainConforming(true);
            sphereAirspace.setRadius(5000.0);
            this.setupDefaultMaterial(sphereAirspace, Color.MAGENTA);
            arrayList.add(sphereAirspace);
            sphereAirspace = new SphereAirspace();
            sphereAirspace.setLocation(LatLon.fromDegrees(0.0, -180.0));
            sphereAirspace.setAltitude(0.0);
            sphereAirspace.setTerrainConforming(false);
            sphereAirspace.setRadius(1000000.0);
            this.setupDefaultMaterial(sphereAirspace, Color.RED);
            arrayList.add(sphereAirspace);
            this.setAirspaces(arrayList);
        }

        public void doZoomToAirspaces() {
            OrbitView orbitView = (OrbitView)this.wwd.getView();
            Globe globe = this.wwd.getModel().getGlobe();
            Position position = Position.fromDegrees(46.7477, -122.6372, 0.0);
            Angle angle = Angle.fromDegrees(0.0);
            Angle angle2 = Angle.fromDegrees(30.0);
            double d = 600000.0;
            FlyToOrbitViewStateIterator flyToOrbitViewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator(orbitView, globe, position, angle, angle2, d, true);
            orbitView.applyStateIterator(flyToOrbitViewStateIterator);
        }

        public void doSaveAirspaces() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setCurrentDirectory(new File(Configuration.getCurrentWorkingDirectory()));
            }
            this.fileChooser.setDialogTitle("Choose Directory to Place Airspaces");
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setMultiSelectionEnabled(false);
            int n = this.fileChooser.showSaveDialog(null);
            if (n != 0) {
                return;
            }
            final File file = this.fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            AirspaceLayer airspaceLayer = (AirspaceLayer)this.wwd.getModel().getLayers().getLayerByName(Airspaces.AIRSPACE_LAYER_NAME);
            final Iterable<Airspace> iterable = airspaceLayer.getAirspaces();
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        DecimalFormat decimalFormat = new DecimalFormat("####");
                        decimalFormat.setMinimumIntegerDigits(4);
                        int n = 0;
                        for (Airspace airspace : iterable) {
                            String string = airspace.getRestorableState();
                            if (string == null) continue;
                            try {
                                PrintWriter printWriter = new PrintWriter(new File(file, airspace.getClass().getName() + "-" + decimalFormat.format(n++) + ".xml"));
                                printWriter.write(string);
                                printWriter.flush();
                                printWriter.close();
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                fileNotFoundException.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                AirspacesController.this.frame.setCursor(Cursor.getDefaultCursor());
                                AirspacesController.this.saveButton.setEnabled(true);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.saveButton.setEnabled(false);
            this.frame.setCursor(new Cursor(3));
            thread.start();
        }

        public void doReadAirspaces() {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser();
                this.fileChooser.setCurrentDirectory(new File(Configuration.getCurrentWorkingDirectory()));
            }
            this.fileChooser.setDialogTitle("Choose Airspace File Directory");
            this.fileChooser.setFileSelectionMode(1);
            this.fileChooser.setMultiSelectionEnabled(false);
            int n = this.fileChooser.showOpenDialog(null);
            if (n != 0) {
                return;
            }
            final File file = this.fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    ArrayList<Airspace> arrayList = new ArrayList<Airspace>();
                    try {
                        File[] fileArray;
                        for (File file2 : fileArray = file.listFiles(new FilenameFilter(){

                            public boolean accept(File file, String string) {
                                return string.startsWith("gov.nasa.worldwind.render.airspaces") && string.endsWith(".xml");
                            }
                        })) {
                            String[] stringArray = file2.getName().split("-");
                            try {
                                Class<?> clazz = Class.forName(stringArray[0]);
                                Airspace airspace = (Airspace)clazz.newInstance();
                                BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
                                String string = bufferedReader.readLine();
                                airspace.restoreState(string);
                                arrayList.add(airspace);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                classNotFoundException.printStackTrace();
                            }
                            catch (IllegalAccessException illegalAccessException) {
                                illegalAccessException.printStackTrace();
                            }
                            catch (InstantiationException instantiationException) {
                                instantiationException.printStackTrace();
                            }
                            catch (FileNotFoundException fileNotFoundException) {
                                fileNotFoundException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        SwingUtilities.invokeLater(new Runnable(arrayList){
                            final /* synthetic */ ArrayList val$airspaces;
                            {
                                this.val$airspaces = arrayList;
                            }

                            public void run() {
                                AirspacesController.this.setAirspaces(this.val$airspaces);
                                AirspacesController.this.wwd.redraw();
                                AirspacesController.this.frame.setCursor(Cursor.getDefaultCursor());
                                AirspacesController.this.readButton.setEnabled(true);
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
            this.readButton.setEnabled(false);
            this.frame.setCursor(new Cursor(3));
            thread.start();
        }

        public void doSetVerticalExaggeration(double d) {
            this.wwd.getSceneController().setVerticalExaggeration(d);
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private AirspacesController controller = new AirspacesController(this.getWwd());
        private LayerPanel layerPanel;

        public AppFrame() {
            super(true, false, false);
            this.controller.frame = this;
            this.makeComponents();
            this.controller.actionPerformed(new ActionEvent(this, 0, Airspaces.ACTION_COMMAND_LOAD_DEMO_AIRSPACES));
            this.getLayerPanel().update(this.getWwd());
            this.pack();
        }

        public LayerPanel getLayerPanel() {
            return this.layerPanel;
        }

        private void makeComponents() {
            this.getWwd().setPreferredSize(new Dimension(1024, 768));
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 10));
            jPanel2.setBorder(new EmptyBorder(20, 10, 20, 10));
            JPanel jPanel3 = new JPanel(new GridLayout(5, 1, 0, 5));
            JComponent jComponent = new JButton("Load Demo Airspaces");
            ((AbstractButton)jComponent).setActionCommand(Airspaces.ACTION_COMMAND_LOAD_DEMO_AIRSPACES);
            ((AbstractButton)jComponent).addActionListener(this.controller);
            jPanel3.add(jComponent);
            jComponent = new JButton("Zoom to Demo Airspaces");
            ((AbstractButton)jComponent).setActionCommand(Airspaces.ACTION_COMMAND_ZOOM_TO_DEMO_AIRSPACES);
            ((AbstractButton)jComponent).addActionListener(this.controller);
            jPanel3.add(jComponent);
            jComponent = new JButton("Save Airspaces");
            ((AbstractButton)jComponent).setActionCommand(Airspaces.ACTION_COMMAND_SAVE_AIRSPACES);
            ((AbstractButton)jComponent).addActionListener(this.controller);
            jPanel3.add(jComponent);
            this.controller.saveButton = (JButton)jComponent;
            jComponent = new JButton("Read Airspaces");
            ((AbstractButton)jComponent).setActionCommand(Airspaces.ACTION_COMMAND_READ_AIRSPACES);
            ((AbstractButton)jComponent).addActionListener(this.controller);
            jPanel3.add(jComponent);
            this.controller.readButton = (JButton)jComponent;
            jPanel2.add((Component)jPanel3, "North");
            jComponent = new JPanel(new BorderLayout(0, 5));
            JLabel jLabel = new JLabel("Vertical Exaggeration");
            jComponent.add((Component)jLabel, "North");
            int n = 1;
            int n2 = 8;
            int n3 = (int)this.getWwd().getSceneController().getVerticalExaggeration();
            n3 = n3 < n ? n : (n3 > n2 ? n2 : n3);
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setMajorTickSpacing(1);
            jSlider.setPaintTicks(true);
            jSlider.setSnapToTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(1, new JLabel("1x"));
            hashtable.put(2, new JLabel("2x"));
            hashtable.put(4, new JLabel("4x"));
            hashtable.put(8, new JLabel("8x"));
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = ((JSlider)changeEvent.getSource()).getValue();
                    ActionEvent actionEvent = new ActionEvent(d, 0, Airspaces.ACTION_COMMAND_VERTICAL_EXAGGERATION);
                    AppFrame.this.controller.actionPerformed(actionEvent);
                }
            });
            jComponent.add((Component)jSlider, "South");
            jPanel2.add((Component)jComponent, "South");
            jPanel.add((Component)jPanel2, "South");
            this.layerPanel = new LayerPanel(this.getWwd(), null);
            jPanel.add((Component)this.layerPanel, "Center");
            this.getContentPane().add((Component)jPanel, "West");
        }
    }
}

