/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingExceptionListener;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.examples.ClickAndGoSelectListener;
import gov.nasa.worldwind.examples.LayerPanel;
import gov.nasa.worldwind.examples.StatisticsPanel;
import gov.nasa.worldwind.exception.WWAbsentRequirementException;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.util.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ApplicationTemplate {
    public static void insertBeforeCompass(WorldWindow worldWindow, Layer layer) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (!(layer2 instanceof CompassLayer)) continue;
            n = layerList.indexOf(layer2);
        }
        layerList.add(n, layer);
    }

    public static void insertBeforePlacenames(WorldWindow worldWindow, Layer layer) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (!(layer2 instanceof PlaceNameLayer)) continue;
            n = layerList.indexOf(layer2);
        }
        layerList.add(n, layer);
    }

    public static void insertAfterPlacenames(WorldWindow worldWindow, Layer layer) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (!(layer2 instanceof PlaceNameLayer)) continue;
            n = layerList.indexOf(layer2);
        }
        layerList.add(n + 1, layer);
    }

    public static void insertBeforeLayerName(WorldWindow worldWindow, Layer layer, String string) {
        int n = 0;
        LayerList layerList = worldWindow.getModel().getLayers();
        for (Layer layer2 : layerList) {
            if (layer2.getName().indexOf(string) == -1) continue;
            n = layerList.indexOf(layer2);
            break;
        }
        layerList.add(n, layer);
    }

    public static AppFrame start(String string, Class clazz) {
        if (Configuration.isMacOS() && string != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        try {
            final AppFrame appFrame = (AppFrame)clazz.newInstance();
            appFrame.setTitle(string);
            appFrame.setDefaultCloseOperation(3);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    appFrame.setVisible(true);
                }
            });
            return appFrame;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Application", AppFrame.class);
    }

    static {
        if (Configuration.isMacOS()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "World Wind Application");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("apple.awt.brushMetalLook", "true");
        }
    }

    protected static class AppFrame
    extends JFrame {
        private Dimension canvasSize = new Dimension(800, 600);
        protected AppPanel wwjPanel;
        protected LayerPanel layerPanel;
        protected StatisticsPanel statsPanel;

        public AppFrame() {
            this.initialize(true, true, false);
        }

        public AppFrame(boolean bl, boolean bl2, boolean bl3) {
            this.initialize(bl, bl2, bl3);
        }

        protected void initialize(boolean bl, boolean bl2, boolean bl3) {
            this.wwjPanel = this.createAppPanel(this.canvasSize, bl);
            this.wwjPanel.setPreferredSize(this.canvasSize);
            this.getContentPane().add((Component)this.wwjPanel, "Center");
            if (bl2) {
                this.layerPanel = new LayerPanel(this.wwjPanel.getWwd(), null);
                this.getContentPane().add((Component)this.layerPanel, "West");
            }
            if (bl3) {
                this.statsPanel = new StatisticsPanel(this.wwjPanel.getWwd(), new Dimension(250, this.canvasSize.height));
                this.getContentPane().add((Component)this.statsPanel, "East");
                this.wwjPanel.getWwd().addRenderingListener(new RenderingListener(){

                    public void stageChanged(RenderingEvent renderingEvent) {
                        if (renderingEvent.getSource() instanceof WorldWindow) {
                            EventQueue.invokeLater(new Runnable(){

                                public void run() {
                                    AppFrame.this.statsPanel.update(AppFrame.this.wwjPanel.getWwd());
                                }
                            });
                        }
                    }
                });
            }
            this.wwjPanel.getWwd().addRenderingExceptionListener(new RenderingExceptionListener(){

                public void exceptionThrown(Throwable throwable) {
                    if (throwable instanceof WWAbsentRequirementException) {
                        String string = "Computer does not meet minimum graphics requirements.\n";
                        string = string + "Please install up-to-date graphics driver and try again.\n";
                        string = string + "Reason: " + throwable.getMessage() + "\n";
                        string = string + "This program will end when you press OK.";
                        JOptionPane.showMessageDialog(AppFrame.this, string, "Unable to Start Program", 0);
                        System.exit(-1);
                    }
                }
            });
            this.pack();
            Dimension dimension = this.getPreferredSize();
            Point point = new Point(0, 0);
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = point.x + (dimension2.width - dimension.width) / 2;
            int n2 = point.y + (dimension2.height - dimension.height) / 2;
            this.setLocation(n, n2);
            this.setResizable(true);
        }

        protected AppPanel createAppPanel(Dimension dimension, boolean bl) {
            return new AppPanel(dimension, bl);
        }

        public Dimension getCanvasSize() {
            return this.canvasSize;
        }

        public AppPanel getWwjPanel() {
            return this.wwjPanel;
        }

        public WorldWindowGLCanvas getWwd() {
            return this.wwjPanel.getWwd();
        }

        public StatusBar getStatusBar() {
            return this.wwjPanel.getStatusBar();
        }

        public LayerPanel getLayerPanel() {
            return this.layerPanel;
        }

        public StatisticsPanel getStatsPanel() {
            return this.statsPanel;
        }
    }

    public static class AppPanel
    extends JPanel {
        protected WorldWindowGLCanvas wwd = this.createWorldWindow();
        protected StatusBar statusBar;

        public AppPanel(Dimension dimension, boolean bl) {
            super(new BorderLayout());
            this.wwd.setPreferredSize(dimension);
            Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.wwd.addSelectListener(new ClickAndGoSelectListener(this.getWwd(), WorldMapLayer.class));
            this.add((Component)this.wwd, "Center");
            if (bl) {
                this.statusBar = new StatusBar();
                this.add((Component)this.statusBar, "Last");
                this.statusBar.setEventSource(this.wwd);
            }
        }

        protected WorldWindowGLCanvas createWorldWindow() {
            return new WorldWindowGLCanvas();
        }

        public WorldWindowGLCanvas getWwd() {
            return this.wwd;
        }

        public StatusBar getStatusBar() {
            return this.statusBar;
        }
    }
}

