/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.ContourLine;
import gov.nasa.worldwind.render.ContourLinePolygon;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContourLines
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Contour Lines Visualization", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private JSlider elevationSlider;
        private JLabel elevationLabel;
        private ContourLine contourLine;
        private Sector sector;

        public AppFrame() {
            super(true, true, false);
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setName("Contour Lines");
            renderableLayer.setPickEnabled(false);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), renderableLayer);
            this.contourLine = new ContourLine();
            renderableLayer.addRenderable(this.contourLine);
            ArrayList<LatLon> arrayList = new ArrayList<LatLon>();
            arrayList.add(LatLon.fromDegrees(44.16, 6.82));
            arrayList.add(LatLon.fromDegrees(44.16, 7.09));
            arrayList.add(LatLon.fromDegrees(44.3, 6.95));
            arrayList.add(LatLon.fromDegrees(44.16, 6.82));
            this.sector = Sector.boundingSector(arrayList);
            for (int i = 0; i <= 3000; i += 100) {
                ContourLinePolygon contourLinePolygon = new ContourLinePolygon((double)i, arrayList);
                contourLinePolygon.setColor(new Color(0.2f, 0.2f, 0.8f));
                renderableLayer.addRenderable(contourLinePolygon);
                if (i % 1000 == 0) {
                    contourLinePolygon.setLineWidth(2.0);
                    contourLinePolygon.setColor(new Color(0.0f, 0.1f, 0.6f));
                }
                if (i % 500 != 0) continue;
                contourLinePolygon.setLineWidth(2.0);
            }
            this.getLayerPanel().update(this.getWwd());
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Contour Lines")));
            JPanel jPanel2 = new JPanel(new GridLayout(2, 1, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.elevationLabel = new JLabel("Elevation:");
            jPanel2.add(this.elevationLabel);
            this.elevationSlider = new JSlider(0, 500, 0);
            this.elevationSlider.setMajorTickSpacing(100);
            this.elevationSlider.setMinorTickSpacing(50);
            this.elevationSlider.setPaintTicks(true);
            this.elevationSlider.setPaintLabels(true);
            this.elevationSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = AppFrame.this.elevationSlider.getValue() * 10;
                    AppFrame.this.contourLine.setElevation(d);
                    AppFrame.this.elevationLabel.setText("Elevation: (" + d + "m)");
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel2.add(this.elevationSlider);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel3.add(new JLabel("Adjust line elevation with slider"));
            JPanel jPanel4 = new JPanel(new GridLayout(2, 1, 0, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            JButton jButton = new JButton("Zoom on local set");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Position position = new Position(AppFrame.this.sector.getCentroid(), 0.0);
                    OrbitView orbitView = (OrbitView)AppFrame.this.getWwd().getView();
                    Globe globe = AppFrame.this.getWwd().getModel().getGlobe();
                    orbitView.applyStateIterator(FlyToOrbitViewStateIterator.createPanToIterator(orbitView, globe, position, Angle.ZERO, Angle.ZERO, 30000.0));
                }
            });
            jPanel4.add(jButton);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            return jPanel;
        }
    }
}

