/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.data.BasicDataSource;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.data.DataStoreProducer;
import gov.nasa.worldwind.data.TiledElevationProducer;
import gov.nasa.worldwind.data.TiledImageProducer;
import gov.nasa.worldwind.data.WWDotNetLayerSetInstaller;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.InstalledDataPanel;
import gov.nasa.worldwind.examples.LayerPanel;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.terrain.BasicElevationModel;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import gov.nasa.worldwind.view.FlyToOrbitViewStateIterator;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class InstalledData
extends ApplicationTemplate {
    public static final String DATA_SOURCE_DESCRIPTOR = "DataSourceDescriptor";
    public static final String ACTION_COMMAND_VERTICAL_EXAGGERATION = "ActionCommandVerticalExaggeration";

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Installed Data", AppFrame.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Uninstaller
    extends WWObjectImpl {
        private Controller controller;
        private Iterable<DataDescriptor> descriptors;

        public Uninstaller(Controller controller, Iterable<DataDescriptor> iterable) {
            this.controller = controller;
            this.descriptors = iterable;
        }

        public void uninstall() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uninstaller.this.beginUninstall();
                }
            });
            for (DataDescriptor dataDescriptor : this.descriptors) {
                this.uninstall(dataDescriptor);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Uninstaller.this.endUninstall();
                }
            });
        }

        public void uninstallInNonUIThread() {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    Uninstaller.this.uninstall();
                }
            });
            thread.start();
        }

        private void uninstall(DataDescriptor dataDescriptor) {
            File file = dataDescriptor.getFileStoreLocation();
            String string = dataDescriptor.getFileStorePath();
            File file2 = new File(file, string);
            try {
                WWIO.deleteDirectory(file2);
            }
            catch (IOException iOException) {
                String string2 = "Controller.ExceptionWhileUninstalling";
                Logging.logger().log(Level.SEVERE, string2, iOException);
                JOptionPane.showMessageDialog(this.controller.getAppFrame(), "Error during uninstallation", "Error", 0);
            }
        }

        private void beginUninstall() {
            this.controller.getAppFrame().getInstalledDataPanel().getInstallButton().setEnabled(false);
            this.controller.getAppFrame().getInstalledDataPanel().getUninstallButton().setEnabled(false);
            this.controller.getAppFrame().setCursor(Cursor.getPredefinedCursor(3));
        }

        private void endUninstall() {
            this.controller.getAppFrame().getInstalledDataPanel().getInstallButton().setEnabled(true);
            this.controller.getAppFrame().getInstalledDataPanel().getUninstallButton().setEnabled(true);
            this.controller.getAppFrame().setCursor(Cursor.getDefaultCursor());
            this.controller.getAppFrame().getController().refreshInstalled();
        }
    }

    public static class Installer
    extends WWObjectImpl {
        private Controller controller;
        private ProgressMonitor installProgressMonitor;
        private DataStoreProducer producer;
        private AVList parameters;
        private DataSource[] dataSources;
        private String installLocation;

        public Installer(Controller controller, DataStoreProducer dataStoreProducer, AVList aVList, DataSource[] dataSourceArray, String string) {
            this.controller = controller;
            this.producer = dataStoreProducer;
            this.parameters = aVList;
            this.dataSources = dataSourceArray;
            this.installLocation = string;
        }

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent == null) {
                return;
            }
            if ("gov.nasa.worldwind.avkey.Progress".equalsIgnoreCase(propertyChangeEvent.getPropertyName())) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Installer.this.updateInstallProgress(propertyChangeEvent.getNewValue());
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void install() throws Exception {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Installer.this.beginInstall();
                }
            });
            try {
                this.parameters.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", this.installLocation);
                this.producer.setStoreParameters(this.parameters);
                this.producer.removeAllDataSources();
                this.producer.offerAllDataSources(Arrays.asList(this.dataSources));
                this.producer.startProduction();
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Installer.this.endInstall();
                    }
                });
                throw throwable;
            }
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
        }

        public void installInNonUIThread(final Runnable runnable) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    try {
                        Installer.this.install();
                    }
                    catch (Exception exception) {
                        String string = "Controller.ExceptionWhileInstalling";
                        Logging.logger().log(Level.SEVERE, string, exception);
                        JOptionPane.showMessageDialog(Installer.this.controller.getAppFrame(), exception.getMessage(), "Error", 0);
                    }
                    if (runnable != null) {
                        SwingUtilities.invokeLater(runnable);
                    }
                }
            });
            thread.start();
        }

        private void beginInstall() {
            this.producer.addPropertyChangeListener(this);
            this.controller.getAppFrame().getInstalledDataPanel().getInstallButton().setEnabled(false);
            this.controller.getAppFrame().getInstalledDataPanel().getUninstallButton().setEnabled(false);
            this.controller.getAppFrame().setCursor(Cursor.getPredefinedCursor(3));
        }

        private void endInstall() {
            this.producer.removePropertyChangeListener(this);
            if (this.installProgressMonitor != null) {
                this.installProgressMonitor.close();
            }
            this.installProgressMonitor = null;
            this.controller.getAppFrame().getInstalledDataPanel().getInstallButton().setEnabled(true);
            this.controller.getAppFrame().getInstalledDataPanel().getUninstallButton().setEnabled(true);
            this.controller.getAppFrame().setCursor(Cursor.getDefaultCursor());
            this.controller.getAppFrame().getController().refreshInstalled();
        }

        private void updateInstallProgress(Object object) {
            if (this.installProgressMonitor == null) {
                String string = "Installing...";
                this.installProgressMonitor = new ProgressMonitor(this.controller.getAppFrame(), string, null, 0, 100);
                this.installProgressMonitor.setMillisToDecideToPopup(100);
                this.installProgressMonitor.setMillisToPopup(0);
            }
            if (object != null && object instanceof Number) {
                double d = ((Number)object).doubleValue();
                if (d < 1.0) {
                    int n = (int)(100.0 * d);
                    String string = String.format("%s %02d%%", this.parameters.getStringValue("gov.nasa.worldwind.avkey.DatasetNameKey"), n);
                    this.installProgressMonitor.setNote(string);
                    this.installProgressMonitor.setProgress(n);
                } else {
                    this.installProgressMonitor.close();
                    this.installProgressMonitor = null;
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Controller
    implements ActionListener {
        private AppFrame appFrame;

        public Controller(AppFrame appFrame) {
            this.appFrame = appFrame;
        }

        public AppFrame getAppFrame() {
            return this.appFrame;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if ("InstalledDataPanel.RefreshActionCommand".equals(actionEvent.getActionCommand())) {
                this.refreshInstalled();
            } else if ("InstalledDataPanel.InstallActionCommand".equals(actionEvent.getActionCommand())) {
                this.selectAndInstall();
            } else if ("InstalledDataPanel.UninstallActionCommand".equals(actionEvent.getActionCommand())) {
                this.uninstallSelected();
            } else if (!"InstalledDataPanel.PropertiesActionCommand".equals(actionEvent.getActionCommand())) {
                if ("InstalledDataPanel.ZoomActionCommand".equals(actionEvent.getActionCommand())) {
                    this.zoomToSelected();
                } else if (InstalledData.ACTION_COMMAND_VERTICAL_EXAGGERATION.equals(actionEvent.getActionCommand())) {
                    Double d = (Double)actionEvent.getSource();
                    this.setVerticalExaggeration(d);
                }
            }
        }

        public String getInstallLocation() {
            File file = null;
            for (File file2 : WorldWind.getDataFileStore().getLocations()) {
                if (!WorldWind.getDataFileStore().isInstallLocation(file2.getPath())) continue;
                file = file2;
                break;
            }
            return file != null ? file.getPath() : null;
        }

        public void synchronizeInstalledData(Iterable<DataDescriptor> iterable) {
            LayerList layerList = this.appFrame.getWwd().getModel().getLayers();
            CompoundElevationModel compoundElevationModel = (CompoundElevationModel)this.appFrame.getWwd().getModel().getGlobe().getElevationModel();
            this.synchronizeLayers(iterable, layerList);
            this.synchronizeElevationModel(iterable, compoundElevationModel);
            this.appFrame.getLayerPanel().update(this.appFrame.getWwd());
        }

        public void refreshInstalled() {
            String string = this.getInstallLocation();
            this.appFrame.getInstalledDataPanel().update(string);
            Iterable<DataDescriptor> iterable = this.appFrame.getInstalledDataPanel().getDataDescriptors();
            if (iterable != null) {
                this.synchronizeInstalledData(iterable);
            }
        }

        public void selectAndInstall() {
            String string = this.getInstallLocation();
            if (string == null || string.length() < 1) {
                String string2 = "Controller.CannotFindInstallLocation";
                Logging.logger().severe(string2);
                JOptionPane.showMessageDialog(this.appFrame, "Cannot find install location", "Error", 0);
                return;
            }
            JFileChooser jFileChooser = this.appFrame.getInstallDataFileChooser();
            int n = jFileChooser.showOpenDialog(this.appFrame);
            if (n != 0) {
                return;
            }
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter == null || !(fileFilter instanceof DataStoreProducerFilter)) {
                String string3 = "Controller.InvalidFileFilter";
                Logging.logger().severe(string3);
                JOptionPane.showMessageDialog(this.appFrame, "Invalid file selection type", "Error", 0);
                return;
            }
            File[] fileArray = jFileChooser.getSelectedFiles();
            if (fileArray == null) {
                String string4 = "Controller.NoFileSelected";
                Logging.logger().severe(string4);
                JOptionPane.showMessageDialog(this.appFrame, "No file was selected", "Error", 0);
                return;
            }
            DataStoreProducerFilter dataStoreProducerFilter = (DataStoreProducerFilter)fileFilter;
            dataStoreProducerFilter.getParameters().clearList();
            Object object = dataStoreProducerFilter.showControls(this.appFrame, fileArray);
            if (object == null) {
                return;
            }
            DataSource[] dataSourceArray = new DataSource[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                dataSourceArray[i] = new BasicDataSource(fileArray[i]);
            }
            try {
                final DataStoreProducer dataStoreProducer = dataStoreProducerFilter.createProducer();
                AVList aVList = dataStoreProducerFilter.getParameters();
                Installer installer = new Installer(this, dataStoreProducer, aVList, dataSourceArray, string);
                installer.installInNonUIThread(new Runnable(){

                    public void run() {
                        Controller.this.zoomToProductionResults(dataStoreProducer);
                    }
                });
            }
            catch (Exception exception) {
                String string5 = "Controller.ExceptionCreatingInstaller: " + dataStoreProducerFilter.getProducerClass();
                Logging.logger().severe(string5);
                JOptionPane.showMessageDialog(this.appFrame, "Cannot create installer " + dataStoreProducerFilter.getProducerClass(), "Error", 0);
            }
        }

        public void uninstallSelected() {
            Iterable<DataDescriptor> iterable = this.appFrame.getInstalledDataPanel().getSelectedDataDescriptors();
            if (iterable == null) {
                return;
            }
            Uninstaller uninstaller = new Uninstaller(this, iterable);
            uninstaller.uninstallInNonUIThread();
        }

        public void zoomToSelected() {
            Iterable<DataDescriptor> iterable = this.appFrame.getInstalledDataPanel().getSelectedDataDescriptors();
            if (iterable == null) {
                return;
            }
            Sector sector = null;
            for (DataDescriptor dataDescriptor : iterable) {
                Object object = dataDescriptor.getValue("gov.nasa.worldwind.avKey.Sector");
                if (object == null || !(object instanceof Sector)) continue;
                sector = sector == null ? (Sector)object : sector.union((Sector)object);
            }
            if (sector == null) {
                JOptionPane.showMessageDialog(this.appFrame, "Select installed data to zoom to", null, 1);
                return;
            }
            try {
                this.zoomTo(sector);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.appFrame, "Cannot zoom to selected data", "Error", 0);
            }
        }

        public void zoomToProductionResults(DataStoreProducer dataStoreProducer) {
            Iterable<?> iterable = dataStoreProducer.getProductionResults();
            if (iterable == null) {
                return;
            }
            Sector sector = null;
            for (Object obj : iterable) {
                Object object;
                if (!(obj instanceof AVList) || (object = ((AVList)obj).getValue("gov.nasa.worldwind.avKey.Sector")) == null || !(object instanceof Sector)) continue;
                sector = sector == null ? (Sector)object : sector.union((Sector)object);
            }
            if (sector == null) {
                return;
            }
            try {
                this.zoomTo(sector);
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this.appFrame, "Cannot zoom to selected data", "Error", 0);
            }
        }

        public void setVerticalExaggeration(double d) {
            this.getAppFrame().getWwd().getSceneController().setVerticalExaggeration(d);
        }

        private void zoomTo(Sector sector) {
            if (sector == null) {
                String string = Logging.getMessage("nullValue.SectorIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            View view = this.appFrame.getWwd().getView();
            if (view == null) {
                String string = Logging.getMessage("nullValue.ViewIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            Globe globe = this.appFrame.getWwd().getModel().getGlobe();
            if (globe == null) {
                String string = Logging.getMessage("nullValue.GlobeIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            double d = this.appFrame.getWwd().getSceneController().getVerticalExaggeration();
            Cylinder cylinder = globe.computeBoundingCylinder(d, sector);
            Position position = globe.computePositionFromPoint(cylinder.getCenter());
            double d2 = 1.5 * cylinder.getRadius() / view.getFieldOfView().tanHalfAngle();
            FlyToOrbitViewStateIterator flyToOrbitViewStateIterator = FlyToOrbitViewStateIterator.createPanToIterator((OrbitView)view, globe, position, Angle.ZERO, Angle.ZERO, d2, true);
            view.applyStateIterator(flyToOrbitViewStateIterator);
        }

        private void synchronizeLayers(Iterable<DataDescriptor> iterable, LayerList layerList) {
            ArrayList<DataDescriptor> arrayList = new ArrayList<DataDescriptor>();
            for (DataDescriptor iterator2 : iterable) {
                arrayList.add(iterator2);
            }
            ArrayList arrayList2 = new ArrayList();
            for (Layer layer : layerList) {
                Object object = layer.getValue(InstalledData.DATA_SOURCE_DESCRIPTOR);
                if (object == null || !(object instanceof DataDescriptor)) continue;
                DataDescriptor dataDescriptor = (DataDescriptor)object;
                if (arrayList.contains(dataDescriptor)) {
                    arrayList.remove(dataDescriptor);
                    continue;
                }
                arrayList2.add(layer);
            }
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                Layer layer = (Layer)iterator.next();
                layerList.remove(layer);
            }
            for (DataDescriptor dataDescriptor : arrayList) {
                this.createLayerForDescriptor(dataDescriptor);
            }
        }

        private void synchronizeElevationModel(Iterable<DataDescriptor> iterable, CompoundElevationModel compoundElevationModel) {
            ArrayList<DataDescriptor> arrayList = new ArrayList<DataDescriptor>();
            for (DataDescriptor iterator2 : iterable) {
                arrayList.add(iterator2);
            }
            List<ElevationModel> list = compoundElevationModel.getElevationModels();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                DataDescriptor dataDescriptor;
                ElevationModel elevationModel = (ElevationModel)iterator.next();
                Object object = elevationModel.getValue(InstalledData.DATA_SOURCE_DESCRIPTOR);
                if (object == null || !(object instanceof DataDescriptor) || !arrayList.contains(dataDescriptor = (DataDescriptor)object)) continue;
                arrayList.remove(dataDescriptor);
            }
            for (DataDescriptor dataDescriptor : arrayList) {
                this.createElevationModelForDescriptor(dataDescriptor, compoundElevationModel);
            }
        }

        private void createLayerForDescriptor(DataDescriptor dataDescriptor) {
            if ("gov.nasa.worldwind.avkey.TiledImagery".equals(dataDescriptor.getType())) {
                BasicTiledImageLayer basicTiledImageLayer = new BasicTiledImageLayer(dataDescriptor);
                basicTiledImageLayer.setNetworkRetrievalEnabled(false);
                basicTiledImageLayer.setValue(InstalledData.DATA_SOURCE_DESCRIPTOR, dataDescriptor);
                if (dataDescriptor.getName() != null) {
                    basicTiledImageLayer.setName(dataDescriptor.getName());
                }
                ApplicationTemplate.insertBeforePlacenames(this.appFrame.getWwd(), basicTiledImageLayer);
            }
        }

        private void createElevationModelForDescriptor(DataDescriptor dataDescriptor, CompoundElevationModel compoundElevationModel) {
            if ("gov.nasa.worldwind.avkey.TiledElevations".equals(dataDescriptor.getType())) {
                double d = 8850.0;
                double d2 = -11000.0;
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.ElevationMaxKey", d);
                dataDescriptor.setValue("gov.nasa.worldwind.avkey.ElevationMinKey", d2);
                BasicElevationModel basicElevationModel = new BasicElevationModel(dataDescriptor);
                basicElevationModel.setNetworkRetrievalEnabled(false);
                basicElevationModel.setValue(InstalledData.DATA_SOURCE_DESCRIPTOR, dataDescriptor);
                compoundElevationModel.addElevationModel(basicElevationModel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TiledRasterProducerFilter
    extends DataStoreProducerFilter {
        public TiledRasterProducerFilter(Class<? extends DataStoreProducer> clazz, AVList aVList) {
            super(clazz, aVList);
        }

        public TiledRasterProducerFilter(Class<? extends DataStoreProducer> clazz) {
            super(clazz);
        }

        @Override
        public Object showControls(Component component, File[] fileArray) {
            Object object = JOptionPane.showInputDialog(component, "Name:", null, 3, null, null, "New Data Set");
            if (object == null) {
                return null;
            }
            this.getParameters().setValue("gov.nasa.worldwind.avkey.DatasetNameKey", object.toString());
            this.getParameters().setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", object.toString());
            return object;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DataStoreProducerFilter
    extends FileFilter {
        private Class<? extends DataStoreProducer> producerClass;
        private AVList parameters;

        public DataStoreProducerFilter(Class<? extends DataStoreProducer> clazz, AVList aVList) {
            this.producerClass = clazz;
            this.parameters = aVList;
        }

        public DataStoreProducerFilter(Class<? extends DataStoreProducer> clazz) {
            this.producerClass = clazz;
            this.parameters = new AVListImpl();
        }

        public DataStoreProducer createProducer() throws Exception {
            return this.producerClass.newInstance();
        }

        public Class<? extends DataStoreProducer> getProducerClass() {
            return this.producerClass;
        }

        public AVList getParameters() {
            return this.parameters;
        }

        @Override
        public boolean accept(File file) {
            DataStoreProducer dataStoreProducer;
            if (file.isDirectory()) {
                return true;
            }
            try {
                dataStoreProducer = this.createProducer();
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "ExceptionCreatingProducer", exception);
                return false;
            }
            BasicDataSource basicDataSource = new BasicDataSource(file);
            return dataStoreProducer.acceptsDataSource(basicDataSource);
        }

        @Override
        public String getDescription() {
            DataStoreProducer dataStoreProducer;
            try {
                dataStoreProducer = this.createProducer();
            }
            catch (Exception exception) {
                Logging.logger().log(Level.SEVERE, "ExceptionCreatingProducer", exception);
                return null;
            }
            return dataStoreProducer.getDataSourceDescription();
        }

        public Object showControls(Component component, File[] fileArray) {
            return this;
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private Controller controller = new Controller(this);
        private LayerPanel layerPanel;
        private InstalledDataPanel installedDataPanel;
        private JFileChooser installDataFileChooser;

        public AppFrame() {
            super(true, false, false);
            this.makeComponents();
            this.makeDataFileChoosers();
            this.layoutComponents();
            this.controller.refreshInstalled();
        }

        public Controller getController() {
            return this.controller;
        }

        public LayerPanel getLayerPanel() {
            return this.layerPanel;
        }

        public InstalledDataPanel getInstalledDataPanel() {
            return this.installedDataPanel;
        }

        public JFileChooser getInstallDataFileChooser() {
            return this.installDataFileChooser;
        }

        private void makeDataFileChoosers() {
            DataStoreProducerFilter dataStoreProducerFilter = new TiledRasterProducerFilter(TiledImageProducer.class);
            this.installDataFileChooser.addChoosableFileFilter(dataStoreProducerFilter);
            dataStoreProducerFilter = new TiledRasterProducerFilter(TiledElevationProducer.class);
            this.installDataFileChooser.addChoosableFileFilter(dataStoreProducerFilter);
            dataStoreProducerFilter = new DataStoreProducerFilter(WWDotNetLayerSetInstaller.class);
            this.installDataFileChooser.addChoosableFileFilter(dataStoreProducerFilter);
        }

        private void makeComponents() {
            WorldWindowGLCanvas worldWindowGLCanvas = this.getWwd();
            ElevationModel elevationModel = worldWindowGLCanvas.getModel().getGlobe().getElevationModel();
            CompoundElevationModel compoundElevationModel = new CompoundElevationModel();
            compoundElevationModel.addElevationModel(elevationModel);
            worldWindowGLCanvas.getModel().getGlobe().setElevationModel(compoundElevationModel);
            this.layerPanel = new LayerPanel(worldWindowGLCanvas);
            this.installedDataPanel = new InstalledDataPanel();
            this.installedDataPanel.addActionListener(this.controller);
            this.installedDataPanel.getPropertiesButton().setEnabled(false);
            this.installDataFileChooser = new JFileChooser();
            this.installDataFileChooser.setMultiSelectionEnabled(true);
            this.installDataFileChooser.setAcceptAllFileFilterUsed(false);
        }

        private void layoutComponents() {
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.setBorder(new EmptyBorder(10, 0, 10, 0));
            JPanel jPanel2 = new JPanel(new BorderLayout(0, 10));
            jPanel2.setBorder(new EmptyBorder(20, 10, 20, 10));
            JPanel jPanel3 = new JPanel(new BorderLayout(0, 5));
            JLabel jLabel = new JLabel("Vertical Exaggeration");
            jPanel3.add((Component)jLabel, "North");
            int n = 1;
            int n2 = 8;
            int n3 = (int)this.getWwd().getSceneController().getVerticalExaggeration();
            n3 = n3 < n ? n : (n3 > n2 ? n2 : n3);
            JSlider jSlider = new JSlider(n, n2, n3);
            jSlider.setMajorTickSpacing(1);
            jSlider.setPaintTicks(true);
            jSlider.setSnapToTicks(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            hashtable.put(1, new JLabel("1x"));
            hashtable.put(2, new JLabel("2x"));
            hashtable.put(4, new JLabel("4x"));
            hashtable.put(8, new JLabel("8x"));
            jSlider.setLabelTable(hashtable);
            jSlider.setPaintLabels(true);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    double d = ((JSlider)changeEvent.getSource()).getValue();
                    ActionEvent actionEvent = new ActionEvent(d, 0, InstalledData.ACTION_COMMAND_VERTICAL_EXAGGERATION);
                    AppFrame.this.controller.actionPerformed(actionEvent);
                }
            });
            jPanel3.add((Component)jSlider, "South");
            jPanel2.add((Component)jPanel3, "South");
            jPanel2.add((Component)jPanel3, "South");
            jPanel.add((Component)jPanel2, "South");
            this.layerPanel = new LayerPanel(this.getWwd(), null);
            jPanel.add((Component)this.layerPanel, "Center");
            this.getContentPane().add((Component)jPanel, "West");
            this.getContentPane().add((Component)this.installedDataPanel, "South");
        }
    }
}

