/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.util.RayCastingSupport;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.CrosshairLayer;
import gov.nasa.worldwind.layers.Earth.USGSTopographicMaps;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class LineOfSight
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Line Of Sight Calculation", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private double samplingLength = 30.0;
        private int centerOffset = 100;
        private int pointOffset = 10;
        private Vec4 light = new Vec4(1.0, 1.0, -1.0).normalize3();
        private double ambiant = 0.4;
        private RenderableLayer renderableLayer;
        private SurfaceImage surfaceImage;
        private ScreenAnnotation screenAnnotation;
        private JComboBox radiusCombo;
        private JComboBox samplesCombo;
        private JCheckBox shadingCheck;
        private JButton computeButton;

        public AppFrame() {
            super(true, true, false);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), new USGSTopographicMaps());
            this.renderableLayer = new RenderableLayer();
            this.renderableLayer.setName("Line of sight");
            this.renderableLayer.setPickEnabled(false);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), this.renderableLayer);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), new CrosshairLayer());
            this.getLayerPanel().update(this.getWwd());
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Line Of Sight")));
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel2.add(new JLabel("Max radius:"));
            this.radiusCombo = new JComboBox<String>(new String[]{"5km", "10km", "20km", "30km", "50km", "100km", "200km"});
            this.radiusCombo.setSelectedItem("10km");
            jPanel2.add(this.radiusCombo);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel3.add(new JLabel("Samples:"));
            this.samplesCombo = new JComboBox<String>(new String[]{"128", "256", "512"});
            this.samplesCombo.setSelectedItem("128");
            jPanel3.add(this.samplesCombo);
            JPanel jPanel4 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel4.add(new JLabel("Light:"));
            this.shadingCheck = new JCheckBox("Add shading");
            this.shadingCheck.setSelected(false);
            jPanel4.add(this.shadingCheck);
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.computeButton = new JButton("Compute");
            this.computeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.update();
                }
            });
            jPanel5.add(this.computeButton);
            JPanel jPanel6 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel6.add(new JLabel("Place view center on an elevated"));
            jPanel6.add(new JLabel("location and click \"Compute\""));
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            jPanel.add(jPanel5);
            jPanel.add(jPanel6);
            return jPanel;
        }

        private void update() {
            new Thread(new Runnable(){

                public void run() {
                    AppFrame.this.computeLineOfSight();
                }
            }, "LOS thread").start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void computeLineOfSight() {
            this.computeButton.setEnabled(false);
            this.computeButton.setText("Computing...");
            try {
                int n;
                Object object;
                Globe globe = this.getWwd().getModel().getGlobe();
                OrbitView orbitView = (OrbitView)this.getWwd().getView();
                Position position = orbitView.getCenterPosition();
                String string = (String)this.radiusCombo.getSelectedItem();
                double d = 1000.0 * Double.parseDouble(string.substring(0, string.length() - 2));
                double d2 = d / globe.getEquatorialRadius();
                double d3 = d2 / Math.cos(position.getLatitude().radians);
                Sector sector = new Sector(position.getLatitude().subtractRadians(d2), position.getLatitude().addRadians(d2), position.getLongitude().subtractRadians(d3), position.getLongitude().addRadians(d3));
                double d4 = globe.getElevation(position.getLatitude(), position.getLongitude());
                Vec4 vec4 = globe.computePointFromPosition(new Position(position, d4 + (double)this.centerOffset));
                float f = 0.7f;
                int n2 = Integer.parseInt((String)this.samplesCombo.getSelectedItem());
                BufferedImage bufferedImage = new BufferedImage(n2, n2, 6);
                double d5 = sector.getDeltaLatRadians() / (double)bufferedImage.getHeight();
                double d6 = sector.getDeltaLonRadians() / (double)bufferedImage.getWidth();
                for (int i = 0; i < bufferedImage.getWidth(); ++i) {
                    object = sector.getMinLongitude().addRadians(d6 * (double)i + d6 / 2.0);
                    for (n = 0; n < bufferedImage.getHeight(); ++n) {
                        float f2;
                        double d7;
                        Angle angle = sector.getMaxLatitude().subtractRadians(d5 * (double)n + d5 / 2.0);
                        Vec4 vec42 = globe.computePointFromPosition(angle, (Angle)object, (d7 = globe.getElevation(angle, (Angle)object)) + (double)this.pointOffset);
                        if (RayCastingSupport.intersectSegmentWithTerrain(globe, vec42, vec4, this.samplingLength, this.samplingLength) == null) {
                            f2 = (float)Math.min(vec42.distanceTo3(vec4) / d, 1.0) * f;
                            float f3 = this.shadingCheck.isSelected() ? (float)AppFrame.computeShading(globe, angle, (Angle)object, this.light, this.ambiant) : 0.0f;
                            bufferedImage.setRGB(i, n, Color.HSBtoRGB(f2, 1.0f, 1.0f - f3));
                            continue;
                        }
                        if (!this.shadingCheck.isSelected()) continue;
                        f2 = (float)AppFrame.computeShading(globe, angle, (Angle)object, this.light, this.ambiant);
                        bufferedImage.setRGB(i, n, new Color(0.0f, 0.0f, 0.0f, f2).getRGB());
                    }
                }
                PatternFactory.blur(PatternFactory.blur(PatternFactory.blur(PatternFactory.blur(bufferedImage))));
                if (this.surfaceImage != null) {
                    this.renderableLayer.removeRenderable(this.surfaceImage);
                }
                this.surfaceImage = new SurfaceImage((Object)bufferedImage, sector);
                this.surfaceImage.setOpacity(0.5);
                this.renderableLayer.addRenderable(this.surfaceImage);
                BufferedImage bufferedImage2 = new BufferedImage(64, 256, 6);
                object = bufferedImage2.getGraphics();
                n = 10;
                int n3 = bufferedImage2.getHeight() / n;
                for (int i = 0; i < bufferedImage2.getHeight(); ++i) {
                    int n4 = bufferedImage2.getWidth() / 5;
                    if (i % n3 == 0 && i != 0) {
                        double d8 = d / (double)n * (double)i / (double)n3 / 1000.0;
                        String string2 = Double.toString(d8) + "km";
                        ((Graphics)object).setColor(Color.BLACK);
                        ((Graphics)object).drawString(string2, n4 + 6, i + 6);
                        ((Graphics)object).setColor(Color.WHITE);
                        ((Graphics)object).drawLine(n4, i, n4 + 4, i);
                        ((Graphics)object).drawString(string2, n4 + 5, i + 5);
                    }
                    float f4 = (float)i / (float)(bufferedImage2.getHeight() - 1) * f;
                    ((Graphics)object).setColor(Color.getHSBColor(f4, 1.0f, 1.0f));
                    ((Graphics)object).drawLine(0, i, n4, i);
                }
                if (this.screenAnnotation != null) {
                    this.renderableLayer.removeRenderable(this.screenAnnotation);
                }
                this.screenAnnotation = new ScreenAnnotation("", new Point(20, 20));
                this.screenAnnotation.getAttributes().setImageSource(bufferedImage2);
                this.screenAnnotation.getAttributes().setSize(new Dimension(bufferedImage2.getWidth(), bufferedImage2.getHeight()));
                this.screenAnnotation.getAttributes().setAdjustWidthToText("render.Annotation.SizeFixed");
                this.screenAnnotation.getAttributes().setDrawOffset(new Point(bufferedImage2.getWidth() / 2, 0));
                this.screenAnnotation.getAttributes().setBorderWidth(0.0);
                this.screenAnnotation.getAttributes().setCornerRadius(0);
                this.screenAnnotation.getAttributes().setBackgroundColor(new Color(0.0f, 0.0f, 0.0f, 0.0f));
                this.renderableLayer.addRenderable(this.screenAnnotation);
                this.getWwd().redraw();
            }
            finally {
                this.computeButton.setEnabled(true);
                this.computeButton.setText("Compute");
            }
        }

        private static double computeShading(Globe globe, Angle angle, Angle angle2, Vec4 vec4, double d) {
            double d2 = 30.0 / globe.getEquatorialRadius();
            Vec4 vec42 = globe.computePointFromPosition(angle, angle2, 0.0);
            Vec4 vec43 = globe.computePointFromPosition(angle, Angle.fromRadians(angle2.radians - d2), 0.0);
            Vec4 vec44 = globe.computePointFromPosition(Angle.fromRadians(angle.radians + d2), angle2, 0.0);
            double d3 = globe.getElevation(angle, angle2);
            double d4 = globe.getElevation(angle, Angle.fromRadians(angle2.radians - d2));
            double d5 = globe.getElevation(Angle.fromRadians(angle.radians + d2), angle2);
            Vec4 vec45 = new Vec4(vec42.distanceTo3(vec43), 0.0, d4 - d3).normalize3();
            Vec4 vec46 = new Vec4(0.0, vec42.distanceTo3(vec44), d5 - d3).normalize3();
            Vec4 vec47 = vec45.cross3(vec46).normalize3();
            return 1.0 - Math.max(-vec4.dot3(vec47), d);
        }
    }
}

