/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.examples.util.AudioPlayer;
import gov.nasa.worldwind.examples.util.AudioPlayerDialog;
import gov.nasa.worldwind.examples.util.ImageViewerDialog;
import gov.nasa.worldwind.examples.util.SlideShowPlayer;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.AnnotationLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.Annotation;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.io.File;
import java.net.URL;

public class MultimediaAnnotations
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Multimedia Annotations", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private static final String HELLO_AUDIO_FILE_PATH = "http://simplythebest.net/sounds/WAV/events_WAV/event_WAV_files/welcome.wav";
        private static final String MSH_IMAGE_FILE_PATH = "http://worldwind.arc.nasa.gov/java/demos/images/MountStHelens_01_800.jpg";
        private static final String MSH_IMAGE_FILE_PATH1 = "http://upload.wikimedia.org/wikipedia/commons/thumb/8/8c/Sthelens1.jpg/800px-Sthelens1.jpg";
        private static final String FILE_ATTACHMENT = "FileAttachment";
        private static final String PLAY_AUDIO_CMD = "play:audio";
        private static final String PLAY_IMAGE_CMD = "play:image";
        private static final String PLAY_SLIDES_CMD = "play:slides";
        private Annotation currentAnnotation;
        private Annotation lastPickedObject;
        private Color savedBorderColor;
        private AudioPlayerDialog playerDialog;
        private ImageViewerDialog viewerDialog;
        private SlideShowPlayer slideShowPlayer;

        public AppFrame() {
            super(true, true, false);
            AnnotationLayer annotationLayer = new AnnotationLayer();
            annotationLayer.setName("Annotations");
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), annotationLayer);
            this.getLayerPanel().update(this.getWwd());
            AnnotationAttributes annotationAttributes = new AnnotationAttributes();
            annotationAttributes.setBackgroundColor(Color.WHITE);
            annotationAttributes.setBorderColor(Color.BLACK);
            annotationAttributes.setSize(new Dimension(240, 0));
            annotationAttributes.setHighlightScale(1.0);
            annotationAttributes.setInsets(new Insets(12, 12, 12, 20));
            annotationAttributes.setFont(Font.decode("SansSerif-PLAIN-14"));
            annotationAttributes.setTextColor(Color.BLACK);
            annotationAttributes.setAntiAliasHint(4354);
            GlobeAnnotation globeAnnotation = new GlobeAnnotation("<p>\n<b><font color=\"#664400\">MOUNT SAINT HELENS</font></b><br />\n<i>Alt: 1404m</i></p><p>Mount St. Helens is an active stratovolcano located in Skamania County, Washington.</p>", Position.fromDegrees(46.2, -122.1882, 0.0), annotationAttributes);
            String[] stringArray = new String[]{"http://upload.wikimedia.org/wikipedia/commons/thumb/8/8c/Sthelens1.jpg/800px-Sthelens1.jpg;Mt Saint Helens before May 1980", "http://worldwind.arc.nasa.gov/java/demos/images/MountStHelens_01_800.jpg;Mt Saint Helens May 1982"};
            globeAnnotation.setValue(FILE_ATTACHMENT, stringArray);
            globeAnnotation.setText(globeAnnotation.getText() + "<br /><a href=\"" + PLAY_SLIDES_CMD + "\">View slides</a>...");
            annotationLayer.addAnnotation(globeAnnotation);
            globeAnnotation = new GlobeAnnotation("<p>Welcome...</p>", Position.fromDegrees(44.0, -100.0, 0.0), annotationAttributes);
            globeAnnotation.setValue(FILE_ATTACHMENT, HELLO_AUDIO_FILE_PATH);
            globeAnnotation.setText(globeAnnotation.getText() + "<br /><a href=\"" + PLAY_AUDIO_CMD + "\">Play audio</a>...");
            annotationLayer.addAnnotation(globeAnnotation);
            this.setupSelectListener();
        }

        private void setupSelectListener() {
            this.getWwd().addSelectListener(new SelectListener(){
                private BasicDragger dragger;
                {
                    this.dragger = new BasicDragger(AppFrame.this.getWwd());
                }

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.hasObjects() && selectEvent.getTopObject() instanceof Annotation) {
                        if (selectEvent.getTopPickedObject().getValue("gov.nasa.worldwind.avkey.URL") != null) {
                            AppFrame.this.getWwd().setCursor(Cursor.getPredefinedCursor(12));
                        } else {
                            AppFrame.this.getWwd().setCursor(Cursor.getDefaultCursor());
                        }
                    }
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                        if (selectEvent.hasObjects()) {
                            if (selectEvent.getTopObject() instanceof Annotation) {
                                PickedObject pickedObject = selectEvent.getTopPickedObject();
                                if (pickedObject.getValue("gov.nasa.worldwind.avkey.Text") != null) {
                                    String string = (String)pickedObject.getValue("gov.nasa.worldwind.avkey.URL");
                                    if (string != null && string.equals(AppFrame.PLAY_AUDIO_CMD)) {
                                        AppFrame.this.playAnnotationAudio((GlobeAnnotation)selectEvent.getTopObject(), selectEvent.getPickPoint());
                                    } else if (string != null && string.equals(AppFrame.PLAY_IMAGE_CMD)) {
                                        AppFrame.this.playAnnotationImage((GlobeAnnotation)selectEvent.getTopObject(), selectEvent.getPickPoint());
                                    } else if (string != null && string.equals(AppFrame.PLAY_SLIDES_CMD)) {
                                        AppFrame.this.playAnnotationSlides((GlobeAnnotation)selectEvent.getTopObject(), selectEvent.getPickPoint());
                                    }
                                    if (AppFrame.this.currentAnnotation == selectEvent.getTopObject()) {
                                        return;
                                    }
                                }
                                if (AppFrame.this.currentAnnotation != null) {
                                    AppFrame.this.currentAnnotation.getAttributes().setBorderColor(AppFrame.this.savedBorderColor);
                                }
                                if (AppFrame.this.currentAnnotation != selectEvent.getTopObject()) {
                                    AppFrame.this.currentAnnotation = (Annotation)selectEvent.getTopObject();
                                    AppFrame.this.savedBorderColor = AppFrame.this.currentAnnotation.getAttributes().getBorderColor();
                                    AppFrame.this.currentAnnotation.getAttributes().setBorderColor(Color.YELLOW);
                                } else {
                                    AppFrame.this.currentAnnotation = null;
                                }
                            } else {
                                System.out.println("Left click on " + selectEvent.getTopObject());
                            }
                        }
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !this.dragger.isDragging()) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                        PickedObjectList pickedObjectList;
                        if (selectEvent.hasObjects() && selectEvent.getTopObject() == AppFrame.this.currentAnnotation) {
                            this.dragger.selected(selectEvent);
                        }
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AppFrame.this.getWwd().getObjectsAtCurrentPosition()) != null) {
                            AppFrame.this.highlight(pickedObjectList.getTopObject());
                            AppFrame.this.getWwd().repaint();
                        }
                    }
                }
            });
        }

        private void highlight(Object object) {
            if (this.lastPickedObject == object) {
                return;
            }
            if (this.lastPickedObject != null) {
                this.lastPickedObject.getAttributes().setHighlighted(false);
                this.lastPickedObject = null;
            }
            if (object != null && object instanceof Annotation) {
                this.lastPickedObject = (Annotation)object;
                this.lastPickedObject.getAttributes().setHighlighted(true);
            }
        }

        private void playAnnotationAudio(GlobeAnnotation globeAnnotation, Point point) {
            String string = (String)globeAnnotation.getValue(FILE_ATTACHMENT);
            if (string == null) {
                return;
            }
            System.out.println("Play annotation audio: " + string);
            Point point2 = this.getCursorPoint(point);
            try {
                AudioPlayer audioPlayer = new AudioPlayer(this.getResourceURL(string));
                if (this.playerDialog == null) {
                    this.playerDialog = new AudioPlayerDialog();
                }
                this.playerDialog.setAudioPlayer(audioPlayer);
                this.playerDialog.setAlwaysOnTop(true);
                this.playerDialog.setLocation(point2);
                this.playerDialog.setVisible(true);
                audioPlayer.play();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private void playAnnotationImage(GlobeAnnotation globeAnnotation, Point point) {
            String string = (String)globeAnnotation.getValue(FILE_ATTACHMENT);
            if (string == null) {
                return;
            }
            System.out.println("Play annotation image: " + string);
            Point point2 = this.getCursorPoint(point);
            if (this.viewerDialog == null) {
                this.viewerDialog = new ImageViewerDialog();
            }
            this.viewerDialog.getImageViewer().setImageURL(this.getResourceURL(string));
            this.viewerDialog.getImageViewer().setScaleMode("ImageViewer.ScaleBestFit");
            this.viewerDialog.setLocation(point2);
            this.viewerDialog.setAlwaysOnTop(true);
            this.viewerDialog.setDropEnabled(true);
            this.viewerDialog.setVisible(true);
        }

        private void playAnnotationSlides(GlobeAnnotation globeAnnotation, Point point) {
            String[] stringArray = (String[])globeAnnotation.getValue(FILE_ATTACHMENT);
            if (stringArray == null) {
                return;
            }
            System.out.println("Play annotation slides: " + stringArray.length);
            Point point2 = this.getCursorPoint(point);
            if (this.slideShowPlayer == null) {
                this.slideShowPlayer = new SlideShowPlayer();
            }
            this.slideShowPlayer.clear();
            for (String string : stringArray) {
                String[] stringArray2 = string.split(";");
                URL uRL = this.getResourceURL(stringArray2[0]);
                String string2 = stringArray2.length > 1 ? stringArray2[1] : string;
                this.slideShowPlayer.addSlide(new SlideShowPlayer.Slide(uRL, string2));
            }
            this.slideShowPlayer.getImageViewer().setScaleMode("ImageViewer.ScaleBestFit");
            this.slideShowPlayer.setLocation(point2);
            this.slideShowPlayer.setAlwaysOnTop(true);
            this.slideShowPlayer.setDropEnabled(true);
            this.slideShowPlayer.setVisible(true);
        }

        private URL getResourceURL(String string) {
            try {
                File file = new File(string);
                if (file.exists()) {
                    return file.toURL();
                }
                URL uRL = this.getClass().getResource("/" + string);
                if (uRL != null) {
                    return uRL;
                }
                return new URL(string);
            }
            catch (Exception exception) {
                return null;
            }
        }

        private Point getCursorPoint(Point point) {
            Point point2 = this.getWwd().getLocationOnScreen();
            return new Point(point2.x + point.x, point2.y + point.y);
        }
    }
}

