/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.data.ImageIOReader;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.util.ImageIOFileFilter;
import gov.nasa.worldwind.examples.util.ShapeUtils;
import gov.nasa.worldwind.formats.gcps.GCPSReader;
import gov.nasa.worldwind.formats.tab.TABRasterReader;
import gov.nasa.worldwind.formats.worldfile.WorldFile;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.render.SurfaceImageEditor;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.RasterControlPointList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class RubberSheetImage
extends ApplicationTemplate {
    public static final String OPEN_IMAGE_FILE = "OpenImageFile";
    public static final String SET_IMAGE_OPACITY = "SetImageOpacity";
    public static final String TOGGLE_EDITING = "ToggleEditing";
    protected static final String ENABLE_EDITING = "Enable Editing";
    protected static final String DISABLE_EDITING = "Disable Editing";

    protected static DataDescriptor findDataDescriptor(String string) {
        for (File file : WorldWind.getDataFileStore().getLocations()) {
            if (!WorldWind.getDataFileStore().isInstallLocation(file.getPath())) continue;
            for (DataDescriptor dataDescriptor : WorldWind.getDataFileStore().findDataDescriptors(file.getPath())) {
                if (!dataDescriptor.getName().equals(string)) continue;
                return dataDescriptor;
            }
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Rubber Sheet Image", AppFrame.class);
    }

    public static class Controller
    implements ActionListener,
    SelectListener {
        private AppFrame appFrame;
        private JFileChooser openFileChooser;
        private ImageIOReader imageReader;
        private ArrayList<SurfaceImageEntry> entryList = new ArrayList();

        public Controller(AppFrame appFrame) {
            this.appFrame = appFrame;
            this.imageReader = new ImageIOReader();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string == null) {
                return;
            }
            if (string == RubberSheetImage.OPEN_IMAGE_FILE) {
                this.doOpenImageFile();
            } else if (string == RubberSheetImage.SET_IMAGE_OPACITY) {
                JSlider jSlider = (JSlider)actionEvent.getSource();
                this.doSetImageOpacity((double)jSlider.getValue() / 100.0);
            } else if (string == RubberSheetImage.TOGGLE_EDITING) {
                String string2 = this.appFrame.getToggleEditButton().getText();
                boolean bl = RubberSheetImage.DISABLE_EDITING.equals(string2);
                this.appFrame.getToggleEditButton().setText(bl ? RubberSheetImage.ENABLE_EDITING : RubberSheetImage.DISABLE_EDITING);
                this.enableEditing(!bl);
            }
        }

        public void selected(SelectEvent selectEvent) {
            SurfaceImageEntry surfaceImageEntry;
            PickedObject pickedObject = selectEvent.getTopPickedObject();
            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftPress") && pickedObject != null && !pickedObject.isTerrain() && pickedObject.getObject() instanceof SurfaceImage && (surfaceImageEntry = this.getEntryFor((SurfaceImage)pickedObject.getObject())) != null) {
                this.setSelectedEntry(surfaceImageEntry);
            }
        }

        protected void enableEditing(boolean bl) {
            for (SurfaceImageEntry surfaceImageEntry : this.entryList) {
                surfaceImageEntry.getLayer().setPickEnabled(bl);
                if (bl) continue;
                surfaceImageEntry.getEditor().setArmed(false);
            }
        }

        protected void addSurfaceImage(SurfaceImage surfaceImage, String string) {
            SurfaceImageEntry surfaceImageEntry = new SurfaceImageEntry(this.appFrame.getWwd(), surfaceImage, string);
            this.entryList.add(surfaceImageEntry);
            this.setSelectedEntry(surfaceImageEntry);
            this.appFrame.getLayerPanel().update(this.appFrame.getWwd());
        }

        protected SurfaceImageEntry getEntryFor(SurfaceImage surfaceImage) {
            for (SurfaceImageEntry surfaceImageEntry : this.entryList) {
                if (surfaceImageEntry.getSurfaceImage() != surfaceImage) continue;
                return surfaceImageEntry;
            }
            return null;
        }

        protected void setSelectedEntry(SurfaceImageEntry surfaceImageEntry) {
            for (SurfaceImageEntry surfaceImageEntry2 : this.entryList) {
                if (surfaceImageEntry2 == surfaceImageEntry || !surfaceImageEntry2.getEditor().isArmed()) continue;
                surfaceImageEntry2.getEditor().setArmed(false);
            }
            if (!surfaceImageEntry.getEditor().isArmed()) {
                surfaceImageEntry.getEditor().setArmed(true);
            }
        }

        protected void doOpenImageFile() {
            int n;
            if (this.openFileChooser == null) {
                this.openFileChooser = new JFileChooser(Configuration.getUserHomeDirectory());
                this.openFileChooser.setAcceptAllFileFilterUsed(false);
                this.openFileChooser.setFileSelectionMode(0);
                this.openFileChooser.setMultiSelectionEnabled(true);
                this.openFileChooser.addChoosableFileFilter(new ImageIOFileFilter(this.imageReader));
            }
            if ((n = this.openFileChooser.showOpenDialog(this.appFrame)) != 0) {
                return;
            }
            File[] fileArray = this.openFileChooser.getSelectedFiles();
            this.loadFiles(fileArray);
        }

        protected void doSetImageOpacity(double d) {
            for (SurfaceImageEntry surfaceImageEntry : this.entryList) {
                surfaceImageEntry.getSurfaceImage().setOpacity(d);
            }
            this.appFrame.getWwd().redraw();
        }

        protected void loadBackgroundData() {
            DataDescriptor dataDescriptor = RubberSheetImage.findDataDescriptor("Mercury_Orthophoto_2007");
            if (dataDescriptor != null) {
                BasicTiledImageLayer basicTiledImageLayer = new BasicTiledImageLayer(dataDescriptor);
                basicTiledImageLayer.setName(dataDescriptor.getName());
                basicTiledImageLayer.setUseTransparentTextures(true);
                ApplicationTemplate.insertBeforePlacenames(this.appFrame.getWwd(), basicTiledImageLayer);
                this.appFrame.getLayerPanel().update(this.appFrame.getWwd());
            }
        }

        protected void loadFiles(final File[] fileArray) {
            this.appFrame.setCursor(Cursor.getPredefinedCursor(3));
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    for (File file : fileArray) {
                        Controller.this.loadFile(file);
                    }
                    Controller.this.appFrame.setCursor(null);
                }
            });
            thread.start();
        }

        protected void loadFile(File file) {
            try {
                Object object;
                BufferedImage bufferedImage = this.imageReader.read(file);
                SurfaceImage surfaceImage = null;
                File file2 = this.getAssociatedTABFile(file);
                if (file2 != null) {
                    surfaceImage = this.createSurfaceImageFromTABFile(bufferedImage, file2);
                }
                if (surfaceImage == null && (object = this.getAssociatedGCPSFile(file)) != null) {
                    surfaceImage = this.createSurfaceImageFromGCPSFile(bufferedImage, (File)object);
                }
                if (surfaceImage == null && (object = this.getAssociatedWorldFiles(file)) != null) {
                    surfaceImage = this.createSurfaceImageFromWorldFiles(bufferedImage, (File[])object);
                }
                if (surfaceImage == null) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("Unable to find geographic coordinates for: ");
                    ((StringBuilder)object).append("\"").append(file.getPath()).append("\"");
                    ((StringBuilder)object).append("\n");
                    ((StringBuilder)object).append("Open image anyway?");
                    int n = JOptionPane.showConfirmDialog(this.appFrame, object, null, 0);
                    if (n == 0) {
                        surfaceImage = this.createSurfaceImageFromViewport(bufferedImage, this.appFrame.getWwd());
                    }
                }
                if (surfaceImage != null) {
                    this.addSurfaceImage(surfaceImage, file.getName());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public File getAssociatedTABFile(File file) {
            TABRasterReader tABRasterReader;
            File file2 = TABRasterReader.getTABFileFor(file);
            if (file2 != null && file2.exists() && (tABRasterReader = new TABRasterReader()).canRead(file2)) {
                return file2;
            }
            return null;
        }

        public File getAssociatedGCPSFile(File file) {
            GCPSReader gCPSReader;
            File file2 = GCPSReader.getGCPSFileFor(file);
            if (file2 != null && file2.exists() && (gCPSReader = new GCPSReader()).canRead(file2)) {
                return file2;
            }
            return null;
        }

        public File[] getAssociatedWorldFiles(File file) {
            try {
                File[] fileArray = WorldFile.getWorldFiles(file);
                if (fileArray != null && fileArray.length > 0) {
                    return fileArray;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        protected SurfaceImage createSurfaceImageFromWorldFiles(BufferedImage bufferedImage, File[] fileArray) throws IOException {
            AVListImpl aVListImpl = new AVListImpl();
            WorldFile.decodeWorldFiles(fileArray, aVListImpl);
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            Sector sector = ImageUtil.warpImageWithWorldFile(bufferedImage, aVListImpl, bufferedImage2);
            return new SurfaceImage((Object)bufferedImage2, sector);
        }

        protected SurfaceImage createSurfaceImageFromTABFile(BufferedImage bufferedImage, File file) throws IOException {
            TABRasterReader tABRasterReader = new TABRasterReader();
            RasterControlPointList rasterControlPointList = tABRasterReader.read(file);
            return this.createSurfaceImageFromControlPoints(bufferedImage, rasterControlPointList);
        }

        protected SurfaceImage createSurfaceImageFromGCPSFile(BufferedImage bufferedImage, File file) throws IOException {
            GCPSReader gCPSReader = new GCPSReader();
            RasterControlPointList rasterControlPointList = gCPSReader.read(file);
            return this.createSurfaceImageFromControlPoints(bufferedImage, rasterControlPointList);
        }

        protected SurfaceImage createSurfaceImageFromControlPoints(BufferedImage bufferedImage, RasterControlPointList rasterControlPointList) throws IOException {
            Object object;
            int n = rasterControlPointList.size();
            Point2D[] point2DArray = new Point2D[n];
            LatLon[] latLonArray = new LatLon[n];
            for (int i = 0; i < n; ++i) {
                object = (RasterControlPointList.ControlPoint)rasterControlPointList.get(i);
                point2DArray[i] = ((RasterControlPointList.ControlPoint)object).getRasterPoint();
                latLonArray[i] = ((RasterControlPointList.ControlPoint)object).getWorldPointAsLatLon();
            }
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
            object = ImageUtil.warpImageWithControlPoints(bufferedImage, point2DArray, latLonArray, bufferedImage2);
            return new SurfaceImage((Object)bufferedImage2, (Sector)object);
        }

        protected SurfaceImage createSurfaceImageFromViewport(BufferedImage bufferedImage, WorldWindow worldWindow) {
            Position position = ShapeUtils.getNewShapePosition(worldWindow);
            Angle angle = ShapeUtils.getNewShapeHeading(worldWindow, false);
            double d = ShapeUtils.getViewportScaleFactor(worldWindow);
            List<LatLon> list = ShapeUtils.createSquareInViewport(worldWindow, position, angle, d);
            return new SurfaceImage((Object)bufferedImage, list);
        }
    }

    public static class SurfaceImageEntry {
        private SurfaceImage surfaceImage;
        private SurfaceImageEditor editor;
        private RenderableLayer layer;

        public SurfaceImageEntry(WorldWindow worldWindow, SurfaceImage surfaceImage, String string) {
            this.surfaceImage = surfaceImage;
            this.editor = new SurfaceImageEditor(worldWindow, surfaceImage);
            this.layer = new RenderableLayer();
            this.layer.setName(string);
            this.layer.setPickEnabled(true);
            this.layer.addRenderable(surfaceImage);
            ApplicationTemplate.insertBeforePlacenames(worldWindow, this.layer);
        }

        public SurfaceImage getSurfaceImage() {
            return this.surfaceImage;
        }

        public SurfaceImageEditor getEditor() {
            return this.editor;
        }

        public RenderableLayer getLayer() {
            return this.layer;
        }
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame
    implements ActionListener {
        private Controller controller = new Controller(this);
        private JButton toggleEditButton;

        public AppFrame() {
            this.controller.loadBackgroundData();
            this.getWwd().addSelectListener(this.controller);
            this.initComponents();
        }

        public JButton getToggleEditButton() {
            return this.toggleEditButton;
        }

        private void initComponents() {
            JMenuBar jMenuBar = new JMenuBar();
            JComponent jComponent = new JMenu("File");
            JComponent jComponent2 = new JMenuItem("Open...");
            ((JMenuItem)jComponent2).setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            ((AbstractButton)jComponent2).setActionCommand(RubberSheetImage.OPEN_IMAGE_FILE);
            ((AbstractButton)jComponent2).addActionListener(this);
            ((JMenu)jComponent).add((JMenuItem)jComponent2);
            jMenuBar.add((JMenu)jComponent);
            this.setJMenuBar(jMenuBar);
            jComponent = new JPanel(new BorderLayout(0, 0));
            jComponent.setBorder(BorderFactory.createEmptyBorder(10, 10, 20, 0));
            jComponent2 = Box.createVerticalBox();
            JLabel jLabel = new JLabel("Opacity");
            final JSlider jSlider = new JSlider(0, 100, 100);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    ActionEvent actionEvent = new ActionEvent(jSlider, 0, RubberSheetImage.SET_IMAGE_OPACITY);
                    AppFrame.this.actionPerformed(actionEvent);
                }
            });
            Box box = Box.createHorizontalBox();
            box.setAlignmentX(0.0f);
            box.add(jLabel);
            box.add(jSlider);
            jComponent2.add(box);
            this.toggleEditButton = new JButton(RubberSheetImage.DISABLE_EDITING);
            this.toggleEditButton.setAlignmentX(0.0f);
            this.toggleEditButton.setActionCommand(RubberSheetImage.TOGGLE_EDITING);
            this.toggleEditButton.addActionListener(this);
            jComponent2.add(this.toggleEditButton);
            jComponent.add((Component)jComponent2, "North");
            this.getLayerPanel().add((Component)jComponent, "South");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent == null) {
                return;
            }
            if (this.controller == null) {
                return;
            }
            this.controller.actionPerformed(actionEvent);
        }
    }
}

