/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.cache.FileStore;
import gov.nasa.worldwind.data.BasicDataSource;
import gov.nasa.worldwind.data.DataDescriptor;
import gov.nasa.worldwind.data.DataRaster;
import gov.nasa.worldwind.data.DataSource;
import gov.nasa.worldwind.data.ImageIORasterReader;
import gov.nasa.worldwind.data.TiledImageProducer;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.layers.Layer;
import java.io.File;

public class RuntimeInstalledImagery
extends ApplicationTemplate {
    private static final String WWJ_SPLASH_PATH = "images/400x230-splash-nww.png";
    private static final String GEORSS_ICON_PATH = "images/georss.png";
    private static final String NASA_ICON_PATH = "images/32x32-icon-nasa.png";
    private static final String INSTALL_PATH = "RuntimeInstalledImagery/";

    private static Layer createImageLayer(DataDescriptor dataDescriptor) {
        if (!"gov.nasa.worldwind.avkey.TiledImagery".equals(dataDescriptor.getType())) {
            return null;
        }
        BasicTiledImageLayer basicTiledImageLayer = new BasicTiledImageLayer(dataDescriptor);
        basicTiledImageLayer.setNetworkRetrievalEnabled(false);
        basicTiledImageLayer.setUseTransparentTextures(true);
        if (dataDescriptor.getName() != null) {
            basicTiledImageLayer.setName(dataDescriptor.getName());
        }
        return basicTiledImageLayer;
    }

    private static DataSource createDataSource(String string, Sector sector) throws Exception {
        BasicDataSource basicDataSource = new BasicDataSource(string);
        basicDataSource.setValue("gov.nasa.worldwind.avKey.Sector", sector);
        return basicDataSource;
    }

    private static DataSource createRasterDataSource(String string, Sector sector) throws Exception {
        DataSource dataSource = RuntimeInstalledImagery.createDataSource(string, sector);
        ImageIORasterReader imageIORasterReader = new ImageIORasterReader();
        DataRaster[] dataRasterArray = imageIORasterReader.read(dataSource);
        return new BasicDataSource(dataRasterArray[0]);
    }

    private static DataDescriptor produceTiledImagery(String string, String string2, DataSource dataSource) throws Exception {
        String string3 = RuntimeInstalledImagery.getDefaultInstallLocation();
        DataDescriptor dataDescriptor = RuntimeInstalledImagery.findDataDescriptor(string3, string2);
        if (dataDescriptor != null) {
            return dataDescriptor;
        }
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FileStoreLocation", string3);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", string2);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", string);
        TiledImageProducer tiledImageProducer = new TiledImageProducer();
        tiledImageProducer.setStoreParameters(aVListImpl);
        tiledImageProducer.offerDataSource(dataSource);
        tiledImageProducer.startProduction();
        Iterable<?> iterable = tiledImageProducer.getProductionResults();
        if (!iterable.iterator().hasNext()) {
            return null;
        }
        Object obj = iterable.iterator().next();
        return obj != null && obj instanceof DataDescriptor ? (DataDescriptor)obj : null;
    }

    private static String getDefaultInstallLocation() {
        FileStore fileStore = WorldWind.getDataFileStore();
        for (File file : fileStore.getLocations()) {
            if (!fileStore.isInstallLocation(file.getPath()) || !file.exists() && !file.mkdirs()) continue;
            return file.getPath();
        }
        return null;
    }

    private static DataDescriptor findDataDescriptor(String string, String string2) {
        File file = new File(string, string2);
        try {
            for (DataDescriptor dataDescriptor : WorldWind.getDataFileStore().findDataDescriptors(string)) {
                File file2 = new File(dataDescriptor.getFileStoreLocation(), dataDescriptor.getFileStorePath());
                if (!file.equals(file2)) continue;
                return dataDescriptor;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Installed Surface Images", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            try {
                DataSource dataSource = RuntimeInstalledImagery.createDataSource(RuntimeInstalledImagery.WWJ_SPLASH_PATH, Sector.fromDegrees(35.0, 45.0, -115.0, -95.0));
                DataSource dataSource2 = RuntimeInstalledImagery.createDataSource(RuntimeInstalledImagery.GEORSS_ICON_PATH, Sector.fromDegrees(25.0, 33.0, -120.0, -110.0));
                DataSource dataSource3 = RuntimeInstalledImagery.createRasterDataSource(RuntimeInstalledImagery.NASA_ICON_PATH, Sector.fromDegrees(25.0, 35.0, -100.0, -90.0));
                DataDescriptor dataDescriptor = RuntimeInstalledImagery.produceTiledImagery("World Wind Splash Image", "RuntimeInstalledImagery/images/400x230-splash-nww.png", dataSource);
                DataDescriptor dataDescriptor2 = RuntimeInstalledImagery.produceTiledImagery("GeoRSS Icon", "RuntimeInstalledImagery/images/georss.png", dataSource2);
                DataDescriptor dataDescriptor3 = RuntimeInstalledImagery.produceTiledImagery("NASA Icon", "RuntimeInstalledImagery/images/32x32-icon-nasa.png", dataSource3);
                Layer layer = RuntimeInstalledImagery.createImageLayer(dataDescriptor);
                Layer layer2 = RuntimeInstalledImagery.createImageLayer(dataDescriptor2);
                Layer layer3 = RuntimeInstalledImagery.createImageLayer(dataDescriptor3);
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), layer3);
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), layer2);
                ApplicationTemplate.insertBeforeCompass(this.getWwd(), layer);
                this.getLayerPanel().update(this.getWwd());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

