/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.util.SectorSelector;
import gov.nasa.worldwind.geom.Sector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;

public class SectorSelection
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("Sector Selection", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private SectorSelector selector = new SectorSelector(this.getWwd());

        public AppFrame() {
            super(true, true, false);
            this.selector.setInteriorColor(new Color(1.0f, 1.0f, 1.0f, 0.1f));
            this.selector.setBorderColor(new Color(1.0f, 0.0f, 0.0f, 0.5f));
            this.selector.setBorderWidth(3.0);
            JButton jButton = new JButton(new EnableSelectorAction());
            jButton.setToolTipText("Press Start then press and drag button 1 on globe");
            JPanel jPanel = new JPanel(new BorderLayout(5, 5));
            jPanel.add((Component)jButton, "Center");
            this.getLayerPanel().add((Component)jPanel, "South");
            this.selector.addPropertyChangeListener("gov.nasa.worldwind.SectorSelector", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    Sector sector = (Sector)propertyChangeEvent.getNewValue();
                }
            });
        }

        private class DisableSelectorAction
        extends AbstractAction {
            public DisableSelectorAction() {
                super("Stop");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                AppFrame.this.selector.disable();
                ((JButton)actionEvent.getSource()).setAction(new EnableSelectorAction());
            }
        }

        private class EnableSelectorAction
        extends AbstractAction {
            public EnableSelectorAction() {
                super("Start");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ((JButton)actionEvent.getSource()).setAction(new DisableSelectorAction());
                AppFrame.this.selector.enable();
            }
        }
    }
}

