/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Version;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JFrame;

public class SplashScreen
extends JFrame {
    public static final String NASA_WORLDWIND_SPLASH = "/images/400x230-splash-nww.png";
    public static final String SDK_VERSION = "Java SDK Version " + Version.getVersionNumber();
    private BufferedImage image;
    private String version;

    public SplashScreen() {
        this(NASA_WORLDWIND_SPLASH, SDK_VERSION);
    }

    public SplashScreen(String string) {
        this(string, (String)null);
    }

    private SplashScreen(String string, String string2) {
        Serializable serializable;
        if (string == null) {
            String string3 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string3);
            throw new IllegalStateException(string3);
        }
        this.version = string2;
        this.setUndecorated(true);
        this.setSize(400, 230);
        URL uRL = SplashScreen.class.getResource(string);
        if (uRL == null && ((File)(serializable = new File(string))).exists()) {
            try {
                URI uRI = ((File)serializable).toURI();
                uRL = uRI.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                uRL = null;
                Logging.logger().severe(Logging.getMessage("generic.ImageReadFailed", string));
            }
        }
        if (uRL != null) {
            try {
                this.image = ImageIO.read(uRL);
                this.setSize(this.image.getWidth(), this.image.getHeight());
            }
            catch (IOException iOException) {
                this.image = null;
                Logging.logger().severe(Logging.getMessage("generic.ImageReadFailed", string));
            }
        }
        serializable = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (((Dimension)serializable).width - this.getSize().width) / 2;
        int n2 = (((Dimension)serializable).height - this.getSize().height) / 2;
        this.setLocation(n, n2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.image != null) {
            graphics2D.drawImage((Image)this.image, 0, 0, null);
        }
        if (this.version != null && this.version.length() > 0) {
            Font font = Font.decode("Arial-Bold-14");
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D = font.getStringBounds(this.version, fontRenderContext);
            int n = (int)((double)this.getWidth() - rectangle2D.getWidth()) / 2;
            int n2 = this.getHeight() / 2 + 32;
            graphics2D.setFont(font);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setColor(Color.BLACK);
            graphics2D.drawString(this.version, n + 1, n2 + 1);
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawString(this.version, n, n2);
        }
    }
}

