/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.wms.Capabilities;
import gov.nasa.worldwind.wms.WMSTiledImageLayer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import java.util.TreeSet;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StressWMS {
    private final int MAXNUMLAYERS = 20;
    private int numAvailableLayers;
    private final URI externalURI;
    private final URI bluemarbleURI = new URI("http://www.nasa.network.com/wms");
    private final TreeSet<LayerInfo> externalLayerInfos = new TreeSet<LayerInfo>(new Comparator<LayerInfo>(){

        @Override
        public int compare(LayerInfo layerInfo, LayerInfo layerInfo2) {
            String string = layerInfo.getTitle();
            String string2 = layerInfo2.getTitle();
            return string.compareTo(string2);
        }
    });
    private final TreeSet<LayerInfo> blueMarbleLayerInfos = new TreeSet<LayerInfo>(new Comparator<LayerInfo>(){

        @Override
        public int compare(LayerInfo layerInfo, LayerInfo layerInfo2) {
            String string = layerInfo.getTitle();
            String string2 = layerInfo2.getTitle();
            return string.compareTo(string2);
        }
    });

    public StressWMS(String string) throws URISyntaxException {
        this.externalURI = new URI(string.trim());
        Thread thread = new Thread(new Runnable(){

            public void run() {
                StressWMS.this.load(StressWMS.this.bluemarbleURI, StressWMS.this.blueMarbleLayerInfos);
                StressWMS.this.load(StressWMS.this.externalURI, StressWMS.this.externalLayerInfos);
                StressWMS.this.setSize();
            }
        });
        thread.setPriority(1);
        thread.start();
    }

    private void load(URI uRI, TreeSet<LayerInfo> treeSet) {
        Capabilities capabilities = null;
        try {
            capabilities = Capabilities.retrieve(uRI, "WMS");
        }
        catch (Exception exception) {
            Logging.logger().severe("Error initializing WMS URI: " + uRI.toString() + "  " + exception.getMessage());
            return;
        }
        if (capabilities != null && capabilities.getNamedLayers() != null) {
            Element[] elementArray = capabilities.getNamedLayers();
            try {
                for (Element element : elementArray) {
                    Element[] elementArray2 = capabilities.getLayerStyles(element);
                    if (elementArray2 == null) {
                        LayerInfo layerInfo = this.createLayerInfo(capabilities, element, null);
                        treeSet.add(layerInfo);
                        continue;
                    }
                    for (Element element2 : elementArray2) {
                        LayerInfo layerInfo = this.createLayerInfo(capabilities, element, element2);
                        treeSet.add(layerInfo);
                    }
                }
            }
            catch (Exception exception) {
                Logging.logger().severe("Error initializing WMS URI: " + uRI.toString() + "  Error: " + exception.getMessage());
            }
        }
    }

    private void setSize() {
        this.numAvailableLayers = 0;
        if (this.blueMarbleLayerInfos.size() >= 4) {
            this.numAvailableLayers = 4;
        }
        if (this.externalLayerInfos != null && this.externalLayerInfos.size() > 0) {
            this.numAvailableLayers += this.externalLayerInfos.size();
        }
    }

    public int size() {
        return Math.min(this.numAvailableLayers, 20);
    }

    public Layer getLayer(int n) {
        if (n < 4) {
            Object[] objectArray = this.blueMarbleLayerInfos.toArray();
            LayerInfo layerInfo = (LayerInfo)objectArray[n];
            WMSTiledImageLayer wMSTiledImageLayer = new WMSTiledImageLayer(layerInfo.caps, layerInfo.params);
            wMSTiledImageLayer.setEnabled(false);
            wMSTiledImageLayer.setEnabled(true);
            wMSTiledImageLayer.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 30000);
            wMSTiledImageLayer.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", 30000);
            wMSTiledImageLayer.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 60000);
            return wMSTiledImageLayer;
        }
        if (n < this.size()) {
            Object[] objectArray = this.externalLayerInfos.toArray();
            LayerInfo layerInfo = (LayerInfo)objectArray[n -= 4];
            WMSTiledImageLayer wMSTiledImageLayer = new WMSTiledImageLayer(layerInfo.caps, layerInfo.params);
            wMSTiledImageLayer.setEnabled(false);
            wMSTiledImageLayer.setEnabled(true);
            wMSTiledImageLayer.setValue("gov.nasa.worldwind.avkey.URLConnectTimeout", 30000);
            wMSTiledImageLayer.setValue("gov.nasa.worldwind.avkey.URLReadTimeout", 30000);
            wMSTiledImageLayer.setValue("gov.nasa.worldwind.avkey.RetrievalStaleRequestLimit", 60000);
            return wMSTiledImageLayer;
        }
        return null;
    }

    private LayerInfo createLayerInfo(Capabilities capabilities, Element element, Element element2) {
        LayerInfo layerInfo = new LayerInfo();
        layerInfo.caps = capabilities;
        layerInfo.params = new AVListImpl();
        layerInfo.params.setValue("gov.nasa.worldwind.avkey.LayerNames", capabilities.getLayerName(element));
        if (element2 != null) {
            layerInfo.params.setValue("gov.nasa.worldwind.avkey.StyleNames", capabilities.getStyleName(element, element2));
        }
        layerInfo.params.setValue("gov.nasa.worldwind.avkey.Title", StressWMS.makeTitle(layerInfo));
        return layerInfo;
    }

    private static String makeTitle(LayerInfo layerInfo) {
        String string = layerInfo.params.getStringValue("gov.nasa.worldwind.avkey.LayerNames");
        String string2 = layerInfo.params.getStringValue("gov.nasa.worldwind.avkey.StyleNames");
        String[] stringArray = string.split(",");
        String[] stringArray2 = string2 != null ? string2.split(",") : null;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            String string3 = stringArray[i];
            Element element = layerInfo.caps.getLayerByName(string3);
            String string4 = layerInfo.caps.getLayerTitle(element);
            stringBuilder.append(string4 != null ? string4 : string3);
            if (stringArray2 == null || stringArray2.length <= i) continue;
            String string5 = stringArray2[i];
            Element element2 = layerInfo.caps.getLayerStyleByName(element, string5);
            if (element2 == null) continue;
            stringBuilder.append(" : ");
            String string6 = layerInfo.caps.getStyleTitle(element, element2);
            stringBuilder.append(string6 != null ? string6 : string5);
        }
        return stringBuilder.toString();
    }

    private static class LayerInfo {
        private Capabilities caps;
        private AVListImpl params = new AVListImpl();

        private LayerInfo() {
        }

        private String getTitle() {
            return this.params.getStringValue("gov.nasa.worldwind.avkey.Title");
        }
    }
}

