/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.BasicDragger;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.SurfaceShapeLayer;
import gov.nasa.worldwind.layers.placename.PlaceNameLayer;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.render.AbstractSurfaceShape;
import gov.nasa.worldwind.render.AnnotationShadow;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceIcon;
import gov.nasa.worldwind.render.SurfaceShape;
import gov.nasa.worldwind.render.SurfaceText;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;

public class SurfaceObjects
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLatitude", 47.15);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialLongitude", -122.74);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialAltitude", 300000.0);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialPitch", 60);
        Configuration.setValue("gov.nasa.worldwind.avkey.InitialHeading", 155);
        ApplicationTemplate.start("World Wind Surface Objects", AppFrame.class);
    }

    private static class AppFrame
    extends ApplicationTemplate.AppFrame {
        protected SurfaceShape lastHighlitShape;
        protected ShapeAttributes lastShapeAttributes;
        protected BasicDragger dragger;
        protected boolean drawWireframeInterior = false;
        protected boolean drawWireframeExterior = false;

        public AppFrame() {
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.buildShapesLayer());
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!(layer instanceof PlaceNameLayer)) continue;
                layer.setEnabled(false);
            }
            this.getLayerPanel().update(this.getWwd());
            this.dragger = new BasicDragger(this.getWwd());
            this.getWwd().addSelectListener(new SelectListener(){

                public void selected(SelectEvent selectEvent) {
                    if (!(AppFrame.this.lastHighlitShape == null || selectEvent.getTopObject() != null && selectEvent.getTopObject().equals(AppFrame.this.lastHighlitShape))) {
                        AppFrame.this.lastHighlitShape.setAttributes(AppFrame.this.lastShapeAttributes);
                        AppFrame.this.lastHighlitShape = null;
                    }
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && !AppFrame.this.dragger.isDragging()) {
                        AppFrame.this.highlight(selectEvent.getTopObject());
                    } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
                        PickedObjectList pickedObjectList;
                        AppFrame.this.dragger.selected(selectEvent);
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd") && (pickedObjectList = AppFrame.this.getWwd().getObjectsAtCurrentPosition()) != null) {
                            AppFrame.this.highlight(pickedObjectList.getTopObject());
                            AppFrame.this.getWwd().repaint();
                        }
                    }
                }
            });
        }

        protected void highlight(Object object) {
            if (object == this.lastHighlitShape) {
                return;
            }
            if (this.lastHighlitShape == null && object instanceof AbstractSurfaceShape) {
                this.lastHighlitShape = (AbstractSurfaceShape)object;
                this.lastShapeAttributes = this.lastHighlitShape.getAttributes();
                ShapeAttributes shapeAttributes = this.getHighlightAttributes(this.lastShapeAttributes);
                this.lastHighlitShape.setAttributes(shapeAttributes);
            }
        }

        protected ShapeAttributes getHighlightAttributes(ShapeAttributes shapeAttributes) {
            BasicShapeAttributes basicShapeAttributes = new BasicShapeAttributes(shapeAttributes);
            if (basicShapeAttributes.isDrawInterior()) {
                basicShapeAttributes.setInteriorMaterial(Material.WHITE);
            } else if (basicShapeAttributes.isDrawOutline()) {
                basicShapeAttributes.setOutlineMaterial(Material.WHITE);
            }
            return basicShapeAttributes;
        }

        protected Layer buildShapesLayer() {
            SurfaceShapeLayer surfaceShapeLayer = new SurfaceShapeLayer();
            Font font = Font.decode("Arial-BOLD-24");
            Color color = Color.WHITE;
            surfaceShapeLayer.addRenderable(new SurfaceText("SEATTLE", LatLon.fromDegrees(47.6, -122.33), font, color));
            surfaceShapeLayer.addRenderable(new SurfaceText("PORTLAND", LatLon.fromDegrees(45.52, -122.67), font, color));
            surfaceShapeLayer.addRenderable(new SurfaceText("SAN FRANCSISCO", LatLon.fromDegrees(37.77, -122.42), font, color));
            color = Color.GREEN;
            surfaceShapeLayer.addRenderable(new SurfaceText("Mt SHASTA", LatLon.fromDegrees(41.4, -122.19), font, color));
            surfaceShapeLayer.addRenderable(new SurfaceText("Mt RAINIER", LatLon.fromDegrees(46.85, -121.76), font, color));
            surfaceShapeLayer.addRenderable(new SurfaceText("Mt ADAMS", LatLon.fromDegrees(46.2, -121.49), font, color));
            SurfaceText surfaceText = new SurfaceText("ALPES", LatLon.fromDegrees(45.8, 7.6), Font.decode("Arial-BOLD-54"), Color.CYAN);
            surfaceShapeLayer.addRenderable(surfaceText);
            SurfaceIcon surfaceIcon = new SurfaceIcon("images/notched-compass.png", LatLon.fromDegrees(47.74, -123.44));
            surfaceIcon.setColor(Color.YELLOW);
            surfaceIcon.setOpacity(0.3);
            surfaceIcon.setScale(0.5);
            surfaceIcon.setMaxSize(50000.0);
            surfaceShapeLayer.addRenderable(surfaceIcon);
            AnnotationShadow annotationShadow = new AnnotationShadow("<p>\n<b><font color=\"#664400\">MOUNT SAINT HELENS</font></b><br />\n<i>Alt: 2549m</i>\n</p>\n<p>\nMount St. Helens is an active stratovolcano located in Skamania County, Washington, USA.\n</p>", Position.fromDegrees(46.19, -122.18, 0.0));
            annotationShadow.getAttributes().setFont(Font.decode("SansSerif-PLAIN-14"));
            annotationShadow.getAttributes().setTextColor(Color.BLACK);
            annotationShadow.getAttributes().setTextAlign(2);
            annotationShadow.getAttributes().setBackgroundColor(new Color(1.0f, 1.0f, 1.0f, 0.7f));
            annotationShadow.getAttributes().setBorderColor(Color.BLACK);
            annotationShadow.getAttributes().setSize(new Dimension(180, 0));
            annotationShadow.getAttributes().setImageSource("images/32x32-icon-earth.png");
            annotationShadow.getAttributes().setImageRepeat("render.Annotation.RepeatNone");
            annotationShadow.getAttributes().setImageOpacity(0.6);
            annotationShadow.getAttributes().setImageScale(0.7);
            annotationShadow.getAttributes().setImageOffset(new Point(12, 12));
            annotationShadow.getAttributes().setAntiAliasHint(4354);
            annotationShadow.getAttributes().setInsets(new Insets(12, 20, 20, 12));
            surfaceShapeLayer.addRenderable(annotationShadow);
            return surfaceShapeLayer;
        }
    }
}

