/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.terrain.BasicElevationModelFactory;
import gov.nasa.worldwind.terrain.CompoundElevationModel;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.List;

public class TruncatedEarth
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind Truncated Earth", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        public AppFrame() {
            super(true, true, false);
            Model model = this.getWwd().getModel();
            Globe globe = model.getGlobe();
            Sector sector = Sector.fromDegrees(0.0, 90.0, -100.0, -20.0);
            double d = -4000000.0;
            globe.setElevationModel(new TruncatedEarthElevationModel(sector, d));
            RenderableLayer renderableLayer = new RenderableLayer();
            renderableLayer.setPickEnabled(false);
            renderableLayer.setName("Earth Section");
            BufferedImage bufferedImage = PatternFactory.createPattern("PatternFactory.GradientHLinear", 1.0f, Color.RED.brighter().brighter(), Color.RED.darker().darker());
            BufferedImage bufferedImage2 = PatternFactory.createPattern("PatternFactory.GradientHLinear", 1.0f, Color.ORANGE.brighter().brighter(), Color.ORANGE.darker().darker());
            renderableLayer.addRenderable(new SurfaceImage((Object)bufferedImage, Sector.fromDegrees(Math.max(sector.getMinLatitude().degrees - 2.0, -90.0), Math.min(sector.getMaxLatitude().degrees + 2.0, 90.0), sector.getMinLongitude().degrees - 1.0, sector.getMaxLongitude().degrees + 1.0)));
            renderableLayer.addRenderable(new SurfaceImage((Object)bufferedImage2, Sector.fromDegrees(sector.getMinLatitude().degrees + 1.0, sector.getMaxLatitude().degrees - 1.0, sector.getMinLongitude().degrees + 2.0, sector.getMaxLongitude().degrees - 2.0)));
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), renderableLayer);
            for (Layer layer : model.getLayers()) {
                if (!(layer instanceof SkyGradientLayer)) continue;
                layer.setEnabled(false);
            }
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().getView().setFarClipDistance(globe.getDiameter() * 3.0);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class TruncatedEarthElevationModel
        extends CompoundElevationModel {
            private Sector truncatedSector;
            private double truncatedElevation;

            public TruncatedEarthElevationModel(Sector sector, Double d) {
                BasicElevationModelFactory basicElevationModelFactory = new BasicElevationModelFactory();
                this.addElevationModel(basicElevationModelFactory.createFromConfigFile("config/LegacyEarthElevationModel.xml"));
                this.truncatedSector = sector;
                this.truncatedElevation = d;
            }

            @Override
            public double getElevation(Angle angle, Angle angle2) {
                if (angle == null || angle2 == null) {
                    String string = Logging.getMessage("nullValue.LatLonIsNull");
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
                if (this.truncatedSector.contains(angle, angle2)) {
                    return this.truncatedElevation;
                }
                return super.getElevation(angle, angle2);
            }

            @Override
            public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
                double d2 = super.getElevations(sector, list, d, dArray);
                int n = 0;
                for (LatLon latLon : list) {
                    if (this.truncatedSector.contains(latLon)) {
                        dArray[n] = this.truncatedElevation;
                    }
                    ++n;
                }
                return d2;
            }

            @Override
            public double[] getExtremeElevations(Sector sector) {
                double[] dArray = super.getExtremeElevations(sector);
                if (this.truncatedSector.intersects(sector)) {
                    dArray[0] = this.truncatedElevation;
                }
                return dArray;
            }
        }
    }
}

