/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Model;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.awt.WorldWindowGLCanvas;
import gov.nasa.worldwind.examples.ClickAndGoSelectListener;
import gov.nasa.worldwind.examples.LayerPanel;
import gov.nasa.worldwind.layers.WorldMapLayer;
import gov.nasa.worldwind.util.StatusBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public class UsageInSplitPane {
    public static void main(String[] stringArray) {
        UsageInSplitPane.start("World Wind Split Pane Usage", AppFrame.class);
    }

    public static void start(String string, Class clazz) {
        if (Configuration.isMacOS() && string != null) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string);
        }
        try {
            final AppFrame appFrame = new AppFrame();
            appFrame.setTitle(string);
            appFrame.setDefaultCloseOperation(3);
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    appFrame.setVisible(true);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class AppFrame
    extends JFrame {
        private Dimension canvasSize = new Dimension(800, 600);

        public AppFrame() {
            AppPanel appPanel = new AppPanel(this.canvasSize, false);
            LayerPanel layerPanel = new LayerPanel(appPanel.wwd);
            JSplitPane jSplitPane = new JSplitPane();
            jSplitPane.setOrientation(1);
            jSplitPane.setLeftComponent(layerPanel);
            jSplitPane.setRightComponent(appPanel);
            this.getContentPane().add((Component)jSplitPane, "Center");
            this.pack();
            Dimension dimension = this.getPreferredSize();
            Point point = new Point(0, 0);
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            int n = point.x + (dimension2.width - dimension.width) / 2;
            int n2 = point.y + (dimension2.height - dimension.height) / 2;
            this.setLocation(n, n2);
            this.setResizable(true);
        }
    }

    public static class AppPanel
    extends JPanel {
        private WorldWindowGLCanvas wwd = new WorldWindowGLCanvas();

        public AppPanel(Dimension dimension, boolean bl) {
            super(new BorderLayout());
            this.wwd.setPreferredSize(dimension);
            this.setMinimumSize(new Dimension(0, 0));
            Model model = (Model)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.ModelClassName");
            this.wwd.setModel(model);
            this.wwd.addSelectListener(new ClickAndGoSelectListener(this.wwd, WorldMapLayer.class));
            this.add((Component)this.wwd, "Center");
            if (bl) {
                StatusBar statusBar = new StatusBar();
                this.add((Component)statusBar, "Last");
                statusBar.setEventSource(this.wwd);
            }
        }
    }
}

