/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples;

import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.layers.CompassLayer;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.ViewControlsLayer;
import gov.nasa.worldwind.layers.ViewControlsSelectListener;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewControls
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        ApplicationTemplate.start("World Wind View Controls", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        ViewControlsLayer viewControlsLayer = new ViewControlsLayer();

        public AppFrame() {
            super(true, true, false);
            ApplicationTemplate.insertBeforeCompass(this.getWwd(), this.viewControlsLayer);
            this.getLayerPanel().update(this.getWwd());
            this.getWwd().addSelectListener(new ViewControlsSelectListener(this.getWwd(), this.viewControlsLayer));
            for (Layer layer : this.getWwd().getModel().getLayers()) {
                if (!(layer instanceof CompassLayer)) continue;
                layer.setPickEnabled(true);
            }
            this.getWwd().addSelectListener(new SelectListener(){
                Angle dragStartHeading = null;
                Angle viewStartHeading = null;
                OrbitView view = (OrbitView)AppFrame.this.getWwd().getView();

                public void selected(SelectEvent selectEvent) {
                    if (selectEvent.getTopObject() instanceof CompassLayer) {
                        Angle angle = (Angle)selectEvent.getTopPickedObject().getValue("Heading");
                        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag") && this.dragStartHeading == null) {
                            this.dragStartHeading = angle;
                            this.viewStartHeading = this.view.getHeading();
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && this.dragStartHeading != null) {
                            double d = angle.degrees - this.dragStartHeading.degrees;
                            double d2 = this.viewStartHeading.degrees - d;
                            d2 = d2 >= 0.0 ? d2 : d2 + 360.0;
                            this.view.stopStateIterators();
                            this.view.setHeading(Angle.fromDegrees(d2));
                        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
                            this.dragStartHeading = null;
                        }
                    }
                }
            });
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("View Controls")));
            jPanel.setToolTipText("Select active view controls");
            JPanel jPanel2 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton("Horizontal", true);
            buttonGroup.add(jRadioButton);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewControlsLayer.setLayout("gov.nasa.worldwind.avkey.LayoutHorizontal");
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel2.add(jRadioButton);
            jRadioButton = new JRadioButton("Vertical", false);
            buttonGroup.add(jRadioButton);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewControlsLayer.setLayout("gov.nasa.worldwind.avkey.LayoutVertical");
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel2.add(jRadioButton);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel3.add(new JLabel("Scale:"));
            JSlider jSlider = new JSlider(1, 20, 10);
            jSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.viewControlsLayer.setScale((double)((JSlider)changeEvent.getSource()).getValue() / 10.0);
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel3.add(jSlider);
            JPanel jPanel4 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JCheckBox jCheckBox = new JCheckBox("Pan");
            jCheckBox.setSelected(true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewControlsLayer.setShowPanControls(((JCheckBox)actionEvent.getSource()).isSelected());
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel4.add(jCheckBox);
            jCheckBox = new JCheckBox("Look");
            jCheckBox.setSelected(false);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewControlsLayer.setShowLookControls(((JCheckBox)actionEvent.getSource()).isSelected());
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel4.add(jCheckBox);
            jCheckBox = new JCheckBox("Zoom");
            jCheckBox.setSelected(true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewControlsLayer.setShowZoomControls(((JCheckBox)actionEvent.getSource()).isSelected());
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel4.add(jCheckBox);
            jCheckBox = new JCheckBox("Heading");
            jCheckBox.setSelected(true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewControlsLayer.setShowHeadingControls(((JCheckBox)actionEvent.getSource()).isSelected());
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel4.add(jCheckBox);
            jCheckBox = new JCheckBox("Pitch");
            jCheckBox.setSelected(true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewControlsLayer.setShowPitchControls(((JCheckBox)actionEvent.getSource()).isSelected());
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel4.add(jCheckBox);
            jCheckBox = new JCheckBox("Field of view");
            jCheckBox.setSelected(false);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.viewControlsLayer.setShowFovControls(((JCheckBox)actionEvent.getSource()).isSelected());
                    AppFrame.this.getWwd().redraw();
                }
            });
            jPanel4.add(jCheckBox);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            return jPanel;
        }
    }
}

