/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.sunlight;

import gov.nasa.worldwind.View;
import gov.nasa.worldwind.examples.sunlight.AtmosphericScatteringComputer;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class AtmosphereLayer
extends AbstractLayer {
    protected static final int STACKS = 24;
    protected static final int SLICES = 64;
    protected int glListId = -1;
    protected double thickness = 60000.0;
    protected double lastRebuildHorizon = 0.0;
    protected AtmosphericScatteringComputer asc;
    protected Vec4 sunDirection;
    protected boolean update = true;

    public double getAtmosphereThickness() {
        return this.thickness;
    }

    public void setAtmosphereThickness(double d) {
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.thickness = d;
        this.asc = null;
        this.update = true;
    }

    public Vec4 getSunDirection() {
        return this.sunDirection;
    }

    public void setSunDirection(Vec4 vec4) {
        this.sunDirection = vec4;
        this.update = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            double d;
            View view = drawContext.getView();
            Position position = drawContext.getGlobe().computePositionFromPoint(view.getEyePoint());
            double d2 = drawContext.getGlobe().getRadiusAt(position);
            double d3 = view.getEyePoint().getLength3();
            double d4 = position.getElevation();
            double d5 = d = view.computeHorizonDistance();
            double d6 = (-1.5707963267948966 + Math.acos(d / d3)) * 180.0 / Math.PI;
            double d7 = 90.0;
            if (d4 >= this.thickness) {
                double d8 = Math.sqrt(d3 * d3 - (d2 + this.thickness) * (d2 + this.thickness));
                d7 = (-1.5707963267948966 + Math.acos(d8 / d3)) * 180.0 / Math.PI;
            }
            if (d4 < this.thickness && d4 > this.thickness * 0.7) {
                d7 = (this.thickness - d4) / (this.thickness - this.thickness * 0.7) * 90.0;
            }
            if (this.update || this.glListId == -1 || Math.abs(this.lastRebuildHorizon - d) > 100.0) {
                if (this.glListId != -1) {
                    gL.glDeleteLists(this.glListId, 1);
                }
                this.makeSkyDome(drawContext, (float)d5, d6, d7, 64, 24);
                this.lastRebuildHorizon = d;
                this.update = false;
            }
            gL.glPushAttrib(8);
            gL.glPopAttrib();
            gL.glPushAttrib(291081);
            bl = true;
            gL.glDisable(3553);
            gL.glDisable(2929);
            gL.glDepthMask(false);
            Matrix matrix = Matrix.fromPerspective(view.getFieldOfView(), view.getViewport().getWidth(), view.getViewport().getHeight(), 10000.0, 2.0 * d3 + 10000.0);
            double[] dArray = new double[16];
            matrix.toArray(dArray, 0, false);
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadMatrixd(dArray, 0);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            Matrix matrix2 = this.computeSkyTransform(drawContext);
            Matrix matrix3 = view.getModelviewMatrix().multiply(matrix2);
            matrix3.toArray(dArray, 0, false);
            gL.glLoadMatrixd(dArray, 0);
            if (this.glListId != -1) {
                gL.glCallList(this.glListId);
            }
        }
        finally {
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    protected void makeSkyDome(DrawContext drawContext, float f, double d, double d2, int n, int n2) {
        if (this.sunDirection == null) {
            return;
        }
        GL gL = drawContext.getGL();
        this.glListId = gL.glGenLists(1);
        gL.glNewList(this.glListId, 4864);
        this.drawSkyGradient(drawContext, f, d, d2, n, n2);
        gL.glEndList();
    }

    protected void drawSkyGradient(DrawContext drawContext, float f, double d, double d2, int n, int n2) {
        Color color;
        Vec4 vec4;
        double d3;
        int n3;
        if (this.asc == null) {
            this.asc = new AtmosphericScatteringComputer(drawContext.getGlobe().getRadius(), this.thickness);
        }
        Matrix matrix = this.computeSkyTransform(drawContext);
        GL gL = drawContext.getGL();
        gL.glBlendFunc(770, 771);
        gL.glEnable(3042);
        gL.glDisable(3553);
        double d4 = d2;
        Color[] colorArray = new Color[n + 1];
        Vec4 vec42 = drawContext.getView().getEyePoint();
        double d5 = d - Math.max((d2 - d) / 4.0, 2.0);
        gL.glBegin(8);
        for (n3 = 0; n3 <= n; ++n3) {
            d3 = 180.0f - (float)n3 / (float)n * 360.0f;
            Vec4 vec43 = AtmosphereLayer.SphericalToCartesian(d5, d3, f);
            vec4 = AtmosphereLayer.SphericalToCartesian(d, d3, f);
            color = this.asc.getAtmosphereColor(vec4.transformBy4(matrix), vec42, this.sunDirection);
            gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.0f);
            gL.glVertex3d(vec43.getX(), vec43.getY(), vec43.getZ());
            gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
            gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
            colorArray[n3] = color;
        }
        gL.glEnd();
        for (n3 = 1; n3 < n2 - 1; ++n3) {
            double d6 = (float)(n3 - 1) / ((float)n2 - 1.0f);
            double d7 = 1.0 - Math.cos(d6 * Math.PI / 2.0);
            d5 = d + Math.pow(d7, 3.0) * (d2 - d);
            double d8 = (float)n3 / ((float)n2 - 1.0f);
            double d9 = 1.0 - Math.cos(d8 * Math.PI / 2.0);
            d4 = d + Math.pow(d9, 3.0) * (d2 - d);
            gL.glBegin(8);
            for (int i = 0; i <= n; ++i) {
                d3 = 180.0f - (float)i / (float)n * 360.0f;
                vec4 = AtmosphereLayer.SphericalToCartesian(d5, d3, f);
                color = colorArray[i];
                gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
                gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
                vec4 = AtmosphereLayer.SphericalToCartesian(d4, d3, f);
                color = this.asc.getAtmosphereColor(vec4.transformBy4(matrix), vec42, this.sunDirection);
                gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
                gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
                colorArray[i] = color;
            }
            gL.glEnd();
        }
        if (d2 < 90.0) {
            gL.glBegin(8);
            for (n3 = 0; n3 <= n; ++n3) {
                d3 = 180.0f - (float)n3 / (float)n * 360.0f;
                Vec4 vec44 = AtmosphereLayer.SphericalToCartesian(d4, d3, f);
                color = colorArray[n3];
                gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
                gL.glVertex3d(vec44.getX(), vec44.getY(), vec44.getZ());
                vec44 = AtmosphereLayer.SphericalToCartesian(d2, d3, f);
                gL.glColor4f((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 0.0f);
                gL.glVertex3d(vec44.getX(), vec44.getY(), vec44.getZ());
            }
            gL.glEnd();
        }
        gL.glEnable(3553);
        gL.glDisable(3042);
    }

    protected Matrix computeSkyTransform(DrawContext drawContext) {
        Matrix matrix = Matrix.IDENTITY;
        matrix = matrix.multiply(drawContext.getGlobe().computeTransformToPosition(drawContext.getView().getEyePosition()));
        matrix = matrix.multiply(Matrix.fromRotationX(Angle.POS90));
        return matrix;
    }

    protected static Vec4 SphericalToCartesian(double d, double d2, double d3) {
        double d4 = d3 * Math.cos(d *= Math.PI / 180);
        return new Vec4(d4 * Math.sin(d2 *= Math.PI / 180), d3 * Math.sin(d), d4 * Math.cos(d2));
    }

    public void dispose() {
        if (this.glListId < 0) {
            return;
        }
        GLContext gLContext = GLContext.getCurrent();
        if (gLContext == null) {
            return;
        }
        gLContext.getGL().glDeleteLists(this.glListId, 1);
        this.glListId = -1;
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.SkyGradientLayer.Name");
    }
}

