/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.sunlight;

import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.PatternFactory;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ScreenAnnotation;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;

public class LensFlareLayer
extends RenderableLayer {
    private static double SUN_DISTANCE = 1.49597892E11;
    private Vec4 sunDirection;
    private Vec4 sunPoint;
    public static final String PRESET_BOLD = "LensFlare.PresetBold";

    public LensFlareLayer() {
        this.setName("Lens Flare");
        this.setPickEnabled(false);
    }

    public Vec4 getSunDirection() {
        return this.sunDirection;
    }

    public void setSunDirection(Vec4 vec4) {
        if (vec4 != null) {
            this.sunDirection = vec4.normalize3();
            this.sunPoint = this.sunDirection.multiply3(SUN_DISTANCE);
        } else {
            this.sunDirection = null;
            this.sunPoint = null;
        }
    }

    public void render(DrawContext drawContext) {
        if (this.sunPoint == null) {
            return;
        }
        if (drawContext.getView().getFrustumInModelCoordinates().getNear().distanceTo(this.sunPoint) < 0.0) {
            return;
        }
        Vec4 vec4 = drawContext.getView().project(this.sunPoint);
        if (vec4 == null) {
            return;
        }
        Rectangle rectangle = drawContext.getView().getViewport();
        if (!rectangle.contains(vec4.x, vec4.y)) {
            return;
        }
        Line line = new Line(drawContext.getView().getEyePoint(), this.sunDirection);
        if (drawContext.getSurfaceGeometry().intersect(line) != null) {
            return;
        }
        Point point = new Point(rectangle.width / 2, rectangle.height / 2);
        Point point2 = new Point((int)vec4.x, (int)vec4.y);
        for (Renderable renderable : this.getRenderables()) {
            if (!(renderable instanceof FlareImage)) continue;
            ((FlareImage)renderable).update(point2, point);
        }
        super.render(drawContext);
    }

    public static LensFlareLayer getPresetInstance(String string) {
        LensFlareLayer lensFlareLayer = new LensFlareLayer();
        BufferedImage bufferedImage = LensFlareLayer.createDiskImage(64, Color.YELLOW);
        BufferedImage bufferedImage2 = LensFlareLayer.createHaloImage(64, new Color(1.0f, 1.0f, 0.8f), 2.0f);
        BufferedImage bufferedImage3 = LensFlareLayer.createDiskImage(128, Color.WHITE);
        BufferedImage bufferedImage4 = LensFlareLayer.createStarImage(128, Color.WHITE);
        BufferedImage bufferedImage5 = LensFlareLayer.createHaloImage(128, Color.WHITE);
        BufferedImage bufferedImage6 = LensFlareLayer.createRainbowImage(128);
        BufferedImage bufferedImage7 = LensFlareLayer.createRaysImage(128, 12, Color.WHITE);
        if (PRESET_BOLD.equals(string)) {
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage7, 4.0, 0.0, 0.05));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage4, 1.4, 0.0, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage4, 2.5, 0.0, 0.04));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage2, 0.6, 0.0, 0.9));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage5, 1.0, 0.0, 0.9));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage5, 4.0, 0.0, 0.9));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage6, 2.2, 0.0, 0.03));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage6, 1.2, 0.0, 0.04));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.1, 0.4, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.15, 0.6, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.2, 0.7, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.5, 1.1, 0.2));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.2, 1.3, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.1, 1.4, 0.05));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.1, 1.5, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.1, 1.6, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.2, 1.65, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.12, 1.71, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 3.0, 2.2, 0.05));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.5, 2.4, 0.2));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.7, 2.6, 0.1));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage6, 5.0, 3.0, 0.03));
            lensFlareLayer.addRenderable(new FlareImage(bufferedImage3, 0.2, 3.5, 0.1));
        }
        return lensFlareLayer;
    }

    public static BufferedImage createDiskImage(int n, Color color) {
        return PatternFactory.createPattern("PatternFactory.PatternCircle", new Dimension(n, n), 0.9f, color);
    }

    public static BufferedImage createBluredDiskImage(int n, Color color) {
        BufferedImage bufferedImage = PatternFactory.createPattern("PatternFactory.PatternCircle", new Dimension(n, n), 0.6f, color);
        bufferedImage = PatternFactory.blur(bufferedImage, n / 5);
        bufferedImage = PatternFactory.blur(bufferedImage, 10);
        return bufferedImage;
    }

    public static BufferedImage createStarImage(int n, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        float f = (float)n / 2.0f;
        float f2 = f * 0.9f;
        float f3 = f * 0.1f;
        float f4 = f * 0.05f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f - f2, f);
        generalPath.lineTo(f - f3, f - f4);
        generalPath.lineTo(f - f4, f - f3);
        generalPath.lineTo(f, f - f2);
        generalPath.lineTo(f + f4, f - f3);
        generalPath.lineTo(f + f3, f - f4);
        generalPath.lineTo(f + f2, f);
        generalPath.lineTo(f + f3, f + f4);
        generalPath.lineTo(f + f4, f + f3);
        generalPath.lineTo(f, f + f2);
        generalPath.lineTo(f - f4, f + f3);
        generalPath.lineTo(f - f3, f + f4);
        generalPath.lineTo(f - f2, f);
        graphics2D.fill(generalPath);
        graphics2D.translate(f, f);
        graphics2D.rotate(0.7853981633974483);
        graphics2D.scale(0.7, 0.7);
        graphics2D.translate(-f, -f);
        graphics2D.fill(generalPath);
        return bufferedImage;
    }

    public static BufferedImage createRaysImage(int n, int n2, Color color) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(color);
        float f = (float)n / 2.0f;
        float f2 = f * 0.9f;
        float f3 = f * 0.1f;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f);
        generalPath.lineTo(f - f3, f - f2);
        generalPath.lineTo(f + f3, f - f2);
        generalPath.lineTo(f, f);
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        GradientPaint gradientPaint = new GradientPaint(f, f, color, f, f - f2, color2);
        graphics2D.setPaint(gradientPaint);
        for (int i = 0; i < n2; ++i) {
            graphics2D.translate(f, f);
            graphics2D.rotate(Math.PI * 2 / (double)n2);
            graphics2D.translate(-f, -f);
            graphics2D.fill(generalPath);
        }
        return bufferedImage;
    }

    public static BufferedImage createHaloImage(int n, Color color) {
        return LensFlareLayer.createHaloImage(n, color, 0.2f);
    }

    public static BufferedImage createHaloImage(int n, Color color, float f) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setStroke(new BasicStroke(1.5f));
        float[] fArray = new float[4];
        color.getRGBComponents(fArray);
        float f2 = (float)n / 2.0f;
        float f3 = 0.0f;
        float f4 = f2 * 0.9f;
        for (float f5 = f3; f5 <= f4; f5 += 1.0f) {
            float f6 = 1.0f - (float)Math.pow(f5 / f4, f);
            graphics2D.setColor(new Color(fArray[0], fArray[1], fArray[2], f6));
            graphics2D.drawOval((int)(f2 - f5), (int)(f2 - f5), (int)(f5 * 2.0f), (int)(f5 * 2.0f));
        }
        return bufferedImage;
    }

    public static BufferedImage createRainbowImage(int n) {
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        float f = (float)n / 2.0f;
        float f2 = f * 0.7f;
        float f3 = f * 0.9f;
        for (float f4 = f2; f4 <= f3; f4 += 1.0f) {
            float f5 = (f4 - f2) / (f3 - f2);
            graphics2D.setColor(new Color(Color.HSBtoRGB(f5, 1.0f, 1.0f)));
            graphics2D.drawOval((int)(f - f4), (int)(f - f4), (int)(f4 * 2.0f), (int)(f4 * 2.0f));
        }
        return bufferedImage;
    }

    public static class FlareImage
    extends ScreenAnnotation {
        private final BufferedImage image;
        private double scale = 1.0;
        private double position = 0.0;
        private double opacity = 0.5;

        public FlareImage(BufferedImage bufferedImage, double d, double d2, double d3) {
            super("", new Point(0, 0));
            this.image = bufferedImage;
            this.scale = d;
            this.position = d2;
            this.opacity = d3;
            this.initialize();
        }

        private void initialize() {
            AnnotationAttributes annotationAttributes = this.getAttributes();
            annotationAttributes.setBorderWidth(0.0);
            annotationAttributes.setImageSource(this.image);
            annotationAttributes.setAdjustWidthToText("render.Annotation.SizeFixed");
            annotationAttributes.setSize(new Dimension(this.image.getWidth(), this.image.getHeight()));
            annotationAttributes.setBackgroundColor(new Color(0, 0, 0, 0));
            annotationAttributes.setCornerRadius(0);
            annotationAttributes.setInsets(new Insets(0, 0, 0, 0));
            annotationAttributes.setDrawOffset(new Point(0, -this.image.getHeight() / 2));
        }

        public void update(Point point, Point point2) {
            double d = (double)point.x - (double)(point.x - point2.x) * this.position;
            double d2 = (double)point.y - (double)(point.y - point2.y) * this.position;
            this.setScreenPoint(new Point((int)d, (int)d2));
            this.getAttributes().setScale(this.scale);
            this.getAttributes().setOpacity(this.opacity);
        }
    }
}

