/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.sunlight;

import gov.nasa.worldwind.geom.LatLon;
import java.util.Calendar;

public class SunCalculator {
    public static LatLon subsolarPoint(Calendar calendar) {
        double d = (double)calendar.get(11) + ((double)calendar.get(12) + (double)calendar.get(13) / 60.0) / 60.0;
        long l = (calendar.get(2) - 14) / 12;
        long l2 = 1461L * ((long)(calendar.get(1) + 4800) + l) / 4L + 367L * ((long)(calendar.get(2) - 2) - 12L * l) / 12L - 3L * (((long)(calendar.get(1) + 4900) + l) / 100L) / 4L + (long)calendar.get(5) - 32075L;
        double d2 = (double)l2 - 0.5 + d / 24.0;
        double d3 = d2 - 2451545.0;
        double d4 = 2.1429 - 0.0010394594 * d3;
        double d5 = 4.895063 + 0.017202791698 * d3;
        d2 = 6.24006 + 0.0172019699 * d3;
        double d6 = d5 + 0.03341607 * Math.sin(d2) + 3.4894E-4 * Math.sin(2.0 * d2) - 1.134E-4 - 2.03E-5 * Math.sin(d4);
        double d7 = 0.4090928 - 6.214E-9 * d3 + 3.96E-5 * Math.cos(d4);
        d4 = Math.sin(d6);
        d5 = Math.cos(d7) * d4;
        double d8 = Math.atan2(d5, d2 = Math.cos(d6));
        if (d8 < 0.0) {
            d8 += Math.PI * 2;
        }
        double d9 = Math.asin(Math.sin(d7) * d4);
        d4 = 6.6974243242 + 0.0657098283 * d3 + d;
        d5 = d8 - Math.toRadians(d4 * 15.0);
        d5 += Math.PI;
        while (d9 > 1.5707963267948966) {
            d9 -= Math.PI;
        }
        while (d9 <= -1.5707963267948966) {
            d9 += Math.PI;
        }
        while (d5 > Math.PI) {
            d5 -= Math.PI * 2;
        }
        while (d5 <= -Math.PI) {
            d5 += Math.PI * 2;
        }
        return LatLon.fromRadians(d9, d5);
    }
}

