/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.sunlight;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.examples.ApplicationTemplate;
import gov.nasa.worldwind.examples.sunlight.AtmosphereLayer;
import gov.nasa.worldwind.examples.sunlight.BasicSunPositionProvider;
import gov.nasa.worldwind.examples.sunlight.LensFlareLayer;
import gov.nasa.worldwind.examples.sunlight.RectangularNormalTessellator;
import gov.nasa.worldwind.examples.sunlight.SunPositionProvider;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Earth.USGSTopographicMaps;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.SkyGradientLayer;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SunShading
extends ApplicationTemplate {
    public static void main(String[] stringArray) {
        Configuration.setValue("gov.nasa.worldwind.avkey.TessellatorClassName", RectangularNormalTessellator.class.getName());
        ApplicationTemplate.start("World Wind Sun Shading", AppFrame.class);
    }

    public static class AppFrame
    extends ApplicationTemplate.AppFrame {
        private JCheckBox enableCheckBox;
        private JButton colorButton;
        private JButton ambientButton;
        private JRadioButton relativeRadioButton;
        private JRadioButton absoluteRadioButton;
        private JSlider azimuthSlider;
        private JSlider elevationSlider;
        private RectangularNormalTessellator tessellator;
        private LensFlareLayer lensFlareLayer;
        private AtmosphereLayer atmosphereLayer;
        private SunPositionProvider spp = new BasicSunPositionProvider();

        public AppFrame() {
            super(true, true, false);
            ApplicationTemplate.insertBeforePlacenames(this.getWwd(), new USGSTopographicMaps());
            this.atmosphereLayer = new AtmosphereLayer();
            for (int i = 0; i < this.getWwd().getModel().getLayers().size(); ++i) {
                Layer layer = (Layer)this.getWwd().getModel().getLayers().get(i);
                if (!(layer instanceof SkyGradientLayer)) continue;
                this.getWwd().getModel().getLayers().set(i, this.atmosphereLayer);
            }
            this.lensFlareLayer = LensFlareLayer.getPresetInstance("LensFlare.PresetBold");
            this.getWwd().getModel().getLayers().add(this.lensFlareLayer);
            this.getLayerPanel().update(this.getWwd());
            this.tessellator = (RectangularNormalTessellator)this.getWwd().getModel().getGlobe().getTessellator();
            this.getLayerPanel().add((Component)this.makeControlPanel(), "South");
            this.getWwd().addPositionListener(new PositionListener(){
                Vec4 eyePoint;

                public void moved(PositionEvent positionEvent) {
                    if (this.eyePoint == null || this.eyePoint.distanceTo3(AppFrame.this.getWwd().getView().getEyePoint()) > 1000.0) {
                        AppFrame.this.update();
                        this.eyePoint = AppFrame.this.getWwd().getView().getEyePoint();
                    }
                }
            });
            Timer timer = new Timer(60000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.update();
                }
            });
            timer.start();
            this.update();
        }

        private JPanel makeControlPanel() {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(9, 9, 9, 9), new TitledBorder("Sun Light")));
            jPanel.setToolTipText("Set the Sun light direction and color");
            final JPanel jPanel2 = new JPanel(new GridLayout(0, 3, 0, 0));
            jPanel2.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.enableCheckBox = new JCheckBox("Enable");
            this.enableCheckBox.setSelected(true);
            this.enableCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.update();
                }
            });
            jPanel2.add(this.enableCheckBox);
            this.colorButton = new JButton("Light");
            this.colorButton.setBackground(this.tessellator.getLightColor());
            this.colorButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(jPanel2, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                    if (color != null) {
                        ((JButton)actionEvent.getSource()).setBackground(color);
                        AppFrame.this.update();
                    }
                }
            });
            jPanel2.add(this.colorButton);
            this.ambientButton = new JButton("Shade");
            this.ambientButton.setBackground(this.tessellator.getAmbientColor());
            this.ambientButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Color color = JColorChooser.showDialog(jPanel2, "Choose a color...", ((JButton)actionEvent.getSource()).getBackground());
                    if (color != null) {
                        ((JButton)actionEvent.getSource()).setBackground(color);
                        AppFrame.this.update();
                    }
                }
            });
            jPanel2.add(this.ambientButton);
            JPanel jPanel3 = new JPanel(new GridLayout(0, 2, 0, 0));
            jPanel3.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.relativeRadioButton = new JRadioButton("Relative");
            this.relativeRadioButton.setSelected(false);
            this.relativeRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.update();
                }
            });
            jPanel3.add(this.relativeRadioButton);
            this.absoluteRadioButton = new JRadioButton("Absolute");
            this.absoluteRadioButton.setSelected(true);
            this.absoluteRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    AppFrame.this.update();
                }
            });
            jPanel3.add(this.absoluteRadioButton);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.relativeRadioButton);
            buttonGroup.add(this.absoluteRadioButton);
            JPanel jPanel4 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel4.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel4.add(new JLabel("Azimuth:"));
            this.azimuthSlider = new JSlider(0, 360, 125);
            this.azimuthSlider.setPaintTicks(true);
            this.azimuthSlider.setPaintLabels(true);
            this.azimuthSlider.setMajorTickSpacing(90);
            this.azimuthSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.update();
                }
            });
            jPanel4.add(this.azimuthSlider);
            JPanel jPanel5 = new JPanel(new GridLayout(0, 1, 0, 0));
            jPanel5.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            jPanel5.add(new JLabel("Elevation:"));
            this.elevationSlider = new JSlider(-10, 90, 50);
            this.elevationSlider.setPaintTicks(true);
            this.elevationSlider.setPaintLabels(true);
            this.elevationSlider.setMajorTickSpacing(10);
            this.elevationSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    AppFrame.this.update();
                }
            });
            jPanel5.add(this.elevationSlider);
            jPanel.add(jPanel2);
            jPanel.add(jPanel3);
            jPanel.add(jPanel4);
            jPanel.add(jPanel5);
            return jPanel;
        }

        private void update() {
            if (this.enableCheckBox.isSelected()) {
                Vec4 vec4;
                this.colorButton.setEnabled(true);
                this.ambientButton.setEnabled(true);
                this.absoluteRadioButton.setEnabled(true);
                this.relativeRadioButton.setEnabled(true);
                this.azimuthSlider.setEnabled(true);
                this.elevationSlider.setEnabled(true);
                this.tessellator.setLightColor(this.colorButton.getBackground());
                this.tessellator.setAmbientColor(this.ambientButton.getBackground());
                if (this.relativeRadioButton.isSelected()) {
                    this.azimuthSlider.setEnabled(true);
                    this.elevationSlider.setEnabled(true);
                    Angle angle = Angle.fromDegrees(this.elevationSlider.getValue());
                    Angle angle2 = Angle.fromDegrees(this.azimuthSlider.getValue());
                    Position position = this.getWwd().getView().getEyePosition();
                    vec4 = Vec4.UNIT_Y;
                    vec4 = vec4.transformBy3(Matrix.fromRotationX(angle));
                    vec4 = vec4.transformBy3(Matrix.fromRotationZ(angle2.multiply(-1.0)));
                    vec4 = vec4.transformBy3(this.getWwd().getModel().getGlobe().computeTransformToPosition(position.getLatitude(), position.getLongitude(), 0.0));
                } else {
                    this.azimuthSlider.setEnabled(false);
                    this.elevationSlider.setEnabled(false);
                    LatLon latLon = this.spp.getPosition();
                    vec4 = this.getWwd().getModel().getGlobe().computePointFromPosition(new Position(latLon, 0.0)).normalize3();
                }
                Vec4 vec42 = vec4.getNegative3();
                this.tessellator.setLightDirection(vec42);
                this.lensFlareLayer.setSunDirection(vec4);
                this.atmosphereLayer.setSunDirection(vec4);
            } else {
                this.colorButton.setEnabled(false);
                this.ambientButton.setEnabled(false);
                this.absoluteRadioButton.setEnabled(false);
                this.relativeRadioButton.setEnabled(false);
                this.azimuthSlider.setEnabled(false);
                this.elevationSlider.setEnabled(false);
                this.tessellator.setLightDirection(null);
                this.lensFlareLayer.setSunDirection(null);
                this.atmosphereLayer.setSunDirection(null);
            }
            this.getWwd().redraw();
        }
    }
}

