/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import gov.nasa.worldwind.data.BasicDataIODescriptor;
import gov.nasa.worldwind.data.ImageIOReader;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;

public class ImageIOFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    private ImageIOReader reader;
    private String description;

    public ImageIOFileFilter(ImageIOReader imageIOReader) {
        if (imageIOReader == null) {
            String string = Logging.getMessage("nullValue.ReaderIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.reader = imageIOReader;
        this.description = ImageIOFileFilter.makeDescription(imageIOReader);
    }

    public boolean accept(File file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        return this.reader.canRead(file);
    }

    public String getDescription() {
        return this.description;
    }

    protected static String makeDescription(ImageIOReader imageIOReader) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Raster Imagery (");
        stringBuilder.append(BasicDataIODescriptor.createCombinedDescription(Arrays.asList(imageIOReader)));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

