/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import java.awt.AlphaComposite;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class ImageViewer
extends JComponent {
    public static final String SCALE_FIXED = "ImageViewer.ScaleFixed";
    public static final String SCALE_BEST_FIT = "ImageViewer.ScaleBestFit";
    public static final String SCALE_SHRINK_ONLY = "ImageViewer.ScaleShrinkOnly";
    private URL imageURL;
    private BufferedImage image;
    private String scaleMode = "ImageViewer.ScaleShrinkOnly";
    private float scale = 1.0f;
    private Point offset = new Point(0, 0);
    private boolean enableMousePanAndZoom = true;
    private float zoomMultiplier = 1.05f;
    private Point mousePressed;
    private BufferedImage displayImage;
    private BufferedImage previousImage;
    private boolean fading = false;
    private int fadeTimeMillisec = 500;
    private long fadeStartTime;

    public ImageViewer() {
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ImageViewer.this.mousePressed = mouseEvent.getPoint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ImageViewer.this.mousePressed = null;
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ImageViewer.this.image != null && ImageViewer.this.enableMousePanAndZoom && ImageViewer.this.mousePressed != null) {
                    ((ImageViewer)ImageViewer.this).offset.x += mouseEvent.getPoint().x - ((ImageViewer)ImageViewer.this).mousePressed.x;
                    ((ImageViewer)ImageViewer.this).offset.y += mouseEvent.getPoint().y - ((ImageViewer)ImageViewer.this).mousePressed.y;
                    ImageViewer.this.mousePressed = mouseEvent.getPoint();
                    ImageViewer.this.clearCachedValues();
                    ImageViewer.this.repaint();
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (ImageViewer.this.image != null && ImageViewer.this.enableMousePanAndZoom) {
                    float f = ImageViewer.this.scale;
                    int n = mouseWheelEvent.getUnitsToScroll();
                    for (int i = 1; i <= Math.abs(n); ++i) {
                        ImageViewer.this.scale = n < 0 ? ImageViewer.this.scale * ImageViewer.this.zoomMultiplier : ImageViewer.this.scale / ImageViewer.this.zoomMultiplier;
                    }
                    ImageViewer.this.updateOffsetForZoom(mouseWheelEvent.getPoint(), f, ImageViewer.this.scale);
                    ImageViewer.this.clearCachedValues();
                    ImageViewer.this.updateCursor();
                    ImageViewer.this.repaint();
                }
            }
        });
    }

    public URL getImageURL() {
        return this.imageURL;
    }

    public boolean setImageURL(URL uRL) {
        if (uRL == null) {
            this.imageURL = null;
            this.image = null;
        } else {
            BufferedImage bufferedImage = this.loadImage(uRL);
            if (bufferedImage != null) {
                this.imageURL = uRL;
                this.image = bufferedImage;
                this.startFading();
                this.resetPanAndZoom();
            } else {
                return false;
            }
        }
        this.repaint();
        return true;
    }

    private BufferedImage loadImage(URL uRL) {
        try {
            return ImageIO.read(uRL);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String getScaleMode() {
        return this.scaleMode;
    }

    public void setScaleMode(String string) {
        this.scaleMode = string;
        this.clearCachedValues();
        this.repaint();
    }

    public float getScale() {
        return this.scale;
    }

    public void setScale(float f) {
        this.scale = f;
        this.clearCachedValues();
        this.repaint();
    }

    public Point getOffset() {
        return this.offset;
    }

    public void setOffset(Point point) {
        this.offset = point;
        this.clearCachedValues();
        this.repaint();
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.imageURL = null;
        this.image = bufferedImage;
        this.startFading();
        this.resetPanAndZoom();
    }

    public boolean isEnableMousePanAndZoom() {
        return this.enableMousePanAndZoom;
    }

    public void setEnableMousePanAndZoom(boolean bl) {
        this.enableMousePanAndZoom = bl;
    }

    public void resetPanAndZoom() {
        this.scale = 1.0f;
        this.offset.move(0, 0);
        this.clearCachedValues();
        this.repaint();
    }

    public float getZoomMultiplier() {
        return this.zoomMultiplier;
    }

    public void setZoomMultiplier(float f) {
        this.zoomMultiplier = f;
    }

    public boolean isFading() {
        return this.fading;
    }

    public int getFadeTimeMillisec() {
        return this.fadeTimeMillisec;
    }

    public void setFadeTimeMillisec(int n) {
        this.fadeTimeMillisec = n;
    }

    private void clearCachedValues() {
        this.displayImage = null;
    }

    private void startFading() {
        if (this.displayImage != null) {
            this.fading = true;
            this.previousImage = this.displayImage;
            this.fadeStartTime = System.currentTimeMillis();
        }
    }

    private void stopFading() {
        this.fading = false;
        this.previousImage = null;
    }

    public void paintComponent(Graphics graphics) {
        if (this.image == null) {
            return;
        }
        if (this.displayImage == null || this.displayImage.getWidth() != this.getWidth() || this.displayImage.getHeight() != this.getHeight()) {
            this.displayImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
            this.paintImage((Graphics2D)this.displayImage.getGraphics());
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.fading) {
            long l = System.currentTimeMillis() - this.fadeStartTime;
            if (l < (long)this.fadeTimeMillisec) {
                graphics2D.drawImage((Image)this.previousImage, 0, 0, null);
                float f = (float)l / (float)this.fadeTimeMillisec;
                graphics2D.setComposite(AlphaComposite.getInstance(3, f));
            } else {
                this.stopFading();
            }
        }
        graphics2D.drawImage((Image)this.displayImage, 0, 0, null);
        if (this.fading) {
            this.repaint();
        }
    }

    protected void paintImage(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        this.clampOffset();
        float f = this.computeBestFitScale() * this.getScale();
        Point point = this.computeCenteringOffset(f);
        point.translate(this.offset.x, this.offset.y);
        Rectangle rectangle = this.computeSubImageRectangle(f, point);
        graphics2D.getTransform().setToIdentity();
        graphics2D.transform(AffineTransform.getTranslateInstance(Math.max(0, point.x), Math.max(0, point.y)));
        graphics2D.transform(AffineTransform.getScaleInstance(f, f));
        graphics2D.drawImage((Image)this.image.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height), 0, 0, null);
    }

    protected float computeBestFitScale() {
        float f;
        float f2;
        if (SCALE_FIXED.equals(this.scaleMode)) {
            return 1.0f;
        }
        float f3 = (float)this.getWidth() / (float)this.image.getWidth();
        float f4 = f2 = f3 < (f = (float)this.getHeight() / (float)this.image.getHeight()) ? f3 : f;
        if (SCALE_SHRINK_ONLY.equals(this.scaleMode)) {
            f2 = Math.min(1.0f, f2);
        }
        return f2;
    }

    protected Point computeCenteringOffset(float f) {
        float f2 = ((float)this.getWidth() - (float)this.image.getWidth() * f) / 2.0f;
        float f3 = ((float)this.getHeight() - (float)this.image.getHeight() * f) / 2.0f;
        return new Point((int)f2, (int)f3);
    }

    protected void clampOffset() {
        float f = this.computeBestFitScale() * this.scale;
        float f2 = (float)this.image.getWidth() * f;
        float f3 = (float)this.image.getHeight() * f;
        Point point = this.computeCenteringOffset(f);
        if (f2 < (float)this.getWidth()) {
            this.offset.x = 0;
        } else if (this.offset.x + point.x > 0) {
            this.offset.x = -point.x;
        } else if ((float)(this.offset.x + point.x) < (float)this.getWidth() - f2) {
            this.offset.x = this.getWidth() - (int)f2 - point.x;
        }
        if (f3 < (float)this.getHeight()) {
            this.offset.y = 0;
        } else if (this.offset.y + point.y > 0) {
            this.offset.y = -point.y;
        } else if ((float)(this.offset.y + point.y) < (float)this.getHeight() - f3) {
            this.offset.y = this.getHeight() - (int)f3 - point.y;
        }
    }

    protected void updateOffsetForZoom(Point point, float f, float f2) {
        float f3 = this.computeBestFitScale();
        float f4 = f3 * f;
        float f5 = f3 * f2;
        Point point2 = this.computeCenteringOffset(f4);
        point2.translate(this.offset.x, this.offset.y);
        Point point3 = this.computeCenteringOffset(f5);
        point3.translate(this.offset.x, this.offset.y);
        float f6 = (float)this.image.getWidth() / 2.0f;
        float f7 = (float)this.image.getHeight() / 2.0f;
        Point point4 = new Point(point2.x + (int)(f6 * f4), point2.y + (int)(f7 * f4));
        Point point5 = new Point(point.x - point4.x, point.y - point4.y);
        Point point6 = new Point((int)((float)point5.x / f4 * f5), (int)((float)point5.y / f4 * f5));
        this.offset.translate(point5.x - point6.x, point5.y - point6.y);
    }

    protected void updateCursor() {
        float f = this.computeBestFitScale() * this.scale;
        float f2 = (float)this.image.getWidth() * f;
        float f3 = (float)this.image.getHeight() * f;
        if (!this.enableMousePanAndZoom || f2 <= (float)this.getWidth() && f3 <= (float)this.getHeight()) {
            this.setCursor(Cursor.getDefaultCursor());
        } else {
            this.setCursor(Cursor.getPredefinedCursor(13));
        }
    }

    private Rectangle computeSubImageRectangle(float f, Point point) {
        int n = Math.max(0, (int)((float)(-point.x) / f));
        int n2 = Math.max(0, (int)((float)(-point.y) / f));
        int n3 = Math.min(this.image.getWidth(), (int)((float)this.getWidth() / f) + 1);
        int n4 = Math.min(this.image.getHeight(), (int)((float)this.getHeight() / f) + 1);
        return new Rectangle(n, n2, n3, n4);
    }
}

