/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import gov.nasa.worldwind.examples.util.ImageViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.TransferHandler;

public class ImageViewerDialog
extends JFrame {
    private static final String TITLE_TEXT = "Image Viewer";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 250;
    private final ImageViewerPanel panel;
    private boolean dropEnabled = false;

    public ImageViewerDialog() {
        this.setTitle(TITLE_TEXT);
        this.setLayout(new BorderLayout());
        this.panel = new ImageViewerPanel();
        this.add((Component)this.panel, "Center");
        this.setSize(300, 250);
        this.setupDropSupport();
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.panel.repaint();
    }

    public ImageViewer getImageViewer() {
        return this.panel.imageViewer;
    }

    public String getCaption() {
        return this.panel.caption.getText();
    }

    public void setCaption(String string) {
        if (string != null && string.length() > 0) {
            this.panel.caption.setText(string);
            this.panel.caption.setVisible(true);
        } else {
            this.panel.caption.setText("");
            this.panel.caption.setVisible(false);
        }
    }

    public JLabel getCaptionLabel() {
        return this.panel.caption;
    }

    public boolean isDropEnabled() {
        return this.dropEnabled;
    }

    public void setDropEnabled(boolean bl) {
        this.dropEnabled = bl;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        this.panel.setTransferHandler(transferHandler);
    }

    protected void setupDropSupport() {
        this.setTransferHandler(new TransferHandler(){

            public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
                if (!ImageViewerDialog.this.dropEnabled) {
                    return false;
                }
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    if (!dataFlavor.equals(DataFlavor.javaFileListFlavor)) continue;
                    return true;
                }
                return false;
            }

            public boolean importData(JComponent jComponent, Transferable transferable) {
                List list;
                try {
                    list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                }
                catch (Exception exception) {
                    return false;
                }
                for (Object e : list) {
                    File file = (File)e;
                    try {
                        if (!ImageViewerDialog.this.getImageViewer().setImageURL(file.toURL())) continue;
                        return true;
                    }
                    catch (Exception exception) {
                    }
                }
                return false;
            }
        });
    }

    public class ImageViewerPanel
    extends JPanel {
        private ImageViewer imageViewer;
        private JLabel caption;

        public ImageViewerPanel() {
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 3));
            this.imageViewer = new ImageViewer();
            this.add(this.imageViewer);
            this.caption = new JLabel("");
            this.caption.setAlignmentX(0.5f);
            this.caption.setVisible(false);
            this.add(this.caption);
        }
    }
}

