/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.layers.LayerList;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.MultiLineTextRenderer;
import gov.nasa.worldwind.render.ScreenAnnotation;
import gov.nasa.worldwind.render.TextRendererCache;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public class LayerManagerLayer
extends RenderableLayer
implements SelectListener {
    protected WorldWindow wwd;
    protected TextRendererCache textRendererCache = new TextRendererCache();
    protected MultiLineTextRenderer mltr;
    protected boolean update = true;
    private ScreenAnnotation annotation;
    private int selectedIndex = -1;
    private Color color = Color.decode("#b0b0b0");
    private Color highlightColor = Color.decode("#ffffff");
    private double minOpacity = 0.6;
    private double maxOpacity = 1.0;
    private char layerEnabledSymbol = (char)9632;
    private char layerDisabledSymbol = (char)9633;
    private Font font = new Font("SansSerif", 0, 14);
    private boolean minimized = false;
    private int borderWidth = 20;
    private String position = "gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest";
    private Vec4 locationCenter = null;
    private Vec4 locationOffset = null;
    private boolean componentDragEnabled = true;
    private boolean layerDragEnabled = true;
    private boolean snapToCorners = true;
    protected boolean draggingComponent = false;
    protected boolean draggingLayer = false;
    protected Point dragRefCursorPoint;
    protected Point dragRefPoint;
    protected int dragRefIndex = -1;
    protected Color dragColor = Color.RED;

    public LayerManagerLayer(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.wwd = worldWindow;
        this.initialize();
    }

    protected void initialize() {
        this.annotation = new ScreenAnnotation("", new Point(0, 0));
        this.annotation.getAttributes().setCornerRadius(0);
        this.annotation.getAttributes().setAdjustWidthToText("render.Annotation.SizeFixed");
        this.annotation.getAttributes().setFont(this.font);
        this.annotation.getAttributes().setHighlightScale(1.0);
        this.addRenderable(this.annotation);
        this.mltr = new MultiLineTextRenderer(this.font);
        this.mltr.setLineSpacing(-2);
        this.wwd.addSelectListener(this);
    }

    public ScreenAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(ScreenAnnotation screenAnnotation) {
        if (screenAnnotation == null) {
            String string = Logging.getMessage("nullValue.AnnotationIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.annotation = screenAnnotation;
    }

    public void setEnabled(boolean bl) {
        this.setMinimized(!bl);
    }

    public boolean isEnabled() {
        return !this.isMinimized();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.font.equals(font)) {
            this.font = font;
            this.mltr = new MultiLineTextRenderer(font);
            this.annotation.getAttributes().setFont(font);
            this.update();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
        this.update();
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.highlightColor = color;
        this.update();
    }

    public double getMinOpacity() {
        return this.minOpacity;
    }

    public void setMinOpacity(double d) {
        this.minOpacity = d;
        this.update();
    }

    public double getMaxOpacity() {
        return this.maxOpacity;
    }

    public void setMaxOpacity(double d) {
        this.maxOpacity = d;
        this.update();
    }

    public char getLayerEnabledSymbol() {
        return this.layerEnabledSymbol;
    }

    public void setLayerEnabledSymbol(char c) {
        this.layerEnabledSymbol = c;
        this.update();
    }

    public char getLayerDisabledSymbol() {
        return this.layerDisabledSymbol;
    }

    public void setLayerDisabledSymbol(char c) {
        this.layerDisabledSymbol = c;
        this.update();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
        this.update();
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ScreenPositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = string;
        this.update();
    }

    public Vec4 getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Vec4 vec4) {
        this.locationCenter = vec4;
        this.update();
    }

    public Vec4 getLocationOffset() {
        return this.locationOffset;
    }

    public void setLocationOffset(Vec4 vec4) {
        this.locationOffset = vec4;
        this.update();
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean bl) {
        this.minimized = bl;
        this.update();
    }

    public boolean isComponentDragEnabled() {
        return this.componentDragEnabled;
    }

    public void setComponentDragEnabled(boolean bl) {
        this.componentDragEnabled = bl;
    }

    public boolean isLayerDragEnabled() {
        return this.layerDragEnabled;
    }

    public void setLayerDragEnabled(boolean bl) {
        this.layerDragEnabled = bl;
    }

    public boolean isSnapToCorners() {
        return this.snapToCorners;
    }

    public void setSnapToCorners(boolean bl) {
        this.snapToCorners = bl;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int n) {
        this.selectedIndex = n;
        this.update();
    }

    public void selected(SelectEvent selectEvent) {
        if (selectEvent.hasObjects() && selectEvent.getTopObject() == this.annotation) {
            boolean bl = false;
            if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                PickedObject pickedObject;
                if (!this.annotation.getAttributes().isHighlighted()) {
                    this.annotation.getAttributes().setHighlighted(true);
                    bl = true;
                }
                if ((pickedObject = selectEvent.getTopPickedObject()).getValue("gov.nasa.worldwind.avkey.URL") != null) {
                    ((Component)((Object)this.wwd)).setCursor(Cursor.getPredefinedCursor(12));
                    int n = Integer.parseInt((String)pickedObject.getValue("gov.nasa.worldwind.avkey.URL"));
                    if (this.selectedIndex != n) {
                        this.selectedIndex = n;
                        bl = true;
                    }
                    if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.LeftClick")) {
                        LayerList layerList = this.wwd.getModel().getLayers();
                        if (n >= 0 && n < layerList.size()) {
                            ((Layer)layerList.get(n)).setEnabled(!((Layer)layerList.get(n)).isEnabled());
                            bl = true;
                        }
                    }
                } else {
                    if (this.selectedIndex != -1) {
                        this.selectedIndex = -1;
                        bl = true;
                    }
                    if (this.isComponentDragEnabled()) {
                        ((Component)((Object)this.wwd)).setCursor(Cursor.getPredefinedCursor(13));
                    } else {
                        ((Component)((Object)this.wwd)).setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
            if ((selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag") || selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) && (this.isComponentDragEnabled() || this.isLayerDragEnabled())) {
                boolean bl2 = this.draggingLayer;
                this.drag(selectEvent);
                if (this.draggingLayer || bl2) {
                    bl = true;
                } else {
                    this.wwd.redraw();
                }
            }
            if (bl) {
                this.update();
            }
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover") && this.annotation.getAttributes().isHighlighted()) {
            this.annotation.getAttributes().setHighlighted(false);
            ((Component)((Object)this.wwd)).setCursor(Cursor.getDefaultCursor());
            this.update();
        }
    }

    protected void drag(SelectEvent selectEvent) {
        if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Drag")) {
            if (this.isComponentDragEnabled() && this.selectedIndex == -1 && this.dragRefIndex == -1 || this.draggingComponent) {
                if (!this.draggingComponent) {
                    this.dragRefCursorPoint = selectEvent.getMouseEvent().getPoint();
                    this.dragRefPoint = this.annotation.getScreenPoint();
                    this.draggingComponent = true;
                }
                Point point = new Point(selectEvent.getMouseEvent().getPoint().x - this.dragRefCursorPoint.x, selectEvent.getMouseEvent().getPoint().y - this.dragRefCursorPoint.y);
                Point point2 = new Point(this.dragRefPoint.x + point.x, this.dragRefPoint.y - point.y);
                this.moveTo(point2);
            } else if (this.isLayerDragEnabled()) {
                if (!this.draggingLayer) {
                    this.dragRefIndex = this.selectedIndex;
                    this.draggingLayer = true;
                }
                if (this.selectedIndex != -1 && this.dragRefIndex != -1 && this.dragRefIndex != this.selectedIndex) {
                    LayerList layerList = this.wwd.getModel().getLayers();
                    int n = this.dragRefIndex > this.selectedIndex ? this.selectedIndex : this.selectedIndex + 1;
                    int n2 = this.dragRefIndex > this.selectedIndex ? this.dragRefIndex + 1 : this.dragRefIndex;
                    layerList.add(n, (Layer)layerList.get(this.dragRefIndex));
                    layerList.remove(n2);
                    this.dragRefIndex = this.selectedIndex;
                }
            }
        } else if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.DragEnd")) {
            this.draggingComponent = false;
            this.draggingLayer = false;
            this.dragRefIndex = -1;
        }
    }

    protected void moveTo(Point point) {
        Point point2 = this.annotation.getScreenPoint();
        if (this.locationOffset == null) {
            this.locationOffset = Vec4.ZERO;
        }
        int n = (int)this.locationOffset.x - (point2.x - point.x);
        int n2 = (int)this.locationOffset.y - (point2.y - point.y);
        this.locationOffset = new Vec4(n, n2, 0.0);
        Point point3 = this.computeLocation(this.wwd.getView().getViewport());
        this.locationOffset = new Vec4(n += point.x - point3.x, n2 += point.y - point3.y, 0.0);
        if (this.snapToCorners) {
            this.snapToCorners();
        }
    }

    protected void snapToCorners() {
        int n = (int)this.annotation.getAttributes().getSize().getWidth();
        int n2 = (int)this.annotation.getAttributes().getSize().getHeight();
        Rectangle rectangle = this.wwd.getView().getViewport();
        Point point = this.computeLocation(rectangle);
        Point point2 = new Point(point.x + n / 2, point.y + n2 / 2);
        String string = point2.x > rectangle.width / 2 ? (point2.y > rectangle.height / 2 ? "gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast" : "gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast") : (point2.y > rectangle.height / 2 ? "gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest" : "gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest");
        int n3 = 0;
        int n4 = 0;
        if (string.equals(this.getPosition())) {
            n3 = (int)this.locationOffset.x;
            n4 = (int)this.locationOffset.y;
        } else {
            if (string.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast")) {
                n3 = point.x - (rectangle.width - n - this.borderWidth);
                n4 = point.y - (rectangle.height - n2 - this.borderWidth);
            } else if (string.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast")) {
                n3 = point.x - (rectangle.width - n - this.borderWidth);
                n4 = point.y - this.borderWidth;
            }
            if (string.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest")) {
                n3 = point.x - this.borderWidth;
                n4 = point.y - (rectangle.height - n2 - this.borderWidth);
            } else if (string.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest")) {
                n3 = point.x - this.borderWidth;
                n4 = point.y - this.borderWidth;
            }
        }
        n3 = Math.abs(n3) < 16 ? 0 : n3;
        n4 = Math.abs(n4) < 16 ? 0 : n4;
        this.position = string;
        this.locationOffset = new Vec4(n3, n4, 0.0);
    }

    public void update() {
        this.update = true;
        this.wwd.redraw();
    }

    public void updateNow() {
        this.highlight(this.annotation.getAttributes().isHighlighted());
        String string = this.makeAnnotationText(this.wwd.getModel().getLayers());
        this.annotation.setText(string);
        String string2 = MultiLineTextRenderer.processLineBreaksHTML(string);
        Rectangle2D rectangle2D = this.mltr.getBoundsHTML(string2, this.textRendererCache);
        Insets insets = this.annotation.getAttributes().getInsets();
        int n = (int)rectangle2D.getWidth() + insets.left + insets.right + 6;
        int n2 = (int)rectangle2D.getHeight() + insets.top + insets.bottom + 2;
        this.annotation.getAttributes().setSize(new Dimension(n, n2));
        this.annotation.getAttributes().setDrawOffset(new Point(n / 2, 0));
        this.update = false;
    }

    protected void highlight(boolean bl) {
        if (bl) {
            this.annotation.getAttributes().setBorderColor(this.highlightColor);
            this.annotation.getAttributes().setOpacity(this.maxOpacity);
        } else {
            this.annotation.getAttributes().setBorderColor(this.color);
            this.annotation.getAttributes().setOpacity(this.minOpacity);
        }
    }

    protected String makeAnnotationText(LayerList layerList) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (Layer layer : layerList) {
            if (!this.isMinimized() || layer == this) {
                Color color = n == this.selectedIndex ? this.highlightColor : this.color;
                color = n == this.dragRefIndex ? this.dragColor : color;
                stringBuilder.append("<a href=\"");
                stringBuilder.append(n);
                stringBuilder.append("\"><font color=\"");
                stringBuilder.append(LayerManagerLayer.encodeHTMLColor(color));
                stringBuilder.append("\">");
                stringBuilder.append(layer.isEnabled() ? this.layerEnabledSymbol : this.layerDisabledSymbol);
                stringBuilder.append(" ");
                stringBuilder.append(layer.isEnabled() ? "<b>" : "<i>");
                stringBuilder.append(layer.getName());
                stringBuilder.append(layer.isEnabled() ? "</b>" : "</i>");
                stringBuilder.append("</a><br />");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    protected static String encodeHTMLColor(Color color) {
        return String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
    }

    public void render(DrawContext drawContext) {
        if (this.update) {
            this.updateNow();
        }
        this.annotation.setScreenPoint(this.computeLocation(drawContext.getView().getViewport()));
        super.render(drawContext);
    }

    protected Point computeLocation(Rectangle rectangle) {
        int n;
        int n2;
        int n3 = (int)this.annotation.getAttributes().getSize().getWidth();
        int n4 = (int)this.annotation.getAttributes().getSize().getHeight();
        if (this.locationCenter != null) {
            n2 = (int)this.locationCenter.x - n3 / 2;
            n = (int)this.locationCenter.y - n4 / 2;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast")) {
            n2 = (int)rectangle.getWidth() - n3 - this.borderWidth;
            n = (int)rectangle.getHeight() - n4 - this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast")) {
            n2 = (int)rectangle.getWidth() - n3 - this.borderWidth;
            n = this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest")) {
            n2 = this.borderWidth;
            n = (int)rectangle.getHeight() - n4 - this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest")) {
            n2 = this.borderWidth;
            n = this.borderWidth;
        } else {
            n2 = (int)rectangle.getWidth() - n3 - this.borderWidth;
            n = (int)rectangle.getHeight() - n4 - this.borderWidth;
        }
        if (this.locationOffset != null) {
            n2 = (int)((double)n2 + this.locationOffset.x);
            n = (int)((double)n + this.locationOffset.y);
        }
        return new Point(n2, n);
    }

    public String toString() {
        return Logging.getMessage("layers.LayerManagerLayer.Name");
    }
}

