/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class RayCastingSupport {
    private static double defaultSampleLength = 100.0;
    private static double defaultPrecision = 10.0;

    public static Position intersectRayWithTerrain(Globe globe, Vec4 vec4, Vec4 vec42) {
        return RayCastingSupport.intersectRayWithTerrain(globe, vec4, vec42, defaultSampleLength, defaultPrecision);
    }

    public static Position intersectRayWithTerrain(Globe globe, Vec4 vec4, Vec4 vec42, double d, double d2) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = null;
        Intersection[] intersectionArray = globe.intersect(new Line(vec4, vec42 = vec42.normalize3()), globe.getMaxElevation());
        if (intersectionArray != null) {
            Vec4 vec43;
            Vec4 vec44 = intersectionArray[0].getIntersectionPoint();
            Vec4 vec45 = null;
            if (vec44.subtract3(vec4).dot3(vec42) < 0.0) {
                vec44 = null;
            }
            if (intersectionArray.length == 2 && (vec45 = intersectionArray[1].getIntersectionPoint()).subtract3(vec4).dot3(vec42) < 0.0) {
                vec45 = null;
            }
            if (vec44 == null && vec45 == null) {
                return null;
            }
            if (vec44 != null && vec45 != null) {
                if (vec4.distanceTo3(vec44) > vec4.distanceTo3(vec45)) {
                    vec43 = vec45;
                    vec45 = vec44;
                    vec44 = vec43;
                }
            } else {
                vec45 = vec45 == null ? vec44 : vec45;
                vec44 = vec4;
            }
            if ((vec43 = RayCastingSupport.intersectSegmentWithTerrain(globe, vec44, vec45, d, d2)) != null) {
                position = globe.computePositionFromPoint(vec43);
            }
        }
        return position;
    }

    public static Vec4 intersectSegmentWithTerrain(Globe globe, Vec4 vec4, Vec4 vec42) {
        return RayCastingSupport.intersectSegmentWithTerrain(globe, vec4, vec42, defaultSampleLength, defaultPrecision);
    }

    public static Vec4 intersectSegmentWithTerrain(Globe globe, Vec4 vec4, Vec4 vec42, double d, double d2) {
        if (globe == null) {
            String string = Logging.getMessage("nullValue.GlobeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (vec4 == null || vec42 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (d2 < 0.0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", d2);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec43 = null;
        Line line = new Line(vec4, vec42.subtract3(vec4).normalize3());
        double d3 = vec4.distanceTo3(vec42);
        double d4 = 0.0;
        Vec4 vec44 = vec4;
        Vec4 vec45 = null;
        while (d4 <= d3) {
            Position position = globe.computePositionFromPoint(vec44);
            if (position.getElevation() <= globe.getElevation(position.getLatitude(), position.getLongitude())) {
                vec43 = vec44;
                break;
            }
            if (d4 >= d3) break;
            vec45 = vec44;
            d4 = Math.min(d4 + d, d3);
            vec44 = line.getPointAt(d4);
        }
        if (vec43 != null && d > d2 && vec45 != null) {
            vec43 = RayCastingSupport.intersectSegmentWithTerrain(globe, vec45, vec43, d / 10.0, d2);
        }
        return vec43;
    }
}

