/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.view.OrbitView;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeUtils {
    public static double getViewportScaleFactor(WorldWindow worldWindow) {
        return ((OrbitView)worldWindow.getView()).getZoom() / 8.0;
    }

    public static Position getNewShapePosition(WorldWindow worldWindow) {
        Line line = new Line(worldWindow.getView().getEyePoint(), worldWindow.getView().getForwardVector());
        Intersection[] intersectionArray = worldWindow.getSceneController().getTerrain().intersect(line);
        if (intersectionArray != null && intersectionArray.length != 0) {
            return worldWindow.getModel().getGlobe().computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
        }
        if (worldWindow.getView() instanceof OrbitView) {
            return ((OrbitView)worldWindow.getView()).getCenterPosition();
        }
        return Position.ZERO;
    }

    public static Angle getNewShapeHeading(WorldWindow worldWindow, boolean bl) {
        if (bl && worldWindow.getView() instanceof OrbitView) {
            return ((OrbitView)worldWindow.getView()).getHeading();
        }
        return Angle.ZERO;
    }

    public static List<LatLon> createSquareInViewport(WorldWindow worldWindow, Position position, Angle angle, double d) {
        Globe globe = worldWindow.getModel().getGlobe();
        Matrix matrix = Matrix.IDENTITY;
        matrix = matrix.multiply(globe.computeTransformToPosition(position));
        matrix = matrix.multiply(Matrix.fromRotationZ(angle.multiply(-1.0)));
        double d2 = d / 2.0;
        double d3 = d / 2.0;
        Vec4[] vec4Array = new Vec4[]{new Vec4(-d2, -d3, 0.0).transformBy4(matrix), new Vec4(d2, -d3, 0.0).transformBy4(matrix), new Vec4(d2, d3, 0.0).transformBy4(matrix), new Vec4(-d2, d3, 0.0).transformBy4(matrix)};
        LatLon[] latLonArray = new LatLon[vec4Array.length];
        for (int i = 0; i < latLonArray.length; ++i) {
            latLonArray[i] = new LatLon(globe.computePositionFromPoint(vec4Array[i]));
        }
        return Arrays.asList(latLonArray);
    }
}

