/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.examples.util;

import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.PositionEvent;
import gov.nasa.worldwind.event.PositionListener;
import gov.nasa.worldwind.event.RenderingEvent;
import gov.nasa.worldwind.event.RenderingListener;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.geom.coords.MGRSCoord;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.swing.Timer;

public class StatusLayer
extends AbstractLayer
implements PositionListener,
RenderingListener {
    public static final String UNIT_METRIC = "gov.nasa.worldwind.StatusLayer.Metric";
    public static final String UNIT_IMPERIAL = "gov.nasa.worldwind.StatusLayer.Imperial";
    private String iconFilePath_bg = "images/dot-clockwise-32.png";
    private Color color = Color.white;
    private Font defaultFont = Font.decode("Arial-BOLD-12");
    private TextRenderer textRenderer = null;
    protected WorldWindow eventSource;
    protected String latDisplay = "";
    protected String lonDisplay = "";
    protected String elevDisplay = "";
    protected String altDisplay = "";
    private String noNetwork = "";
    private String elevationUnit = "gov.nasa.worldwind.StatusLayer.Metric";
    private boolean showNetworkStatus = true;
    private AtomicBoolean isNetworkAvailable = new AtomicBoolean(true);
    private boolean activatedDownload = false;
    private int bgWidth;
    private int bgHeight;
    private double iconScale = 0.5;
    private int iconHeight = 16;
    private Texture iconTexture;
    private double rotated = 0.0;
    private Color backColor = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    protected int coordDecimalPlaces = 4;
    static int rotationIncrement = 60;
    private int verticalSpacing = 2;
    private OrderedIcon orderedImage = new OrderedIcon();
    private final float[] compArray = new float[4];
    protected Position previousPos;

    public StatusLayer() {
        this.setPickEnabled(false);
        Timer timer = new Timer(300, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!StatusLayer.this.showNetworkStatus) {
                    StatusLayer.this.activatedDownload = false;
                    StatusLayer.this.noNetwork = "";
                    return;
                }
                if (!StatusLayer.this.isNetworkAvailable.get()) {
                    StatusLayer.this.noNetwork = Logging.getMessage("term.NoNetwork");
                    return;
                }
                StatusLayer.this.noNetwork = "";
                if (StatusLayer.this.isNetworkAvailable.get() && WorldWind.getRetrievalService().hasActiveTasks()) {
                    StatusLayer.this.activatedDownload = true;
                    StatusLayer.this.bumpRotation();
                    if (StatusLayer.this.eventSource != null) {
                        StatusLayer.this.eventSource.redraw();
                    }
                } else {
                    if (StatusLayer.this.activatedDownload && StatusLayer.this.eventSource != null) {
                        StatusLayer.this.eventSource.redraw();
                    }
                    StatusLayer.this.activatedDownload = false;
                }
            }
        });
        timer.start();
        Timer timer2 = new Timer(10000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!StatusLayer.this.showNetworkStatus) {
                    return;
                }
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        StatusLayer.this.isNetworkAvailable.set(!WorldWind.getNetworkStatus().isNetworkUnavailable());
                    }
                });
                thread.start();
            }
        });
        timer2.start();
    }

    public void setElevationUnits(String string) {
        this.elevationUnit = string;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public void setDefaultFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.defaultFont = font;
    }

    public int getCoordSigDigits() {
        return this.coordDecimalPlaces;
    }

    public void setCoordDecimalPlaces(int n) {
        this.coordDecimalPlaces = n;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setBackColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.backColor = color;
    }

    protected WorldWindow getEventSource() {
        return this.eventSource;
    }

    private double getScaledBGWidth() {
        return (double)this.bgWidth * this.iconScale;
    }

    private double getScaledBGHeight() {
        return (double)this.bgHeight * this.iconScale;
    }

    public void doRender(DrawContext drawContext) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    public void doPick(DrawContext drawContext, Point point) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    public void setEventSource(WorldWindow worldWindow) {
        if (worldWindow == null) {
            String string = Logging.getMessage("nullValue.WorldWindow");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.eventSource != null) {
            this.eventSource.removePositionListener(this);
            this.eventSource.removeRenderingListener(this);
        }
        worldWindow.addPositionListener(this);
        worldWindow.addRenderingListener(this);
        this.eventSource = worldWindow;
    }

    public void moved(PositionEvent positionEvent) {
        this.handleCursorPositionChange(positionEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(293121);
            bl = true;
            gL.glDisable(3553);
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            gL.glDisable(2929);
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            String string = String.format("%s   %s   %s   %s", this.altDisplay, this.latDisplay, this.lonDisplay, this.elevDisplay);
            Dimension dimension = this.getTextRenderSize(string);
            if ((double)dimension.width < rectangle.getWidth()) {
                double d = dimension.width > dimension.height ? (double)dimension.width : (double)dimension.height;
                gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -0.6 * d, 0.6 * d);
                gL.glMatrixMode(5888);
                gL.glPushMatrix();
                bl2 = true;
                gL.glLoadIdentity();
                if (this.backColor != null) {
                    this.drawFilledRectangle(drawContext, new Vec4(0.0, 0.0, 0.0), new Dimension((int)rectangle.getWidth(), Math.max((int)dimension.getHeight(), this.iconHeight)), this.backColor);
                }
                this.drawLabel(string, new Vec4(1.0, this.verticalSpacing, 0.0), this.color);
                if (this.noNetwork.length() > 0) {
                    dimension = this.getTextRenderSize(this.noNetwork);
                    double d2 = rectangle.getWidth() - dimension.getWidth();
                    this.drawLabel(this.noNetwork, new Vec4(d2, this.verticalSpacing, 0.0), Color.RED);
                } else if (this.activatedDownload) {
                    if (this.iconTexture == null) {
                        this.initBGTexture();
                    }
                    double d3 = this.getScaledBGWidth();
                    double d4 = this.getScaledBGHeight();
                    if (this.iconTexture != null) {
                        gL.glTranslated(rectangle.getWidth() - d3, 0.0, 0.0);
                        gL.glTranslated(d3 / 2.0, d4 / 2.0, 0.0);
                        gL.glRotated(this.rotated, 0.0, 0.0, 1.0);
                        gL.glTranslated(-d3 / 2.0, -d4 / 2.0, 0.0);
                        if (this.iconTexture != null) {
                            gL.glEnable(3553);
                            this.iconTexture.bind();
                            gL.glColor4d(1.0, 1.0, 1.0, this.getOpacity());
                            gL.glEnable(3042);
                            gL.glBlendFunc(770, 771);
                            TextureCoords textureCoords = this.iconTexture.getImageTexCoords();
                            gL.glScaled(d3, d4, 1.0);
                            drawContext.drawUnitQuad(textureCoords);
                        }
                    }
                }
            }
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private void bumpRotation() {
        this.rotated = this.rotated > (double)rotationIncrement ? (this.rotated -= (double)rotationIncrement) : 360.0;
    }

    public void stageChanged(RenderingEvent renderingEvent) {
        if (!renderingEvent.getStage().equals("gov.nasa.worldwind.RenderingEvent.BeforeBufferSwap")) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                StatusLayer.this.altDisplay = StatusLayer.this.eventSource.getView() != null && StatusLayer.this.eventSource.getView().getEyePosition() != null ? StatusLayer.this.makeEyeAltitudeDescription(StatusLayer.this.eventSource.getView().getEyePosition().getElevation()) : Logging.getMessage("term.Altitude");
            }
        });
    }

    private Dimension getTextRenderSize(String string) {
        if (this.textRenderer == null) {
            this.textRenderer = new TextRenderer(this.defaultFont, true, true);
        }
        Rectangle2D rectangle2D = this.textRenderer.getBounds(string);
        return new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
    }

    private void drawLabel(String string, Vec4 vec4, Color color) {
        if (this.textRenderer == null) {
            this.textRenderer = new TextRenderer(this.defaultFont, true, true);
        }
        int n = (int)vec4.x();
        int n2 = (int)vec4.y();
        this.textRenderer.begin3DRendering();
        this.textRenderer.setColor(this.getBackgroundColor(color));
        this.textRenderer.draw(string, n + 1, n2 - 1);
        this.textRenderer.setColor(color);
        this.textRenderer.draw(string, n, n2);
        this.textRenderer.end3DRendering();
    }

    private Color getBackgroundColor(Color color) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.compArray);
        if ((double)this.compArray[2] > 0.5) {
            return new Color(0.0f, 0.0f, 0.0f, 0.7f);
        }
        return new Color(1.0f, 1.0f, 1.0f, 0.7f);
    }

    private void handleCursorPositionChange(PositionEvent positionEvent) {
        Position position = positionEvent.getPosition();
        if (position != null) {
            this.latDisplay = this.makeAngleDescription("Lat", position.getLatitude(), this.coordDecimalPlaces);
            this.lonDisplay = this.makeAngleDescription("Lon", position.getLongitude(), this.coordDecimalPlaces);
            this.elevDisplay = this.makeCursorElevationDescription(this.eventSource.getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude()));
            if (this.previousPos != null && this.previousPos.getLatitude().compareTo(position.getLatitude()) != 0 && this.previousPos.getLongitude().compareTo(position.getLongitude()) != 0) {
                this.eventSource.redraw();
            }
        } else {
            this.latDisplay = "";
            this.lonDisplay = Logging.getMessage("term.OffGlobe");
            this.elevDisplay = "";
        }
        this.previousPos = position;
    }

    private void initBGTexture() {
        try {
            File file;
            InputStream inputStream = this.getClass().getResourceAsStream("/" + this.iconFilePath_bg);
            if (inputStream == null && (file = new File(this.iconFilePath_bg)).exists()) {
                inputStream = new FileInputStream(file);
            }
            this.iconTexture = TextureIO.newTexture(inputStream, false, null);
            this.iconTexture.bind();
            this.bgWidth = this.iconTexture.getWidth();
            this.bgHeight = this.iconTexture.getHeight();
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("layers.IOExceptionDuringInitialization");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, iOException);
        }
    }

    private void drawFilledRectangle(DrawContext drawContext, Vec4 vec4, Dimension dimension, Color color) {
        GL gL = drawContext.getGL();
        gL.glColor4ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getAlpha());
        gL.glDisable(3553);
        gL.glBegin(9);
        gL.glVertex3d(vec4.x, vec4.y, 0.0);
        gL.glVertex3d(vec4.x + dimension.getWidth(), vec4.y, 0.0);
        gL.glVertex3d(vec4.x + dimension.getWidth(), vec4.y + dimension.getHeight(), 0.0);
        gL.glVertex3d(vec4.x, vec4.y + dimension.getHeight(), 0.0);
        gL.glVertex3d(vec4.x, vec4.y, 0.0);
        gL.glEnd();
    }

    protected String makeAngleDescription(String string, Angle angle, int n) {
        return String.format("%s %s", string, angle.toDecimalDegreesString(n));
    }

    protected String makeEyeAltitudeDescription(double d) {
        String string = Logging.getMessage("term.Altitude");
        if (UNIT_IMPERIAL.equals(this.elevationUnit)) {
            return String.format("%s %,d mi", string, (int)Math.round(WWMath.convertMetersToMiles(d)));
        }
        return String.format("%s %,d km", string, (int)Math.round(d / 1000.0));
    }

    protected String makeCursorElevationDescription(double d) {
        String string = Logging.getMessage("term.Elev");
        if (UNIT_IMPERIAL.equals(this.elevationUnit)) {
            return String.format("%s %,d feet", string, (int)Math.round(WWMath.convertMetersToFeet(d)));
        }
        return String.format("%s %,d meters", string, (int)Math.round(d));
    }

    public void dispose() {
        if (GLContext.getCurrent() != null && this.textRenderer != null) {
            this.textRenderer.dispose();
            this.textRenderer = null;
        }
    }

    public String toString() {
        return Logging.getMessage("layers.StatusLayer.Name");
    }

    public static class StatusMGRSLayer
    extends StatusLayer {
        public void moved(PositionEvent positionEvent) {
            this.handleCursorPositionChange(positionEvent);
        }

        private void handleCursorPositionChange(PositionEvent positionEvent) {
            Position position = positionEvent.getPosition();
            if (position != null) {
                String string;
                String string2 = this.makeAngleDescription("Lat", position.getLatitude(), this.coordDecimalPlaces) + " " + this.makeAngleDescription("Lon", position.getLongitude(), this.coordDecimalPlaces);
                String string3 = this.makeCursorElevationDescription(this.getEventSource().getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude()));
                try {
                    MGRSCoord mGRSCoord = MGRSCoord.fromLatLon(position.getLatitude(), position.getLongitude(), this.getEventSource().getModel().getGlobe());
                    string = mGRSCoord.toString();
                }
                catch (Exception exception) {
                    string = "";
                }
                this.latDisplay = string2;
                this.lonDisplay = string;
                this.elevDisplay = string3;
                if (this.previousPos != null && this.previousPos.getLatitude().compareTo(position.getLatitude()) != 0 && this.previousPos.getLongitude().compareTo(position.getLongitude()) != 0) {
                    this.eventSource.redraw();
                }
            } else {
                this.latDisplay = "";
                this.lonDisplay = Logging.getMessage("term.OffGlobe");
                this.elevDisplay = "";
            }
        }
    }

    public static class StatusUTMLayer
    extends StatusLayer {
        public void moved(PositionEvent positionEvent) {
            this.handleCursorPositionChange(positionEvent);
        }

        private void handleCursorPositionChange(PositionEvent positionEvent) {
            Position position = positionEvent.getPosition();
            if (position != null) {
                String string;
                String string2 = this.makeAngleDescription("Lat", position.getLatitude(), this.coordDecimalPlaces) + " " + this.makeAngleDescription("Lon", position.getLongitude(), this.coordDecimalPlaces);
                String string3 = this.makeCursorElevationDescription(this.getEventSource().getModel().getGlobe().getElevation(position.getLatitude(), position.getLongitude()));
                try {
                    UTMCoord uTMCoord = UTMCoord.fromLatLon(position.getLatitude(), position.getLongitude(), this.getEventSource().getModel().getGlobe());
                    string = uTMCoord.toString();
                }
                catch (Exception exception) {
                    string = "";
                }
                this.latDisplay = string2;
                this.lonDisplay = string;
                this.elevDisplay = string3;
                if (this.previousPos != null && this.previousPos.getLatitude().compareTo(position.getLatitude()) != 0 && this.previousPos.getLongitude().compareTo(position.getLongitude()) != 0) {
                    this.eventSource.redraw();
                }
            } else {
                this.latDisplay = "";
                this.lonDisplay = Logging.getMessage("term.OffGlobe");
                this.elevDisplay = "";
            }
        }
    }

    private class OrderedIcon
    implements OrderedRenderable {
        private OrderedIcon() {
        }

        public double getDistanceFromEye() {
            return 0.0;
        }

        public void pick(DrawContext drawContext, Point point) {
            StatusLayer.this.draw(drawContext);
        }

        public void render(DrawContext drawContext) {
            StatusLayer.this.draw(drawContext);
        }
    }
}

