/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.dds;

import gov.nasa.worldwind.formats.dds.BasicColorBlockExtractor;
import gov.nasa.worldwind.formats.dds.BlockDXT1;
import gov.nasa.worldwind.formats.dds.BlockDXT1Compressor;
import gov.nasa.worldwind.formats.dds.ColorBlock4x4;
import gov.nasa.worldwind.formats.dds.ColorBlockExtractor;
import gov.nasa.worldwind.formats.dds.DDSConstants;
import gov.nasa.worldwind.formats.dds.DXTCompressionAttributes;
import gov.nasa.worldwind.formats.dds.DXTCompressor;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;

public class DXT1Compressor
implements DXTCompressor {
    public int getDXTFormat() {
        return DDSConstants.D3DFMT_DXT1;
    }

    public int getCompressedSize(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = Math.max(bufferedImage.getWidth(), 4);
        int n2 = Math.max(bufferedImage.getHeight(), 4);
        return n * n2 / 2;
    }

    public void compressImage(BufferedImage bufferedImage, DXTCompressionAttributes dXTCompressionAttributes, ByteBuffer byteBuffer) {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (dXTCompressionAttributes == null) {
            String string = Logging.getMessage("nullValue.AttributesIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (byteBuffer == null) {
            String string = Logging.getMessage("nullValue.BufferNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ColorBlock4x4 colorBlock4x4 = new ColorBlock4x4();
        ColorBlockExtractor colorBlockExtractor = this.getColorBlockExtractor(bufferedImage);
        BlockDXT1 blockDXT1 = new BlockDXT1();
        BlockDXT1Compressor blockDXT1Compressor = new BlockDXT1Compressor();
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        boolean bl = bufferedImage.getColorModel().hasAlpha();
        boolean bl2 = dXTCompressionAttributes.isEnableDXT1Alpha();
        int n3 = dXTCompressionAttributes.getDXT1AlphaThreshold();
        for (int i = 0; i < n2; i += 4) {
            for (int j = 0; j < n; j += 4) {
                colorBlockExtractor.extractColorBlock4x4(dXTCompressionAttributes, j, i, colorBlock4x4);
                if (bl2 && bl && this.blockHasDXT1Alpha(colorBlock4x4, n3)) {
                    blockDXT1Compressor.compressBlockDXT1a(colorBlock4x4, dXTCompressionAttributes, blockDXT1);
                } else {
                    blockDXT1Compressor.compressBlockDXT1(colorBlock4x4, dXTCompressionAttributes, blockDXT1);
                }
                byteBuffer.putShort((short)blockDXT1.color0);
                byteBuffer.putShort((short)blockDXT1.color1);
                byteBuffer.putInt((int)blockDXT1.colorIndexMask);
            }
        }
    }

    protected boolean blockHasDXT1Alpha(ColorBlock4x4 colorBlock4x4, int n) {
        for (int i = 0; i < 16; ++i) {
            if (colorBlock4x4.color[i].a >= n) continue;
            return true;
        }
        return false;
    }

    protected ColorBlockExtractor getColorBlockExtractor(BufferedImage bufferedImage) {
        return new BasicColorBlockExtractor(bufferedImage);
    }
}

