/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.nmea;

import gov.nasa.worldwind.formats.nmea.NmeaTrackPoint;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.tracks.Track;
import gov.nasa.worldwind.tracks.TrackPoint;
import gov.nasa.worldwind.tracks.TrackPointIterator;
import gov.nasa.worldwind.tracks.TrackPointIteratorImpl;
import gov.nasa.worldwind.tracks.TrackSegment;
import gov.nasa.worldwind.util.Logging;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NmeaReader
implements Track,
TrackSegment {
    private List<Track> tracks = new ArrayList<Track>();
    private List<TrackSegment> segments = new ArrayList<TrackSegment>();
    private List<TrackPoint> points = new ArrayList<TrackPoint>();
    private String name;
    private int sentenceNumber = 0;

    public NmeaReader() {
        this.tracks.add(this);
        this.segments.add(this);
    }

    @Override
    public List<TrackSegment> getSegments() {
        return this.segments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getNumPoints() {
        return this.points.size();
    }

    @Override
    public List<TrackPoint> getPoints() {
        return this.points;
    }

    public void readFile(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.name = string;
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new FileNotFoundException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        this.doReadStream(fileInputStream);
    }

    public void readStream(InputStream inputStream, String string) throws IOException {
        if (inputStream == null) {
            String string2 = Logging.getMessage("nullValue.InputStreamIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.name = string != null ? string : "Un-named stream";
        this.doReadStream(inputStream);
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public Iterator<Position> getTrackPositionIterator() {
        return new Iterator<Position>(){
            private TrackPointIterator trackPoints;
            {
                this.trackPoints = new TrackPointIteratorImpl(NmeaReader.this.tracks);
            }

            @Override
            public boolean hasNext() {
                return this.trackPoints.hasNext();
            }

            @Override
            public Position next() {
                return this.trackPoints.next().getPosition();
            }

            @Override
            public void remove() {
                this.trackPoints.remove();
            }
        };
    }

    private void doReadStream(InputStream inputStream) {
        try {
            String string;
            do {
                if ((string = this.readSentence(inputStream)) == null) continue;
                ++this.sentenceNumber;
                this.parseSentence(string);
            } while (string != null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    private String readSentence(InputStream inputStream) throws IOException, InterruptedException {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        while (!bl && !Thread.currentThread().isInterrupted()) {
            int n = inputStream.read();
            if (n < 0) {
                return null;
            }
            if (n == 0) {
                Thread.sleep(200L);
                continue;
            }
            if (n == 36) {
                stringBuilder = new StringBuilder(100);
                continue;
            }
            if (n == 13) {
                bl = true;
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append((char)n);
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    private String readSentence(ByteBuffer byteBuffer) {
        StringBuilder stringBuilder = new StringBuilder(100);
        boolean bl = false;
        while (!bl) {
            byte by = byteBuffer.get();
            if (by == 13) {
                bl = true;
                continue;
            }
            stringBuilder.append((char)by);
        }
        return stringBuilder.toString();
    }

    private void parseSentence(String string) {
        String[] stringArray = string.split("[,*]");
        if (stringArray[0].equalsIgnoreCase("GPGGA")) {
            this.doTrackPoint(stringArray);
        }
    }

    private void doTrackPoint(String[] stringArray) {
        try {
            NmeaTrackPoint nmeaTrackPoint = new NmeaTrackPoint(stringArray);
            this.points.add(nmeaTrackPoint);
        }
        catch (Exception exception) {
            System.out.printf("Exception %s at sentence number %d for %s\n", exception.getMessage(), this.sentenceNumber, this.name);
        }
    }
}

