/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.util.Logging;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;

public class GeoCodec {
    public static final int GTModelTypeGeoKey = 1024;
    public static final int GTRasterTypeGeoKey = 1025;
    public static final int GTCitationGeoKey = 1026;
    public static final int GeographicTypeGeoKey = 2048;
    public static final int GeogCitationGeoKey = 2049;
    public static final int GeogGeodeticDatumGeoKey = 2050;
    public static final int GeogPrimeMeridianGeoKey = 2051;
    public static final int GeogLinearUnitsGeoKey = 2052;
    public static final int GeogLinearUnitSizeGeoKey = 2053;
    public static final int GeogAngularUnitsGeoKey = 2054;
    public static final int GeogAngularUnitSizeGeoKey = 2055;
    public static final int GeogEllipsoidGeoKey = 2056;
    public static final int GeogSemiMajorAxisGeoKey = 2057;
    public static final int GeogSemiMinorAxisGeoKey = 2058;
    public static final int GeogInvFlatteningGeoKey = 2059;
    public static final int GeogAzimuthUnitsGeoKey = 2060;
    public static final int GeogPrimeMeridianLongGeoKey = 2061;
    public static final int ProjectedCSTypeGeoKey = 3072;
    public static final int PCSCitationGeoKey = 3073;
    public static final int ProjectionGeoKey = 3074;
    public static final int ProjCoordTransGeoKey = 3075;
    public static final int ProjLinearUnitsGeoKey = 3076;
    public static final int ProjLinearUnitSizeGeoKey = 3077;
    public static final int ProjStdParallel1GeoKey = 3078;
    public static final int ProjStdParallel2GeoKey = 3079;
    public static final int ProjNatOriginLongGeoKey = 3080;
    public static final int ProjNatOriginLatGeoKey = 3081;
    public static final int ProjFalseEastingGeoKey = 3082;
    public static final int ProjFalseNorthingGeoKey = 3083;
    public static final int ProjFalseOriginLongGeoKey = 3084;
    public static final int ProjFalseOriginLatGeoKey = 3085;
    public static final int ProjFalseOriginEastingGeoKey = 3086;
    public static final int ProjFalseOriginNorthingGeoKey = 3087;
    public static final int ProjCenterLongGeoKey = 3088;
    public static final int ProjCenterLatGeoKey = 3089;
    public static final int ProjCenterEastingGeoKey = 3090;
    public static final int ProjCenterNorthingGeoKey = 3091;
    public static final int ProjScaleAtNatOriginGeoKey = 3092;
    public static final int ProjScaleAtCenterGeoKey = 3093;
    public static final int ProjAzimuthAngleGeoKey = 3094;
    public static final int ProjStraightVertPoleLongGeoKey = 3095;
    public static final int VerticalCSTypeGeoKey = 4096;
    public static final int VerticalCitationGeoKey = 4097;
    public static final int VerticalDatumGeoKey = 4098;
    public static final int VerticalUnitsGeoKey = 4099;
    public static final int ProjStdParallelGeoKey = 3078;
    public static final int ProjOriginLongGeoKey = 3080;
    public static final int ProjOriginLatGeoKey = 3081;
    public static final int ProjScaleAtOriginGeoKey = 3092;
    private HashMap<Integer, GeoKeyEntry> geoKeys = null;
    private Vector<ModelTiePoint> tiePoints = new Vector(1);
    private double xScale;
    private double yScale;
    private double zScale;
    private Matrix modelTransform;
    private short[] shortParams;
    private double[] doubleParams;
    private byte[] asciiParams;

    public void addModelTiePoints(double[] dArray) throws IllegalArgumentException {
        if (dArray == null || dArray.length == 0 || dArray.length % 6 != 0) {
            String string = Logging.getMessage("GeoCodec.BadTiePoints");
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        for (int i = 0; i < dArray.length; i += 6) {
            this.addModelTiePoint(dArray[i], dArray[i + 1], dArray[i + 2], dArray[i + 3], dArray[i + 4], dArray[i + 5]);
        }
    }

    public void addModelTiePoint(double d, double d2, double d3, double d4, double d5, double d6) {
        ModelTiePoint modelTiePoint = new ModelTiePoint(d, d2, d3, d4, d5, d6);
        this.tiePoints.add(modelTiePoint);
    }

    public void addModelTiePoint(ModelTiePoint modelTiePoint) {
        if (modelTiePoint != null) {
            this.tiePoints.add(modelTiePoint);
        }
    }

    public ModelTiePoint[] getTiePoints() {
        ModelTiePoint[] modelTiePointArray = new ModelTiePoint[this.tiePoints.size()];
        return this.tiePoints.toArray(modelTiePointArray);
    }

    public void clearModelTiePoints() {
        this.tiePoints.clear();
    }

    public void setModelPixelScale(double[] dArray) {
        if (dArray == null || dArray.length != 3) {
            String string = Logging.getMessage("GeoCodec.BadPixelValues");
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        this.xScale = dArray[0];
        this.yScale = dArray[1];
        this.zScale = dArray[2];
    }

    public void setModelPixelScale(double d, double d2, double d3) {
        this.xScale = d;
        this.yScale = d2;
        this.zScale = d3;
    }

    public double[] getModelPixelScales() {
        double[] dArray = new double[]{this.xScale, this.yScale, this.zScale};
        return dArray;
    }

    public double getModelPixelScaleX() {
        return this.xScale;
    }

    public double getModelPixelScaleY() {
        return this.yScale;
    }

    public double getModelPixelScaleZ() {
        return this.zScale;
    }

    public void setModelTransformation(double[] dArray) throws IllegalArgumentException {
        if (dArray == null || dArray.length != 16) {
            String string = Logging.getMessage("GeoCodec.BadMatrix");
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        this.modelTransform = Matrix.fromArray(dArray, 0, true);
    }

    public void setModelTransformation(Matrix matrix) {
        this.modelTransform = matrix;
    }

    public Matrix getMOdelTransformation() {
        return this.modelTransform;
    }

    public double[] getBoundingBox(int n, int n2) throws UnsupportedOperationException {
        double[] dArray = new double[4];
        double[] dArray2 = this.getXYAtPixel(0, 0);
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        dArray2 = this.getXYAtPixel(n2, n);
        dArray[2] = dArray2[0];
        dArray[3] = dArray2[1];
        return dArray;
    }

    public double[] getXYAtPixel(int n, int n2) throws UnsupportedOperationException {
        if (this.tiePoints.size() != 1) {
            String string = Logging.getMessage("GeotiffReader.NotSimpleGeotiff");
            Logging.logger().severe(string);
            throw new UnsupportedOperationException(string);
        }
        double[] dArray = new double[2];
        ModelTiePoint modelTiePoint = this.tiePoints.get(0);
        dArray[0] = modelTiePoint.x + (double)n2 * this.xScale;
        dArray[1] = modelTiePoint.y - (double)n * this.yScale;
        return dArray;
    }

    public int[] getGeoKeyAsInts(int n) throws IllegalArgumentException {
        GeoKeyEntry geoKeyEntry;
        int[] nArray = null;
        if (this.geoKeys != null && (geoKeyEntry = this.geoKeys.get(n)) != null) {
            if (geoKeyEntry.array != this.shortParams) {
                String string = Logging.getMessage("GeoCodec.NotIntegerKey", n);
                Logging.logger().severe(string);
                throw new UnsupportedOperationException(string);
            }
            nArray = new int[geoKeyEntry.count];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0xFFFF & this.shortParams[geoKeyEntry.offset + i];
            }
        }
        return nArray;
    }

    public double[] getGeoKeyAsDoubles(int n) throws IllegalArgumentException {
        GeoKeyEntry geoKeyEntry;
        double[] dArray = null;
        if (this.geoKeys != null && (geoKeyEntry = this.geoKeys.get(n)) != null) {
            if (geoKeyEntry.array != this.doubleParams) {
                String string = Logging.getMessage("GeoCodec.NotDoubleKey", n);
                Logging.logger().severe(string);
                throw new UnsupportedOperationException(string);
            }
            dArray = new double[geoKeyEntry.count];
            System.arraycopy(this.doubleParams, geoKeyEntry.offset, dArray, 0, geoKeyEntry.count);
        }
        return dArray;
    }

    public String getGeoKeyAsString(int n) throws IllegalArgumentException {
        GeoKeyEntry geoKeyEntry;
        String string = null;
        if (this.geoKeys != null && (geoKeyEntry = this.geoKeys.get(n)) != null) {
            if (geoKeyEntry.array != this.asciiParams) {
                String string2 = Logging.getMessage("GeoCodec.NotAsciiKey", n);
                Logging.logger().severe(string2);
                throw new UnsupportedOperationException(string2);
            }
            string = new String(this.asciiParams, geoKeyEntry.offset, geoKeyEntry.count);
        }
        return string;
    }

    public int[] getGeoKeys() {
        if (this.geoKeys == null || this.geoKeys.size() == 0) {
            return null;
        }
        Set<Integer> set = this.geoKeys.keySet();
        int[] nArray = new int[set.size()];
        int n = 0;
        for (Integer n2 : set) {
            nArray[n++] = n2;
        }
        return nArray;
    }

    public boolean hasGeoKey(int n) {
        return this.geoKeys != null && this.geoKeys.get(n) != null;
    }

    void setGeokeys(short[] sArray) {
        if (sArray != null && sArray.length > 4) {
            this.shortParams = new short[sArray.length];
            System.arraycopy(sArray, 0, this.shortParams, 0, sArray.length);
            short s = sArray[3];
            this.geoKeys = new HashMap();
            for (int i = 4; i < s * 4; i += 4) {
                int n = 0xFFFF & sArray[i];
                int n2 = 0xFFFF & sArray[i + 1];
                if (n2 == 0) {
                    this.geoKeys.put(n, new GeoKeyEntry(n, 1, i + 3, this.shortParams));
                    continue;
                }
                Object[] objectArray = null;
                if (n2 == 34735) {
                    objectArray = this.shortParams;
                } else if (n2 == 34736) {
                    objectArray = this.doubleParams;
                } else if (n2 == 34737) {
                    objectArray = this.asciiParams;
                }
                if (objectArray == null) continue;
                this.geoKeys.put(n, new GeoKeyEntry(n, 0xFFFF & sArray[i + 2], 0xFFFF & sArray[i + 3], objectArray));
            }
        }
    }

    void setDoubleParams(double[] dArray) {
        this.doubleParams = new double[dArray.length];
        System.arraycopy(dArray, 0, this.doubleParams, 0, dArray.length);
    }

    void setAsciiParams(byte[] byArray) {
        this.asciiParams = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.asciiParams, 0, byArray.length);
    }

    private class GeoKeyEntry {
        int tag;
        int count;
        int offset;
        Object array;

        GeoKeyEntry(int n, int n2, int n3, Object object) {
            this.tag = n;
            this.count = n2;
            this.offset = n3;
            this.array = object;
        }
    }

    public class ModelTiePoint {
        public double i;
        public double j;
        public double k;
        public double x;
        public double y;
        public double z;

        public ModelTiePoint(double d, double d2, double d3, double d4, double d5, double d6) {
            this.i = d;
            this.j = d2;
            this.k = d3;
            this.x = d4;
            this.y = d5;
            this.z = d6;
        }

        public double getRow() {
            return this.j;
        }

        public double getColumn() {
            return this.i;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

