/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeotiffImageReader
extends ImageReader {
    private ImageInputStream theStream = null;
    private ArrayList<TiffIFDEntry[]> ifds = new ArrayList(1);
    private double[] geoPixelScale = null;
    private double[] geoTiePoints = null;
    private double[] geoMatrix = null;
    private GeoKey[] geoKeys = null;

    public GeotiffImageReader(ImageReaderSpi imageReaderSpi) {
        super(imageReaderSpi);
    }

    @Override
    public int getNumImages(boolean bl) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int n) throws IOException {
        if (n < 0 || n >= this.getNumImages(true)) {
            throw new IllegalArgumentException(this.getClass().getName() + ".getWidth(): illegal imageIndex: " + n);
        }
        if (this.ifds.size() == 0) {
            this.readIFDs();
        }
        TiffIFDEntry tiffIFDEntry = this.getByTag(this.ifds.get(n), 256);
        return (int)tiffIFDEntry.asLong();
    }

    @Override
    public int getHeight(int n) throws IOException {
        if (n < 0 || n >= this.getNumImages(true)) {
            throw new IllegalArgumentException(this.getClass().getName() + ".getHeight(): illegal imageIndex: " + n);
        }
        if (this.ifds.size() == 0) {
            this.readIFDs();
        }
        TiffIFDEntry tiffIFDEntry = this.getByTag(this.ifds.get(n), 257);
        return (int)tiffIFDEntry.asLong();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int n) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public IIOMetadata getImageMetadata(int n) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public BufferedImage read(int n, ImageReadParam imageReadParam) throws IOException {
        WritableRaster writableRaster;
        ColorModel colorModel;
        TiffIFDEntry[] tiffIFDEntryArray;
        if (n != 0) {
            throw new IllegalArgumentException(this.getClass().getName() + ".read(): illegal imageIndex: " + n);
        }
        this.readIFDs();
        TiffIFDEntry tiffIFDEntry = null;
        TiffIFDEntry tiffIFDEntry2 = null;
        TiffIFDEntry tiffIFDEntry3 = null;
        TiffIFDEntry tiffIFDEntry4 = null;
        TiffIFDEntry tiffIFDEntry5 = null;
        TiffIFDEntry tiffIFDEntry6 = null;
        TiffIFDEntry tiffIFDEntry7 = null;
        TiffIFDEntry tiffIFDEntry8 = null;
        TiffIFDEntry tiffIFDEntry9 = null;
        TiffIFDEntry tiffIFDEntry10 = null;
        TiffIFDEntry tiffIFDEntry11 = null;
        block13: for (TiffIFDEntry tiffIFDEntry12 : tiffIFDEntryArray = this.ifds.get(n)) {
            switch (tiffIFDEntry12.tag) {
                case 256: {
                    tiffIFDEntry = tiffIFDEntry12;
                    continue block13;
                }
                case 257: {
                    tiffIFDEntry2 = tiffIFDEntry12;
                    continue block13;
                }
                case 258: {
                    tiffIFDEntry3 = tiffIFDEntry12;
                    continue block13;
                }
                case 277: {
                    tiffIFDEntry4 = tiffIFDEntry12;
                    continue block13;
                }
                case 262: {
                    tiffIFDEntry5 = tiffIFDEntry12;
                    continue block13;
                }
                case 273: {
                    tiffIFDEntry6 = tiffIFDEntry12;
                    continue block13;
                }
                case 279: {
                    tiffIFDEntry7 = tiffIFDEntry12;
                    continue block13;
                }
                case 278: {
                    tiffIFDEntry8 = tiffIFDEntry12;
                    continue block13;
                }
                case 284: {
                    tiffIFDEntry9 = tiffIFDEntry12;
                    continue block13;
                }
                case 320: {
                    tiffIFDEntry10 = tiffIFDEntry12;
                    continue block13;
                }
                case 339: {
                    tiffIFDEntry11 = tiffIFDEntry12;
                }
            }
        }
        if (tiffIFDEntry == null || tiffIFDEntry2 == null || tiffIFDEntry4 == null || tiffIFDEntry5 == null || tiffIFDEntry6 == null || tiffIFDEntry7 == null || tiffIFDEntry8 == null || tiffIFDEntry9 == null) {
            throw new IIOException(this.getClass().getName() + ".read(): unable to decipher image organization");
        }
        int n2 = (int)tiffIFDEntry.asLong();
        int n3 = (int)tiffIFDEntry2.asLong();
        int n4 = (int)tiffIFDEntry4.asLong();
        long l = tiffIFDEntry5.asLong();
        long l2 = tiffIFDEntry8.asLong();
        long l3 = tiffIFDEntry9.asLong();
        int[] nArray = this.getBitsPerSample(tiffIFDEntry3);
        long[] lArray = this.getStripsArray(tiffIFDEntry6);
        long[] lArray2 = this.getStripsArray(tiffIFDEntry7);
        if (n4 == 1 && nArray.length == 1 && nArray[0] == 16) {
            long l4 = tiffIFDEntry11 != null ? tiffIFDEntry11.asLong() : 1L;
            int n5 = l4 == 2L ? 2 : 1;
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, false, false, 1, n5);
            int[] nArray2 = new int[]{0};
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(n5, n2, n3, 1, n2, nArray2);
            short[][] sArray = this.readPlanar16(n2, n3, n4, lArray, lArray2, l2);
            DataBuffer dataBuffer = n5 == 2 ? new DataBufferShort(sArray, n2 * n3, nArray2) : new DataBufferUShort(sArray, n2 * n3, nArray2);
            writableRaster = Raster.createWritableRaster(componentSampleModel, dataBuffer, new Point(0, 0));
        } else if (n4 == 1 && nArray.length == 1 && nArray[0] == 32 && tiffIFDEntry11 != null && tiffIFDEntry11.asLong() == 3L) {
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, false, false, 1, 4);
            int[] nArray3 = new int[]{0};
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(4, n2, n3, 1, n2, nArray3);
            float[][] fArray = this.readPlanarFloat32(n2, n3, n4, lArray, lArray2, l2);
            DataBufferFloat dataBufferFloat = new DataBufferFloat(fArray, n2 * n3, nArray3);
            writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferFloat, new Point(0, 0));
        } else {
            int n6;
            Object object = nArray;
            int n7 = ((int[])object).length;
            for (n6 = 0; n6 < n7; ++n6) {
                int n8 = object[n6];
                if (n8 == 8) continue;
                throw new IIOException(this.getClass().getName() + ".read(): only expecting 8 bits/sample; found " + n8);
            }
            colorModel = null;
            if (n4 > 1) {
                int n9 = 1;
                n7 = 0;
                if (n4 == 4) {
                    n9 = 3;
                    n7 = 1;
                }
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray, n7 != 0, false, n9, 0);
            } else if (l == 3L) {
                if (tiffIFDEntry10 == null) {
                    throw new IIOException(this.getClass().getName() + ".read(): no ColorMap found for indexed image type");
                }
                object = this.readColorMap(tiffIFDEntry10);
                colorModel = new IndexColorModel(nArray[0], (int)tiffIFDEntry10.count / 3, (byte[])object[0], (byte[])object[1], (byte[])object[2]);
            } else {
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, false, false, 1, 0);
            }
            int[] nArray4 = new int[n4];
            for (n7 = 0; n7 < n4; ++n7) {
                nArray4[n7] = n7;
            }
            int[] nArray5 = new int[l3 == 1L ? 1 : n4];
            for (n6 = 0; n6 < nArray5.length; ++n6) {
                nArray5[n6] = 0;
            }
            ComponentSampleModel componentSampleModel = n4 == 1 ? new ComponentSampleModel(0, n2, n3, 1, n2, nArray4) : (l3 == 1L ? new PixelInterleavedSampleModel(0, n2, n3, n4, n2 * n4, nArray4) : new BandedSampleModel(0, n2, n3, n2, nArray4, nArray5));
            byte[][] byArray = l3 == 1L ? this.readPixelInterleaved8(n2, n3, n4, lArray, lArray2) : this.readPlanar8(n2, n3, n4, lArray, lArray2, l2);
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, n2 * n3, nArray5);
            writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        }
        this.decodeGeotiffInfo();
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    private void decodeGeotiffInfo() throws IOException {
        TiffIFDEntry[] tiffIFDEntryArray;
        this.readIFDs();
        block7: for (TiffIFDEntry tiffIFDEntry : tiffIFDEntryArray = this.ifds.get(0)) {
            switch (tiffIFDEntry.tag) {
                case 33550: {
                    this.geoPixelScale = this.readDoubles(tiffIFDEntry);
                    continue block7;
                }
                case 33922: {
                    this.geoTiePoints = this.readDoubles(tiffIFDEntry);
                    continue block7;
                }
                case 34264: {
                    this.geoMatrix = this.readDoubles(tiffIFDEntry);
                    continue block7;
                }
                case 34735: {
                    this.readGeoKeys(tiffIFDEntry);
                    continue block7;
                }
                case 34736: {
                    continue block7;
                }
            }
        }
    }

    private void readIFDs() throws IOException {
        byte[] byArray;
        block6: {
            if (this.theStream != null) {
                return;
            }
            if (this.input == null || !(this.input instanceof ImageInputStream)) {
                throw new IIOException(this.getClass().getName() + ": null/invalid ImageInputStream");
            }
            this.theStream = (ImageInputStream)this.input;
            byArray = new byte[2];
            try {
                this.theStream.readFully(byArray);
                if (byArray[0] == 77 && byArray[1] == 77) {
                    this.theStream.setByteOrder(ByteOrder.BIG_ENDIAN);
                    break block6;
                }
                if (byArray[0] == 73 && byArray[1] == 73) {
                    this.theStream.setByteOrder(ByteOrder.LITTLE_ENDIAN);
                    break block6;
                }
                throw new IOException();
            }
            catch (IOException iOException) {
                throw new IIOException(this.getClass().getName() + ": error reading signature");
            }
        }
        this.theStream.readFully(byArray);
        long l = this.theStream.readUnsignedInt();
        this.readIFD(l);
    }

    private void readIFD(long l) throws IIOException {
        try {
            this.theStream.seek(l);
            int n = this.theStream.readUnsignedShort();
            TiffIFDEntry[] tiffIFDEntryArray = new TiffIFDEntry[n];
            for (int i = 0; i < n; ++i) {
                long l2;
                int n2 = this.theStream.readUnsignedShort();
                int n3 = this.theStream.readUnsignedShort();
                long l3 = this.theStream.readUnsignedInt();
                if (n3 == 3 && l3 == 1L) {
                    int n4 = this.theStream.readUnsignedShort();
                    int n5 = this.theStream.readUnsignedShort();
                    l2 = (0xFFFF & n4) << 16 | 0xFFFF & n5;
                } else {
                    l2 = this.theStream.readUnsignedInt();
                }
                tiffIFDEntryArray[i] = new TiffIFDEntry(n2, n3, l3, l2);
            }
            this.ifds.add(tiffIFDEntryArray);
        }
        catch (Exception exception) {
            throw new IIOException("Error reading Tiff IFD: " + exception.getMessage());
        }
    }

    private byte[][] readPixelInterleaved8(int n, int n2, int n3, long[] lArray, long[] lArray2) throws IOException {
        byte[][] byArray = new byte[1][n * n2 * n3];
        int n4 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            this.theStream.seek(lArray[i]);
            int n5 = (int)lArray2[i];
            if (n4 + n5 >= byArray[0].length) {
                n5 = byArray[0].length - n4;
            }
            this.theStream.readFully(byArray[0], n4, n5);
            n4 = (int)((long)n4 + lArray2[i]);
        }
        return byArray;
    }

    private byte[][] readPlanar8(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        byte[][] byArray = new byte[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            this.theStream.seek(lArray[i]);
            int n7 = (int)lArray2[i];
            if (n5 + n7 >= byArray[n4].length) {
                n7 = byArray[n4].length - n5;
            }
            this.theStream.readFully(byArray[n4], n5, n7);
            n5 = (int)((long)n5 + lArray2[i]);
            n6 = (int)((long)n6 + l);
            if (n6 < n2) continue;
            ++n4;
            n6 = 0;
            n5 = 0;
        }
        return byArray;
    }

    private short[][] readPlanar16(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        short[][] sArray = new short[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            this.theStream.seek(lArray[i]);
            int n7 = (int)lArray2[i] / 16;
            if (n5 + n7 >= sArray[n4].length) {
                n7 = sArray[n4].length - n5;
            }
            this.theStream.readFully(sArray[n4], n5, n7);
            n5 = (int)((long)n5 + lArray2[i] / 16L);
            n6 = (int)((long)n6 + l);
            if (n6 < n2) continue;
            ++n4;
            n6 = 0;
            n5 = 0;
        }
        return sArray;
    }

    private float[][] readPlanarFloat32(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        float[][] fArray = new float[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i < lArray.length; ++i) {
            this.theStream.seek(lArray[i]);
            int n7 = (int)lArray2[i] / 32;
            if (n5 + n7 >= fArray[n4].length) {
                n7 = fArray[n4].length - n5;
            }
            this.theStream.readFully(fArray[n4], n5, n7);
            n5 = (int)((long)n5 + lArray2[i] / 32L);
            n6 = (int)((long)n6 + l);
            if (n6 < n2) continue;
            ++n4;
            n6 = 0;
            n5 = 0;
        }
        return fArray;
    }

    private byte[][] readColorMap(TiffIFDEntry tiffIFDEntry) throws IOException {
        int n = (int)tiffIFDEntry.count / 3;
        short[][] sArray = new short[3][n];
        this.theStream.seek(tiffIFDEntry.asLong());
        this.theStream.readFully(sArray[0], 0, n);
        this.theStream.readFully(sArray[1], 0, n);
        this.theStream.readFully(sArray[2], 0, n);
        byte[][] byArray = new byte[3][n];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < n; ++j) {
                byArray[i][j] = (byte)(0xFF & sArray[i][j]);
            }
        }
        return byArray;
    }

    private double[] readDoubles(TiffIFDEntry tiffIFDEntry) throws IOException {
        double[] dArray = new double[(int)tiffIFDEntry.count];
        this.theStream.seek(tiffIFDEntry.asOffset());
        this.theStream.readFully(dArray, 0, dArray.length);
        return dArray;
    }

    private void readGeoKeys(TiffIFDEntry tiffIFDEntry) throws IOException {
        short[] sArray = new short[4];
        this.theStream.seek(tiffIFDEntry.asLong());
        this.theStream.readFully(sArray, 0, sArray.length);
        short s = sArray[3];
        this.geoKeys = new GeoKey[s];
        sArray = new short[s * 4];
        this.theStream.readFully(sArray, 0, s * 4);
        int n = 0;
        for (int i = 0; i < s * 4; i += 4) {
            GeoKey geoKey = new GeoKey();
            geoKey.key = sArray[i];
            geoKey.value = sArray[i + 1] == 0 ? new Integer(sArray[i + 3]) : this.getByTag(this.ifds.get(0), 0xFFFF & sArray[i + 1]);
            this.geoKeys[n++] = geoKey;
        }
    }

    private TiffIFDEntry getByTag(TiffIFDEntry[] tiffIFDEntryArray, int n) {
        for (TiffIFDEntry tiffIFDEntry : tiffIFDEntryArray) {
            if (tiffIFDEntry.tag != n) continue;
            return tiffIFDEntry;
        }
        return null;
    }

    private long[] getStripsArray(TiffIFDEntry tiffIFDEntry) throws IOException {
        long[] lArray = new long[(int)tiffIFDEntry.count];
        if (tiffIFDEntry.count == 1L) {
            lArray[0] = tiffIFDEntry.asLong();
        } else {
            long l = tiffIFDEntry.asLong();
            this.theStream.seek(l);
            if (tiffIFDEntry.type == 3) {
                int n = 0;
                while ((long)n < tiffIFDEntry.count) {
                    lArray[n] = this.theStream.readUnsignedShort();
                    ++n;
                }
            } else {
                int n = 0;
                while ((long)n < tiffIFDEntry.count) {
                    lArray[n] = this.theStream.readUnsignedInt();
                    ++n;
                }
            }
        }
        return lArray;
    }

    private int[] getBitsPerSample(TiffIFDEntry tiffIFDEntry) throws IOException {
        if (tiffIFDEntry == null) {
            return new int[]{1};
        }
        if (tiffIFDEntry.count == 1L) {
            return new int[]{(int)tiffIFDEntry.asLong()};
        }
        long[] lArray = this.getStripsArray(tiffIFDEntry);
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    private class GeoKey {
        short key;
        Object value;

        private GeoKey() {
        }
    }
}

