/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.formats.tiff.GeoCodec;
import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

public class GeotiffReader {
    private String sourceFilename;
    private RandomAccessFile sourceFile;
    private FileChannel theChannel;
    private ByteOrder tiffFileOrder;
    private ArrayList<TiffIFDEntry[]> ifds = null;
    private GeoCodec geoCodec = null;
    private static final int DOUBLE_SIZEOF = 8;
    private static final int FLOAT_SIZEOF = 4;
    private static final int INTEGER_SIZEOF = 4;
    private static final int SHORT_SIZEOF = 2;

    public GeotiffReader(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public GeotiffReader(String string) throws IOException {
        this.sourceFilename = string;
        this.sourceFile = new RandomAccessFile(string, "r");
        this.theChannel = this.sourceFile.getChannel();
        this.readIFDs();
    }

    public void close() {
        try {
            this.sourceFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getNumImages() throws IOException {
        return this.ifds != null ? this.ifds.size() : 0;
    }

    public int getWidth(int n) throws IOException {
        this.checkImageIndex(n);
        TiffIFDEntry tiffIFDEntry = this.getByTag(this.ifds.get(n), 256);
        return (int)tiffIFDEntry.asLong();
    }

    public int getHeight(int n) throws IOException {
        this.checkImageIndex(n);
        TiffIFDEntry tiffIFDEntry = this.getByTag(this.ifds.get(n), 257);
        return (int)tiffIFDEntry.asLong();
    }

    public BufferedImage read() throws IOException {
        return this.read(0);
    }

    public BufferedImage read(int n) throws IOException {
        WritableRaster writableRaster;
        ColorModel colorModel;
        Object object;
        this.checkImageIndex(n);
        TiffIFDEntry tiffIFDEntry = null;
        TiffIFDEntry tiffIFDEntry2 = null;
        TiffIFDEntry tiffIFDEntry3 = null;
        TiffIFDEntry tiffIFDEntry4 = null;
        TiffIFDEntry tiffIFDEntry5 = null;
        TiffIFDEntry tiffIFDEntry6 = null;
        TiffIFDEntry tiffIFDEntry7 = null;
        TiffIFDEntry tiffIFDEntry8 = null;
        TiffIFDEntry tiffIFDEntry9 = null;
        TiffIFDEntry tiffIFDEntry10 = null;
        TiffIFDEntry tiffIFDEntry11 = null;
        TiffIFDEntry[] tiffIFDEntryArray = this.ifds.get(n);
        block13: for (TiffIFDEntry tiffIFDEntry12 : tiffIFDEntryArray) {
            switch (tiffIFDEntry12.tag) {
                case 256: {
                    tiffIFDEntry = tiffIFDEntry12;
                    continue block13;
                }
                case 257: {
                    tiffIFDEntry2 = tiffIFDEntry12;
                    continue block13;
                }
                case 258: {
                    tiffIFDEntry3 = tiffIFDEntry12;
                    continue block13;
                }
                case 277: {
                    tiffIFDEntry4 = tiffIFDEntry12;
                    continue block13;
                }
                case 262: {
                    tiffIFDEntry5 = tiffIFDEntry12;
                    continue block13;
                }
                case 273: {
                    tiffIFDEntry6 = tiffIFDEntry12;
                    continue block13;
                }
                case 279: {
                    tiffIFDEntry7 = tiffIFDEntry12;
                    continue block13;
                }
                case 278: {
                    tiffIFDEntry8 = tiffIFDEntry12;
                    continue block13;
                }
                case 284: {
                    tiffIFDEntry9 = tiffIFDEntry12;
                    continue block13;
                }
                case 320: {
                    tiffIFDEntry10 = tiffIFDEntry12;
                    continue block13;
                }
                case 339: {
                    tiffIFDEntry11 = tiffIFDEntry12;
                }
            }
        }
        if (tiffIFDEntry == null || tiffIFDEntry2 == null || tiffIFDEntry4 == null || tiffIFDEntry5 == null || tiffIFDEntry6 == null || tiffIFDEntry7 == null || tiffIFDEntry8 == null || tiffIFDEntry9 == null) {
            object = Logging.getMessage("GeotiffReader.MissingTags");
            Logging.logger().severe((String)object);
            throw new IOException((String)object);
        }
        object = this.getByTag(tiffIFDEntryArray, 259);
        if (object != null && ((TiffIFDEntry)object).asLong() != 1L) {
            String string = Logging.getMessage("GeotiffReader.NoCompressed");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        object = this.getByTag(tiffIFDEntryArray, 322);
        if (object != null) {
            String string = Logging.getMessage("GeotiffReader.NoTiled");
            Logging.logger().severe(string);
            throw new IOException(string);
        }
        int n2 = (int)tiffIFDEntry.asLong();
        int n3 = (int)tiffIFDEntry2.asLong();
        int n4 = (int)tiffIFDEntry4.asLong();
        long l = tiffIFDEntry5.asLong();
        long l2 = tiffIFDEntry8.asLong();
        long l3 = tiffIFDEntry9.asLong();
        int[] nArray = this.getBitsPerSample(tiffIFDEntry3);
        long[] lArray = this.getStripsArray(tiffIFDEntry6);
        long[] lArray2 = this.getStripsArray(tiffIFDEntry7);
        if (n4 == 1 && nArray.length == 1 && nArray[0] == 16) {
            long l4 = tiffIFDEntry11 != null ? tiffIFDEntry11.asLong() : 1L;
            int n5 = l4 == 2L ? 2 : 1;
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, false, false, 1, n5);
            int[] nArray2 = new int[]{0};
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(n5, n2, n3, 1, n2, nArray2);
            short[][] sArray = this.readPlanar16(n2, n3, n4, lArray, lArray2, l2);
            DataBuffer dataBuffer = n5 == 2 ? new DataBufferShort(sArray, n2 * n3, nArray2) : new DataBufferUShort(sArray, n2 * n3, nArray2);
            writableRaster = Raster.createWritableRaster(componentSampleModel, dataBuffer, new Point(0, 0));
        } else if (n4 == 1 && nArray.length == 1 && nArray[0] == 32 && tiffIFDEntry11 != null && tiffIFDEntry11.asLong() == 3L) {
            colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, false, false, 1, 4);
            int[] nArray3 = new int[]{0};
            ComponentSampleModel componentSampleModel = new ComponentSampleModel(4, n2, n3, 1, n2, nArray3);
            float[][] fArray = this.readPlanarFloat32(n2, n3, n4, lArray, lArray2, l2);
            DataBufferFloat dataBufferFloat = new DataBufferFloat(fArray, n2 * n3, nArray3);
            writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferFloat, new Point(0, 0));
        } else {
            int n6;
            Object object2 = nArray;
            int n7 = ((int[])object2).length;
            for (n6 = 0; n6 < n7; ++n6) {
                int n8 = object2[n6];
                if (n8 == 8) continue;
                String string = Logging.getMessage("GeotiffReader.Not8bit", n8);
                Logging.logger().warning(string);
                throw new IOException(string);
            }
            if (n4 > 1) {
                int n9 = 1;
                n7 = 0;
                if (n4 == 4) {
                    n9 = 3;
                    n7 = 1;
                }
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), nArray, n7 != 0, false, n9, 0);
            } else if (l == 3L) {
                if (tiffIFDEntry10 == null) {
                    object2 = Logging.getMessage("GeotiffReader.MissingColormap");
                    Logging.logger().severe((String)object2);
                    throw new IOException((String)object2);
                }
                object2 = this.readColorMap(tiffIFDEntry10);
                colorModel = new IndexColorModel(nArray[0], (int)tiffIFDEntry10.count / 3, (byte[])object2[0], (byte[])object2[1], (byte[])object2[2]);
            } else {
                colorModel = new ComponentColorModel(ColorSpace.getInstance(1003), nArray, false, false, 1, 0);
            }
            int[] nArray4 = new int[n4];
            for (n7 = 0; n7 < n4; ++n7) {
                nArray4[n7] = n7;
            }
            int[] nArray5 = new int[l3 == 1L ? 1 : n4];
            for (n6 = 0; n6 < nArray5.length; ++n6) {
                nArray5[n6] = 0;
            }
            ComponentSampleModel componentSampleModel = n4 == 1 ? new ComponentSampleModel(0, n2, n3, 1, n2, nArray4) : (l3 == 1L ? new PixelInterleavedSampleModel(0, n2, n3, n4, n2 * n4, nArray4) : new BandedSampleModel(0, n2, n3, n2, nArray4, nArray5));
            byte[][] byArray = l3 == 1L ? this.readPixelInterleaved8(n2, n3, n4, lArray, lArray2) : this.readPlanar8(n2, n3, n4, lArray, lArray2, l2);
            DataBufferByte dataBufferByte = new DataBufferByte(byArray, n2 * n3, nArray5);
            writableRaster = Raster.createWritableRaster(componentSampleModel, dataBufferByte, new Point(0, 0));
        }
        return new BufferedImage(colorModel, writableRaster, false, null);
    }

    public boolean isGeotiff() {
        return this.geoCodec != null;
    }

    public GeoCodec getGeoCodec() {
        return this.geoCodec;
    }

    private void repackageGeoReferencingTags() throws IOException {
        TiffIFDEntry[] tiffIFDEntryArray;
        GeoCodec geoCodec = new GeoCodec();
        boolean bl = false;
        block8: for (TiffIFDEntry tiffIFDEntry : tiffIFDEntryArray = this.ifds.get(0)) {
            switch (tiffIFDEntry.tag) {
                case 33550: {
                    geoCodec.setModelPixelScale(this.readDoubles(tiffIFDEntry));
                    bl = true;
                    continue block8;
                }
                case 33922: {
                    geoCodec.addModelTiePoints(this.readDoubles(tiffIFDEntry));
                    bl = true;
                    continue block8;
                }
                case 34264: {
                    geoCodec.setModelTransformation(this.readDoubles(tiffIFDEntry));
                    bl = true;
                    continue block8;
                }
                case 34735: {
                    geoCodec.setGeokeys(this.readShorts(tiffIFDEntry));
                    bl = true;
                    continue block8;
                }
                case 34736: {
                    geoCodec.setDoubleParams(this.readDoubles(tiffIFDEntry));
                    continue block8;
                }
                case 34737: {
                    geoCodec.setAsciiParams(this.readBytes(tiffIFDEntry));
                }
            }
        }
        if (bl) {
            this.geoCodec = geoCodec;
        }
    }

    private void readIFDs() throws IOException {
        ByteBuffer byteBuffer;
        block6: {
            if (this.ifds != null) {
                return;
            }
            if (this.theChannel == null) {
                String string = Logging.getMessage("GeotiffReader.NullInputFile", this.sourceFilename);
                Logging.logger().severe(string);
                throw new IOException(string);
            }
            byteBuffer = ByteBuffer.allocate(8);
            try {
                this.theChannel.read(byteBuffer);
                byteBuffer.flip();
                if (byteBuffer.get(0) == 77 && byteBuffer.get(1) == 77) {
                    this.tiffFileOrder = ByteOrder.BIG_ENDIAN;
                    break block6;
                }
                if (byteBuffer.get(0) == 73 && byteBuffer.get(1) == 73) {
                    this.tiffFileOrder = ByteOrder.LITTLE_ENDIAN;
                    break block6;
                }
                throw new IOException();
            }
            catch (IOException iOException) {
                String string = Logging.getMessage("GeotiffReader.BadTiffSig");
                Logging.logger().severe(string);
                throw new IOException(string);
            }
        }
        byteBuffer.order(this.tiffFileOrder).position(4);
        long l = this.getUnsignedInt(byteBuffer);
        this.theChannel.position(l);
        byteBuffer.clear().limit(2);
        this.theChannel.read(byteBuffer);
        byteBuffer.flip();
        this.readIFD(byteBuffer.getShort());
        this.repackageGeoReferencingTags();
    }

    private void readIFD(int n) throws IOException {
        try {
            TiffIFDEntry[] tiffIFDEntryArray = new TiffIFDEntry[n];
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 2 * 2 * 2 * 4 + 4);
            this.theChannel.read(byteBuffer);
            byteBuffer.order(this.tiffFileOrder).flip();
            for (int i = 0; i < n; ++i) {
                long l;
                int n2 = this.getUnsignedShort(byteBuffer);
                int n3 = this.getUnsignedShort(byteBuffer);
                long l2 = this.getUnsignedInt(byteBuffer);
                if (n3 == 3 && l2 == 1L) {
                    int n4 = this.getUnsignedShort(byteBuffer);
                    int n5 = this.getUnsignedShort(byteBuffer);
                    l = (0xFFFF & n4) << 16 | 0xFFFF & n5;
                } else {
                    l = this.getUnsignedInt(byteBuffer);
                }
                tiffIFDEntryArray[i] = new TiffIFDEntry(n2, n3, l2, l);
            }
            if (this.ifds == null) {
                this.ifds = new ArrayList(1);
            }
            this.ifds.add(tiffIFDEntryArray);
            long l = this.getUnsignedInt(byteBuffer);
            if (l > 0L) {
                this.theChannel.position(l);
                byteBuffer.clear().limit(2);
                this.theChannel.read(byteBuffer);
                byteBuffer.flip();
                this.readIFD(byteBuffer.getShort());
            }
        }
        catch (Exception exception) {
            String string = Logging.getMessage("GeotiffReader.BadIFD", exception.getMessage());
            Logging.logger().severe(string);
            throw new IOException(string);
        }
    }

    private byte[][] readPixelInterleaved8(int n, int n2, int n3, long[] lArray, long[] lArray2) throws IOException {
        byte[][] byArray = new byte[1][n * n2 * n3];
        int n4 = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray[0]);
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n5 = (int)lArray2[i];
            if (n4 + n5 >= byArray[0].length) {
                n5 = byArray[0].length - n4;
            }
            byteBuffer.limit(n4 + n5);
            this.theChannel.read(byteBuffer);
            n4 = (int)((long)n4 + lArray2[i]);
        }
        return byArray;
    }

    private byte[][] readPlanar8(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        byte[][] byArray = new byte[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray[n4]);
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n7 = (int)lArray2[i];
            if (n5 + n7 >= byArray[n4].length) {
                n7 = byArray[n4].length - n5;
            }
            byteBuffer.limit(n5 + n7);
            this.theChannel.read(byteBuffer);
            n5 = (int)((long)n5 + lArray2[i]);
            n6 = (int)((long)n6 + l);
            if (n6 < n2 || n4 >= byArray.length - 1) continue;
            byteBuffer = ByteBuffer.wrap(byArray[++n4]);
            n6 = 0;
            n5 = 0;
        }
        return byArray;
    }

    private short[][] readPlanar16(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        short[][] sArray = new short[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * 2);
        byteBuffer.order(this.tiffFileOrder);
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n6 = (int)lArray2[i];
            if (byteBuffer.position() + n6 > sArray[n4].length * 2) {
                n6 = sArray[n4].length * 2 - byteBuffer.position();
            }
            byteBuffer.limit(byteBuffer.position() + n6);
            this.theChannel.read(byteBuffer);
            n5 = (int)((long)n5 + l);
            if (n5 < n2) continue;
            byteBuffer.flip();
            ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
            shortBuffer.get(sArray[n4]);
            byteBuffer.clear();
            ++n4;
            n5 = 0;
        }
        return sArray;
    }

    private float[][] readPlanarFloat32(int n, int n2, int n3, long[] lArray, long[] lArray2, long l) throws IOException {
        float[][] fArray = new float[n3][n * n2];
        int n4 = 0;
        int n5 = 0;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * n2 * 4);
        byteBuffer.order(this.tiffFileOrder);
        for (int i = 0; i < lArray.length; ++i) {
            this.theChannel.position(lArray[i]);
            int n6 = (int)lArray2[i];
            if (byteBuffer.position() + n6 >= fArray[n4].length * 4) {
                n6 = fArray[n4].length * 4 - byteBuffer.position();
            }
            byteBuffer.limit(byteBuffer.position() + n6);
            this.theChannel.read(byteBuffer);
            n5 = (int)((long)n5 + l);
            if (n5 < n2) continue;
            byteBuffer.flip();
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.get(fArray[n4]);
            byteBuffer.clear();
            ++n4;
            n5 = 0;
        }
        return fArray;
    }

    private byte[][] readColorMap(TiffIFDEntry tiffIFDEntry) throws IOException {
        int n = (int)tiffIFDEntry.count / 3;
        byte[][] byArray = new byte[3][n * 2];
        this.theChannel.position(tiffIFDEntry.asLong());
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray[0]);
        this.theChannel.read(byteBuffer);
        byteBuffer = ByteBuffer.wrap(byArray[1]);
        this.theChannel.read(byteBuffer);
        byteBuffer = ByteBuffer.wrap(byArray[2]);
        this.theChannel.read(byteBuffer);
        byte[][] byArray2 = new byte[3][n];
        for (int i = 0; i < 3; ++i) {
            byteBuffer = ByteBuffer.wrap(byArray[i]);
            byteBuffer.order(this.tiffFileOrder);
            for (int j = 0; j < n; ++j) {
                byArray2[i][j] = (byte)(0xFF & byteBuffer.getShort());
            }
        }
        return byArray2;
    }

    private double[] readDoubles(TiffIFDEntry tiffIFDEntry) throws IOException {
        double[] dArray = new double[(int)tiffIFDEntry.count];
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(dArray.length * 8);
        byteBuffer.order(this.tiffFileOrder);
        this.theChannel.position(tiffIFDEntry.asOffset());
        this.theChannel.read(byteBuffer);
        byteBuffer.flip();
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        doubleBuffer.get(dArray);
        return dArray;
    }

    private short[] readShorts(TiffIFDEntry tiffIFDEntry) throws IOException {
        short[] sArray = new short[(int)tiffIFDEntry.count];
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(sArray.length * 2);
        byteBuffer.order(this.tiffFileOrder);
        this.theChannel.position(tiffIFDEntry.asOffset());
        this.theChannel.read(byteBuffer);
        byteBuffer.flip();
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        shortBuffer.get(sArray);
        return sArray;
    }

    private byte[] readBytes(TiffIFDEntry tiffIFDEntry) throws IOException {
        byte[] byArray = new byte[(int)tiffIFDEntry.count];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        this.theChannel.position(tiffIFDEntry.asOffset());
        this.theChannel.read(byteBuffer);
        return byArray;
    }

    private TiffIFDEntry getByTag(TiffIFDEntry[] tiffIFDEntryArray, int n) {
        for (TiffIFDEntry tiffIFDEntry : tiffIFDEntryArray) {
            if (tiffIFDEntry.tag != n) continue;
            return tiffIFDEntry;
        }
        return null;
    }

    private long[] getStripsArray(TiffIFDEntry tiffIFDEntry) throws IOException {
        long[] lArray = new long[(int)tiffIFDEntry.count];
        if (tiffIFDEntry.count == 1L) {
            lArray[0] = tiffIFDEntry.asLong();
        } else {
            long l = tiffIFDEntry.asLong();
            this.theChannel.position(l);
            if (tiffIFDEntry.type == 3) {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(lArray.length * 2);
                this.theChannel.read(byteBuffer);
                byteBuffer.order(this.tiffFileOrder).flip();
                int n = 0;
                while ((long)n < tiffIFDEntry.count) {
                    lArray[n] = this.getUnsignedShort(byteBuffer);
                    ++n;
                }
            } else {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(lArray.length * 4);
                this.theChannel.read(byteBuffer);
                byteBuffer.order(this.tiffFileOrder).flip();
                int n = 0;
                while ((long)n < tiffIFDEntry.count) {
                    lArray[n] = this.getUnsignedInt(byteBuffer);
                    ++n;
                }
            }
        }
        return lArray;
    }

    private int[] getBitsPerSample(TiffIFDEntry tiffIFDEntry) throws IOException {
        if (tiffIFDEntry == null) {
            return new int[]{1};
        }
        if (tiffIFDEntry.count == 1L) {
            return new int[]{(int)tiffIFDEntry.asLong()};
        }
        long[] lArray = this.getStripsArray(tiffIFDEntry);
        int[] nArray = new int[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            nArray[i] = (int)lArray[i];
        }
        return nArray;
    }

    private void checkImageIndex(int n) throws IOException {
        if (n < 0 || n >= this.getNumImages()) {
            String string = Logging.getMessage("GeotiffReader.BadImageIndex", n, 0, this.getNumImages());
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    private int getUnsignedShort(ByteBuffer byteBuffer) {
        return 0xFFFF & byteBuffer.getShort();
    }

    private long getUnsignedInt(ByteBuffer byteBuffer) {
        return 0xFFFFFFFFFFFFFFFFL & (long)byteBuffer.getInt();
    }

    protected void finalize() throws Throwable {
        try {
            this.sourceFile.close();
            super.finalize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

