/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

import gov.nasa.worldwind.formats.tiff.TiffIFDEntry;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeotiffWriter {
    private RandomAccessFile targetFile;
    private FileChannel theChannel;
    private static final int DOUBLE_SIZEOF = 8;
    private static final int FLOAT_SIZEOF = 4;
    private static final int INTEGER_SIZEOF = 4;
    private static final int SHORT_SIZEOF = 2;

    public GeotiffWriter(String string) throws IOException {
        this.commonInitializer(string);
    }

    public GeotiffWriter(File file) throws IOException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.commonInitializer(file.getAbsolutePath());
    }

    private void commonInitializer(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.getParentFile().canWrite()) {
            String string3 = Logging.getMessage("GeotiffWriter.BadFile", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        this.targetFile = new RandomAccessFile(string, "rw");
        this.theChannel = this.targetFile.getChannel();
    }

    public void close() {
        try {
            this.targetFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void write(BufferedImage bufferedImage) throws IOException {
        if (bufferedImage == null) {
            String string = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        int n = bufferedImage.getType();
        if (n == 5 || n == 6 || n == 7 || n == 1 || n == 4 || n == 2 || n == 3) {
            this.writeColorImage(bufferedImage);
        } else if (n == 10) {
            this.writeGrayscaleImage(bufferedImage);
        } else {
            String string = Logging.getMessage("GeotiffWriter.UnsupportedType", n);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
    }

    private void writeColorImage(BufferedImage bufferedImage) throws IOException {
        int n;
        int n2;
        Object[] objectArray;
        int n3 = bufferedImage.getRaster().getNumBands();
        this.writeHeader();
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage.getWidth();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5 * n3);
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < n4; ++i) {
            nArray2[i] = (int)this.theChannel.position();
            nArray[i] = n5 * n3;
            objectArray = writableRaster.getPixels(0, i, bufferedImage.getWidth(), 1, (int[])null);
            byteBuffer.clear();
            for (n2 = 0; n2 < n5 * n3; ++n2) {
                this.putUnsignedByte(byteBuffer, objectArray[n2]);
            }
            byteBuffer.flip();
            this.theChannel.write(byteBuffer);
        }
        ArrayList<TiffIFDEntry> arrayList = new ArrayList<TiffIFDEntry>(10);
        arrayList.add(new TiffIFDEntry(256, 4, 1L, n5));
        arrayList.add(new TiffIFDEntry(257, 4, 1L, n4));
        objectArray = new byte[n3 * 2];
        for (n2 = 0; n2 < n3 * 2; ++n2) {
            objectArray[n2] = n2 % 2 == 0 ? 0 : 8;
        }
        ByteBuffer byteBuffer2 = ByteBuffer.wrap((byte[])objectArray);
        long l = this.theChannel.position();
        this.theChannel.write(byteBuffer2);
        arrayList.add(new TiffIFDEntry(258, 3, n3, l));
        arrayList.add(new TiffIFDEntry(259, 4, 1L, 1L));
        arrayList.add(new TiffIFDEntry(262, 3, 1L, 2L));
        l = this.theChannel.position();
        byteBuffer = ByteBuffer.allocateDirect(nArray2.length * 4);
        for (n = 0; n < nArray2.length; ++n) {
            byteBuffer.putInt(nArray2[n]);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(273, 4, nArray2.length, (int)l));
        arrayList.add(new TiffIFDEntry(277, 3, 1L, n3));
        arrayList.add(new TiffIFDEntry(278, 4, 1L, 1L));
        l = this.theChannel.position();
        byteBuffer.clear();
        for (n = 0; n < nArray.length; ++n) {
            byteBuffer.putInt(nArray[n]);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(279, 4, nArray.length, (int)l));
        arrayList.add(new TiffIFDEntry(284, 3, 1L, 1L));
        this.writeIFDs(arrayList);
    }

    private void writeGrayscaleImage(BufferedImage bufferedImage) throws IOException {
        int n;
        int n2 = 1;
        this.writeHeader();
        int n3 = bufferedImage.getHeight();
        int n4 = bufferedImage.getWidth();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n4 * n2);
        WritableRaster writableRaster = bufferedImage.getRaster();
        for (int i = 0; i < n3; ++i) {
            nArray2[i] = (int)this.theChannel.position();
            nArray[i] = n4 * n2;
            int[] nArray3 = writableRaster.getPixels(0, i, bufferedImage.getWidth(), 1, (int[])null);
            byteBuffer.clear();
            for (int j = 0; j < n4 * n2; ++j) {
                this.putUnsignedByte(byteBuffer, nArray3[j]);
            }
            byteBuffer.flip();
            this.theChannel.write(byteBuffer);
        }
        ArrayList<TiffIFDEntry> arrayList = new ArrayList<TiffIFDEntry>(10);
        arrayList.add(new TiffIFDEntry(256, 4, 1L, n4));
        arrayList.add(new TiffIFDEntry(257, 4, 1L, n3));
        arrayList.add(new TiffIFDEntry(258, 3, n2, 8L));
        arrayList.add(new TiffIFDEntry(259, 4, 1L, 1L));
        arrayList.add(new TiffIFDEntry(262, 3, 1L, 1L));
        long l = this.theChannel.position();
        byteBuffer = ByteBuffer.allocateDirect(nArray2.length * 4);
        for (n = 0; n < nArray2.length; ++n) {
            byteBuffer.putInt(nArray2[n]);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(273, 4, nArray2.length, (int)l));
        arrayList.add(new TiffIFDEntry(277, 3, 1L, n2));
        arrayList.add(new TiffIFDEntry(278, 4, 1L, 1L));
        l = this.theChannel.position();
        byteBuffer.clear();
        for (n = 0; n < nArray.length; ++n) {
            byteBuffer.putInt(nArray[n]);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        arrayList.add(new TiffIFDEntry(279, 4, nArray.length, (int)l));
        this.writeIFDs(arrayList);
    }

    private void writeHeader() throws IOException {
        byte[] byArray = new byte[8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putShort((short)19789);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)42);
        byteBuffer.putInt(0);
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
    }

    private void writeIFDs(ArrayList<TiffIFDEntry> arrayList) throws IOException {
        long l;
        long l2;
        this.theChannel.position(l += (l2 = (l = this.theChannel.position()) % 4L) == 0L ? 0L : 4L - l2);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(arrayList.size() * 12);
        this.putUnsignedShort(byteBuffer, arrayList.size());
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        byteBuffer.clear();
        for (TiffIFDEntry tiffIFDEntry : arrayList) {
            this.putUnsignedShort(byteBuffer, tiffIFDEntry.tag);
            this.putUnsignedShort(byteBuffer, tiffIFDEntry.type);
            this.putUnsignedInt(byteBuffer, tiffIFDEntry.count);
            if (tiffIFDEntry.type == 3 && tiffIFDEntry.count == 1L) {
                this.putUnsignedShort(byteBuffer, (int)tiffIFDEntry.valOffset);
                byteBuffer.putShort((short)0);
                continue;
            }
            this.putUnsignedInt(byteBuffer, tiffIFDEntry.valOffset);
        }
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        byteBuffer.clear();
        byteBuffer.putInt(0);
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
        this.theChannel.position(4L);
        byteBuffer.clear();
        this.putUnsignedInt(byteBuffer, l);
        byteBuffer.flip();
        this.theChannel.write(byteBuffer);
    }

    private void putUnsignedByte(ByteBuffer byteBuffer, int n) {
        byteBuffer.put((byte)(n & 0xFF));
    }

    private void putUnsignedShort(ByteBuffer byteBuffer, int n) {
        byteBuffer.putShort((short)(n & 0xFFFF));
    }

    private void putUnsignedInt(ByteBuffer byteBuffer, long l) {
        byteBuffer.putInt((int)(l & 0xFFFFFFFFL));
    }
}

