/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.tiff;

public class TiffIFDEntry {
    int tag;
    int type;
    long count;
    long valOffset;

    public TiffIFDEntry(int n, int n2, long l, long l2) throws IllegalArgumentException {
        this.tag = n;
        this.type = n2;
        this.count = l;
        this.valOffset = l2;
    }

    public long asLong() throws IllegalStateException {
        if (this.type != 3 && this.type != 4) {
            throw new IllegalStateException("Attempt to access Tiff IFD-entry as int: tag/type=" + Long.toHexString(this.tag) + "/" + this.type);
        }
        if (this.type == 3 && this.count == 1L) {
            return this.valOffset >> 16;
        }
        return this.valOffset;
    }

    public long asOffset() {
        return this.valOffset;
    }
}

