/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.worldfile;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.coords.UTMCoord;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWIO;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.util.Locale;
import java.util.Scanner;
import java.util.regex.MatchResult;

public class WorldFile {
    public static final String WORLD_FILE_X_PIXEL_SIZE = "gov.nasa.worldwind.worldFile.XPixelSize";
    public static final String WORLD_FILE_Y_PIXEL_SIZE = "gov.nasa.worldwind.worldFile.YPixelSize";
    public static final String WORLD_FILE_X_COEFFICIENT = "gov.nasa.worldwind.worldFile.XCoefficient";
    public static final String WORLD_FILE_Y_COEFFICIENT = "gov.nasa.worldwind.worldFile.YCoefficient";
    public static final String WORLD_FILE_X_LOCATION = "gov.nasa.worldwind.worldFile.XLocation";
    public static final String WORLD_FILE_Y_LOCATION = "gov.nasa.worldwind.worldFile.YLocation";
    public static final String WORLD_FILE_IMAGE_SIZE = "gov.nasa.worldwind.worldFile.ImageSize";
    public static final String WORLD_FILE_PROJECTION = "gov.nasa.worldwind.worldFile.Projection";
    public static final String WORLD_FILE_ZONE = "gov.nasa.worldwind.worldFile.Zone";
    public static final String WORLD_FILE_HEMISPHERE = "gov.nasa.worldwind.worldFile.Hemisphere";
    private static final String[] patterns = new String[]{"PROJCS\\[.*UTM\\s+[zZ][oO][nN][eE]\\s+(\\d{1,2})([nNsS])", "PROJCS\\[.*UTM\\s+[zZ][oO][nN][eE]\\s+(\\d{1,2}),\\s+([nNsS])"};

    public static File[] getWorldFiles(File file) throws FileNotFoundException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        File file2 = file.getParentFile();
        final String string = WWIO.getSuffix(file.getPath());
        final String string2 = WWIO.replaceSuffix(file.getName(), "");
        return file2.listFiles(new FilenameFilter(){

            public boolean accept(File file, String string3) {
                int n = string2.length() + 4;
                if (!string3.startsWith(string2) || string3.length() != n) {
                    return false;
                }
                if (string3.toLowerCase().endsWith("w")) {
                    String string22 = WWIO.getSuffix(string3);
                    if (string != null && string22 != null && string22.substring(0, 1).equalsIgnoreCase(string.substring(0, 1)) && string.toLowerCase().endsWith(string22.substring(1, 2))) {
                        return true;
                    }
                }
                return string3.toLowerCase().endsWith(".hdr") || string3.toLowerCase().endsWith(".prj");
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static AVList decodeWorldFiles(File[] fileArray, AVList aVList) throws FileNotFoundException {
        if (fileArray == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        for (File file : fileArray) {
            if (file.exists()) continue;
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        for (File file : fileArray) {
            if (file.getName().toLowerCase().endsWith("w")) {
                WorldFile.scanWorldFile(file, aVList);
                continue;
            }
            if (file.getName().toLowerCase().endsWith(".hdr")) {
                WorldFile.scanHdrFile(file, aVList);
                continue;
            }
            if (!file.getName().toLowerCase().endsWith(".prj")) continue;
            WorldFile.scanPrjFile(file, aVList);
        }
        Object object = aVList.getValue(WORLD_FILE_IMAGE_SIZE);
        if (object != null && object instanceof int[]) {
            int[] nArray = (int[])object;
        } else {
            int[] nArray = WorldFile.parseSize(aVList);
            if (nArray != null) {
                aVList.setValue(WORLD_FILE_IMAGE_SIZE, nArray);
            }
        }
        object = WorldFile.parseByteOrder(aVList);
        if (object != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.ByteOrder", object);
        }
        if ((object = WorldFile.parsePixelFormat(aVList)) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelFormat", object);
        }
        if ((object = WorldFile.parsePixelType(aVList)) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.PixelType", object);
        }
        if ((object = WorldFile.parseMissingDataValue(aVList)) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.MissingDataValue", object);
        }
        Sector sector = null;
        if (WorldFile.worldFileValuesAppearGeographic(aVList)) {
            void var2_7;
            if (var2_7 != null) {
                sector = WorldFile.parseDegrees(aVList, (int)var2_7[0], (int)var2_7[1]);
            } else {
                BufferedImage bufferedImage = (BufferedImage)aVList.getValue("gov.nasa.worldwind.avkey.Image");
                if (bufferedImage != null) {
                    sector = WorldFile.parseDegrees(aVList, bufferedImage.getWidth(), bufferedImage.getHeight());
                }
            }
            if (sector != null) {
                aVList.setValue("gov.nasa.worldwind.avKey.Sector", sector);
            }
        }
        return aVList;
    }

    private static void scanWorldFile(File file, AVList aVList) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useLocale(Locale.US);
        for (int i = 0; i < 6; ++i) {
            if (scanner.hasNextDouble()) {
                switch (i) {
                    case 0: {
                        aVList.setValue(WORLD_FILE_X_PIXEL_SIZE, scanner.nextDouble());
                        break;
                    }
                    case 1: {
                        aVList.setValue(WORLD_FILE_Y_COEFFICIENT, scanner.nextDouble());
                        break;
                    }
                    case 2: {
                        aVList.setValue(WORLD_FILE_X_COEFFICIENT, scanner.nextDouble());
                        break;
                    }
                    case 3: {
                        aVList.setValue(WORLD_FILE_Y_PIXEL_SIZE, scanner.nextDouble());
                        break;
                    }
                    case 4: {
                        aVList.setValue(WORLD_FILE_X_LOCATION, scanner.nextDouble());
                        break;
                    }
                    case 5: {
                        aVList.setValue(WORLD_FILE_Y_LOCATION, scanner.nextDouble());
                    }
                }
                continue;
            }
            String string = Logging.getMessage("SurfaceImage.WorldFileLineMissing", i + 1);
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
    }

    private static void scanHdrFile(File file, AVList aVList) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useLocale(Locale.US);
        while (scanner.hasNext()) {
            String string = scanner.next();
            if (!scanner.hasNext()) {
                return;
            }
            if (string.equalsIgnoreCase("NROWS")) {
                aVList.setValue(string, scanner.nextInt());
                continue;
            }
            if (string.equalsIgnoreCase("NCOLS")) {
                aVList.setValue(string, scanner.nextInt());
                continue;
            }
            if (string.equalsIgnoreCase("NBANDS")) {
                aVList.setValue(string, scanner.nextInt());
                continue;
            }
            if (string.equalsIgnoreCase("NBITS")) {
                aVList.setValue(string, scanner.nextInt());
                continue;
            }
            if (string.equalsIgnoreCase("NODATA")) {
                aVList.setValue(string, scanner.nextDouble());
                continue;
            }
            if (string.equalsIgnoreCase("ULXMAP")) {
                aVList.setValue(string, scanner.nextDouble());
                continue;
            }
            if (string.equalsIgnoreCase("ULYMAP")) {
                aVList.setValue(string, scanner.nextDouble());
                continue;
            }
            if (string.equalsIgnoreCase("XDIM")) {
                aVList.setValue(string, scanner.nextDouble());
                continue;
            }
            if (string.equalsIgnoreCase("YDIM")) {
                aVList.setValue(string, scanner.nextDouble());
                continue;
            }
            aVList.setValue(string, scanner.next());
        }
    }

    private static void scanPrjFile(File file, AVList aVList) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useLocale(Locale.US);
        for (String string : patterns) {
            try {
                scanner.findInLine(string);
                MatchResult matchResult = scanner.match();
                if (matchResult == null || matchResult.groupCount() != 2) continue;
                aVList.setValue(WORLD_FILE_PROJECTION, "UTM");
                aVList.setValue(WORLD_FILE_ZONE, matchResult.group(1));
                aVList.setValue(WORLD_FILE_HEMISPHERE, matchResult.group(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static double[] decodeWorldFile(File file) throws FileNotFoundException {
        if (file == null) {
            String string = Logging.getMessage("nullValue.FileIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!file.exists()) {
            String string = Logging.getMessage("generic.FileNotFound", file.getPath());
            Logging.logger().severe(string);
            throw new FileNotFoundException(string);
        }
        Scanner scanner = new Scanner(file);
        scanner.useLocale(Locale.US);
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            if (!scanner.hasNextDouble()) {
                String string = Logging.getMessage("SurfaceImage.WorldFileLineMissing", i + 1);
                Logging.logger().severe(string);
                throw new IllegalStateException(string);
            }
            dArray[i] = scanner.nextDouble();
        }
        return dArray;
    }

    public static boolean worldFileValuesAppearGeographic(AVList aVList) {
        Object object = aVList.getValue(WORLD_FILE_X_LOCATION);
        if (object == null || !(object instanceof Double)) {
            return false;
        }
        double d = (Double)object;
        object = aVList.getValue(WORLD_FILE_Y_LOCATION);
        if (object == null || !(object instanceof Double)) {
            return false;
        }
        double d2 = (Double)object;
        object = aVList.getValue(WORLD_FILE_X_PIXEL_SIZE);
        if (object == null || !(object instanceof Double)) {
            return false;
        }
        double d3 = (Double)object;
        object = aVList.getValue(WORLD_FILE_Y_PIXEL_SIZE);
        if (object == null || !(object instanceof Double)) {
            return false;
        }
        double d4 = (Double)object;
        return Angle.isValidLongitude(d3) && Angle.isValidLatitude(d4) && Angle.isValidLongitude(d) && Angle.isValidLatitude(d2);
    }

    public static int[] parseSize(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (!aVList.hasKey("NROWS") && !aVList.hasKey("NCOLS")) {
            return null;
        }
        return new int[]{(Integer)aVList.getValue("NCOLS"), (Integer)aVList.getValue("NROWS")};
    }

    public static Object parseByteOrder(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (!aVList.hasKey("BYTEORDER")) {
            return null;
        }
        String string = aVList.getValue("BYTEORDER").toString();
        return string.startsWith("I") || string.startsWith("i") ? "gov.nasa.worldwind.avkey.LittleEndian" : "gov.nasa.worldwind.avkey.BigEndian";
    }

    public static Object parsePixelFormat(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (!aVList.hasKey("NBANDS") || !aVList.hasKey("NBITS")) {
            return null;
        }
        Integer n = (Integer)aVList.getValue("NBANDS");
        Integer n2 = (Integer)aVList.getValue("NBITS");
        String string = null;
        if (n == 1 && (n2 == 16 || n2 == 32)) {
            string = "gov.nasa.worldwind.avkey.Elevation";
        }
        return string;
    }

    public static Object parsePixelType(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (!aVList.hasKey("NBITS")) {
            return null;
        }
        Integer n = (Integer)aVList.getValue("NBITS");
        String string = null;
        if (n == 8) {
            string = "gov.nasa.worldwind.avkey.Int8";
        } else if (n == 16) {
            string = "gov.nasa.worldwind.avkey.Int16";
        } else if (n == 32) {
            string = "gov.nasa.worldwind.avkey.Float32";
        }
        return string;
    }

    public static Object parseMissingDataValue(AVList aVList) {
        if (aVList == null) {
            return null;
        }
        if (!aVList.hasKey("NODATA")) {
            return null;
        }
        return aVList.getValue("NODATA");
    }

    public static Sector parseDegrees(AVList aVList, int n, int n2) {
        Angle angle;
        Angle angle2;
        Angle angle3;
        Angle angle4;
        if (aVList == null) {
            String string = Logging.getMessage("nullValue.ArrayIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n <= 0 || n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidImageSize");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Angle angle5 = Angle.fromDegrees((Double)aVList.getValue(WORLD_FILE_Y_LOCATION));
        double d = (Double)aVList.getValue(WORLD_FILE_Y_PIXEL_SIZE);
        Angle angle6 = angle5.addDegrees((d <= 0.0 ? d : -d) * (double)n2);
        Angle angle7 = Angle.fromDegrees((Double)aVList.getValue(WORLD_FILE_X_LOCATION));
        Angle angle8 = angle7.addDegrees((Double)aVList.getValue(WORLD_FILE_X_PIXEL_SIZE) * (double)n);
        if (angle7.degrees < angle8.degrees) {
            angle4 = angle7;
            angle3 = angle8;
        } else {
            angle4 = angle8;
            angle3 = angle7;
        }
        if (angle5.degrees < angle6.degrees) {
            angle2 = angle5;
            angle = angle6;
        } else {
            angle2 = angle6;
            angle = angle5;
        }
        Sector sector = new Sector(angle2, angle, angle4, angle3);
        if (!sector.isWithinLatLonLimits()) {
            String string = Logging.getMessage("generic.SectorNotGeographic");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return sector;
    }

    public static Sector parseUTM(double[] dArray, int n, int n2, int n3, char c) {
        if (dArray.length < 6) {
            String string = Logging.getMessage("WorldFile.TooFewWorldFileValues");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n <= 0 || n2 <= 0) {
            String string = Logging.getMessage("generic.InvalidImageSize");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (n3 < 1 || n3 > 60) {
            String string = Logging.getMessage("WorldFile.InvalidUTMZone", n3);
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if ("SNsn".indexOf(c) == -1) {
            String string = Logging.getMessage("WorldFile.InvalidUTMHemisphere", Character.valueOf(c));
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        double d7 = d5;
        double d8 = d6;
        double d9 = d * (double)(n - 1) + d3 * (double)(n2 - 1) + d7;
        double d10 = d2 * (double)(n - 1) + d4 * (double)(n2 - 1) + d8;
        UTMCoord uTMCoord = UTMCoord.fromUTM(n3, c, d7, d8);
        UTMCoord uTMCoord2 = UTMCoord.fromUTM(n3, c, d9, d10);
        Sector sector = new Sector(uTMCoord2.getLatitude(), uTMCoord.getLatitude(), uTMCoord.getLongitude(), uTMCoord2.getLongitude());
        if (!sector.isWithinLatLonLimits()) {
            String string = Logging.getMessage("generic.SectorNotGeographic");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        return sector;
    }
}

