/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.coords.UPSCoordConverter;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class UPSCoord {
    private final Angle latitude;
    private final Angle longitude;
    private final char hemisphere;
    private final double easting;
    private final double northing;

    public static UPSCoord fromLatLon(Angle angle, Angle angle2) {
        return UPSCoord.fromLatLon(angle, angle2, null);
    }

    public static UPSCoord fromLatLon(Angle angle, Angle angle2, Globe globe) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        UPSCoordConverter uPSCoordConverter = new UPSCoordConverter(globe);
        long l = uPSCoordConverter.convertGeodeticToUPS(angle.radians, angle2.radians);
        if (l != 0L) {
            String string = Logging.getMessage("Coord.UPSConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new UPSCoord(angle, angle2, uPSCoordConverter.getHemisphere(), uPSCoordConverter.getEasting(), uPSCoordConverter.getNorthing());
    }

    public static UPSCoord fromUTM(char c, double d, double d2) {
        return UPSCoord.fromUPS(c, d, d2, null);
    }

    public static UPSCoord fromUPS(char c, double d, double d2, Globe globe) {
        UPSCoordConverter uPSCoordConverter = new UPSCoordConverter(globe);
        long l = uPSCoordConverter.convertUPSToGeodetic(c, d, d2);
        if (l != 0L) {
            String string = Logging.getMessage("Coord.UTMConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new UPSCoord(Angle.fromRadians(uPSCoordConverter.getLatitude()), Angle.fromRadians(uPSCoordConverter.getLongitude()), c, d, d2);
    }

    public UPSCoord(Angle angle, Angle angle2, char c, double d, double d2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.hemisphere = c;
        this.easting = d;
        this.northing = d2;
    }

    public Angle getLatitude() {
        return this.latitude;
    }

    public Angle getLongitude() {
        return this.longitude;
    }

    public char getHemisphere() {
        return this.hemisphere;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public String toString() {
        return this.hemisphere + " " + (int)this.easting + "E" + " " + (int)this.northing + "N";
    }
}

