/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWind;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Triangle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.terrain.SectorGeometryList;
import gov.nasa.worldwind.terrain.Tessellator;
import gov.nasa.worldwind.util.Logging;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EllipsoidalGlobe
extends WWObjectImpl
implements Globe {
    protected final double equatorialRadius;
    protected final double polarRadius;
    protected final double es;
    private final Vec4 center;
    private ElevationModel elevationModel;
    private Tessellator tessellator;

    public EllipsoidalGlobe(double d, double d2, double d3, ElevationModel elevationModel) {
        this.equatorialRadius = d;
        this.polarRadius = d2;
        this.es = d3;
        this.center = Vec4.ZERO;
        this.elevationModel = elevationModel;
        this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
    }

    public EllipsoidalGlobe(double d, double d2, double d3, ElevationModel elevationModel, Vec4 vec4) {
        this.equatorialRadius = d;
        this.polarRadius = d2;
        this.es = d3;
        this.center = vec4;
        this.elevationModel = elevationModel;
        this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
    }

    @Override
    public Object getStateKey(DrawContext drawContext) {
        return new StateKey(drawContext);
    }

    @Override
    public Tessellator getTessellator() {
        return this.tessellator;
    }

    @Override
    public void setTessellator(Tessellator tessellator) {
        this.tessellator = tessellator;
    }

    @Override
    public ElevationModel getElevationModel() {
        return this.elevationModel;
    }

    @Override
    public void setElevationModel(ElevationModel elevationModel) {
        this.elevationModel = elevationModel;
    }

    @Override
    public double getRadius() {
        return this.equatorialRadius;
    }

    @Override
    public double getEquatorialRadius() {
        return this.equatorialRadius;
    }

    @Override
    public double getPolarRadius() {
        return this.polarRadius;
    }

    @Override
    public double getMaximumRadius() {
        return this.equatorialRadius;
    }

    @Override
    public double getRadiusAt(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computePointFromPosition(angle, angle2, 0.0).getLength3();
    }

    @Override
    public double getRadiusAt(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), 0.0).getLength3();
    }

    @Override
    public double getEccentricitySquared() {
        return this.es;
    }

    @Override
    public double getDiameter() {
        return this.equatorialRadius * 2.0;
    }

    @Override
    public Vec4 getCenter() {
        return this.center;
    }

    @Override
    public double getMaxElevation() {
        return this.elevationModel != null ? this.elevationModel.getMaxElevation() : 0.0;
    }

    @Override
    public double getMinElevation() {
        return this.elevationModel != null ? this.elevationModel.getMinElevation() : 0.0;
    }

    @Override
    public double[] getMinAndMaxElevations(Sector sector) {
        double[] dArray;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.elevationModel != null) {
            dArray = this.elevationModel.getExtremeElevations(sector);
        } else {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        }
        return dArray;
    }

    @Override
    public Extent getExtent() {
        return this;
    }

    @Override
    public boolean intersects(Frustum frustum) {
        if (frustum == null) {
            String string = Logging.getMessage("nullValue.FrustumIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return frustum.intersects(this);
    }

    @Override
    public Intersection[] intersect(Line line) {
        return this.intersect(line, this.equatorialRadius, this.polarRadius);
    }

    @Override
    public Intersection[] intersect(Line line, double d) {
        return this.intersect(line, this.equatorialRadius + d, this.polarRadius + d);
    }

    protected Intersection[] intersect(Line line, double d, double d2) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d3 = line.getDirection().x;
        double d4 = d / d2;
        double d5 = d4 * d4;
        double d6 = line.getDirection().y;
        double d7 = 1.0;
        double d8 = d7 * d7;
        double d9 = line.getDirection().z;
        double d10 = d3 * d3 + d5 * d6 * d6 + d8 * d9 * d9;
        double d11 = line.getOrigin().x;
        double d12 = line.getOrigin().y;
        double d13 = line.getOrigin().z;
        double d14 = 2.0 * (d11 * d3 + d5 * d12 * d6 + d8 * d13 * d9);
        double d15 = d * d;
        double d16 = d11 * d11 + d5 * d12 * d12 + d8 * d13 * d13 - d15;
        double d17 = EllipsoidalGlobe.discriminant(d10, d14, d16);
        if (d17 < 0.0) {
            return null;
        }
        double d18 = Math.sqrt(d17);
        if (d17 == 0.0) {
            Vec4 vec4 = line.getPointAt((-d14 - d18) / (2.0 * d10));
            return new Intersection[]{new Intersection(vec4, true)};
        }
        Vec4 vec4 = line.getPointAt((-d14 - d18) / (2.0 * d10));
        Vec4 vec42 = line.getPointAt((-d14 + d18) / (2.0 * d10));
        if (d16 >= 0.0) {
            return new Intersection[]{new Intersection(vec4, false), new Intersection(vec42, false)};
        }
        return new Intersection[]{new Intersection(vec42, false)};
    }

    private static double discriminant(double d, double d2, double d3) {
        return d2 * d2 - 4.0 * d * d3;
    }

    @Override
    public Intersection[] intersect(Triangle triangle, double d) {
        if (triangle == null) {
            String string = Logging.getMessage("nullValue.TriangleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        boolean bl = this.isPointAboveElevation(triangle.getA(), d);
        boolean bl2 = this.isPointAboveElevation(triangle.getB(), d);
        boolean bl3 = this.isPointAboveElevation(triangle.getC(), d);
        if (!(bl ^ bl2) && !(bl2 ^ bl3)) {
            return null;
        }
        Intersection[] intersectionArray = new Intersection[2];
        int n = 0;
        if (bl ^ bl2) {
            intersectionArray[n++] = bl ? this.intersect(new Line(triangle.getB(), triangle.getA().subtract3(triangle.getB())), d)[0] : this.intersect(new Line(triangle.getA(), triangle.getB().subtract3(triangle.getA())), d)[0];
        }
        if (bl2 ^ bl3) {
            intersectionArray[n++] = bl2 ? this.intersect(new Line(triangle.getC(), triangle.getB().subtract3(triangle.getC())), d)[0] : this.intersect(new Line(triangle.getB(), triangle.getC().subtract3(triangle.getB())), d)[0];
        }
        if (bl3 ^ bl) {
            intersectionArray[n] = bl3 ? this.intersect(new Line(triangle.getA(), triangle.getC().subtract3(triangle.getA())), d)[0] : this.intersect(new Line(triangle.getC(), triangle.getA().subtract3(triangle.getC())), d)[0];
        }
        return intersectionArray;
    }

    @Override
    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return line.distanceTo(this.center) <= this.equatorialRadius;
    }

    @Override
    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = plane.dot(this.center);
        return d <= this.equatorialRadius;
    }

    @Override
    public double getElevations(Sector sector, List<? extends LatLon> list, double d, double[] dArray) {
        return this.elevationModel != null ? this.elevationModel.getElevations(sector, list, d, dArray) : 0.0;
    }

    @Override
    public double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.elevationModel != null ? this.elevationModel.getElevation(angle, angle2) : 0.0;
    }

    @Override
    public Vec4 computePointFromPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    @Override
    public Vec4 computePointFromPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.geodeticToCartesian(angle, angle2, d);
    }

    @Override
    public Position computePositionFromPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.cartesianToGeodetic(vec4);
    }

    @Override
    public Vec4 computeSurfaceNormalAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = angle.cos();
        double d2 = angle2.cos();
        double d3 = angle.sin();
        double d4 = angle2.sin();
        double d5 = this.equatorialRadius * this.equatorialRadius;
        double d6 = this.polarRadius * this.polarRadius;
        double d7 = d * d4 / d5;
        double d8 = (1.0 - this.es) * d3 / d6;
        double d9 = d * d2 / d5;
        return new Vec4(d7, d8, d9).normalize3();
    }

    @Override
    public Vec4 computeSurfaceNormalAtPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = this.equatorialRadius * this.equatorialRadius;
        double d2 = this.polarRadius * this.polarRadius;
        double d3 = (vec4.x - this.center.x) / d;
        double d4 = (vec4.y - this.center.y) / d2;
        double d5 = (vec4.z - this.center.z) / d;
        return new Vec4(d3, d4, d5).normalize3();
    }

    @Override
    public Vec4 computeNorthPointingTangentAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        angle = angle.multiply(-1.0);
        double d = angle.cos();
        double d2 = angle.sin();
        double d3 = angle2.cos();
        double d4 = angle2.sin();
        double d5 = d2 * d4;
        double d6 = d;
        double d7 = d2 * d3;
        return new Vec4(d5, d6, d7).normalize3();
    }

    @Override
    public Matrix computeTransformToPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.geodeticToCartesian(angle, angle2, d);
        Matrix matrix = Matrix.fromTranslation(vec4);
        matrix = matrix.multiply(Matrix.fromRotationY(angle2));
        matrix = matrix.multiply(Matrix.fromRotationX(angle.multiply(-1.0)));
        return matrix;
    }

    @Override
    public Matrix computeTransformToPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeTransformToPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    @Override
    public Position getIntersectionPosition(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Intersection[] intersectionArray = this.intersect(line);
        if (intersectionArray == null) {
            return null;
        }
        return this.computePositionFromPoint(intersectionArray[0].getIntersectionPoint());
    }

    protected Vec4 geodeticToCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d2 = angle.cos();
        double d3 = angle.sin();
        double d4 = angle2.cos();
        double d5 = angle2.sin();
        double d6 = this.equatorialRadius / Math.sqrt(1.0 - this.es * d3 * d3);
        double d7 = (d6 + d) * d2 * d5;
        double d8 = (d6 * (1.0 - this.es) + d) * d3;
        double d9 = (d6 + d) * d2 * d4;
        return new Vec4(d7, d8, d9);
    }

    protected Position cartesianToGeodetic(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d = 1.0 / (this.equatorialRadius * this.equatorialRadius);
        double d2 = vec4.z;
        double d3 = vec4.x;
        double d4 = vec4.y;
        double d5 = this.es;
        double d6 = d5 * d5;
        double d7 = d2 * d2 + d3 * d3;
        double d8 = Math.sqrt(d7);
        double d9 = d7 * d;
        double d10 = d4 * d4 * (1.0 - d5) * d;
        double d11 = 0.16666666666666666 * (d9 + d10 - d6);
        double d12 = d6 * d9 * d10 / (4.0 * d11 * d11 * d11);
        double d13 = Math.pow(1.0 + d12 + Math.sqrt(d12 * (2.0 + d12)), 0.3333333333333333);
        double d14 = d11 * (1.0 + d13 + 1.0 / d13);
        double d15 = Math.sqrt(d14 * d14 + d6 * d10);
        double d16 = d5 * (d14 + d15 - d10) / (2.0 * d15);
        double d17 = Math.sqrt(d14 + d15 + d16 * d16) - d16;
        double d18 = d17 * d8 / (d17 + d5);
        double d19 = 2.0 * Math.atan2(d3, d2 + d8);
        double d20 = Math.sqrt(d18 * d18 + d4 * d4);
        double d21 = 2.0 * Math.atan2(d4, d18 + d20);
        double d22 = (d17 + d5 - 1.0) * d20 / d17;
        return Position.fromRadians(d21, d19, d22);
    }

    @Override
    public Cylinder computeBoundingCylinder(double d, Sector sector) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double[] dArray = this.getMinAndMaxElevations(sector);
        return this.computeBoundingCylinder(d, sector, dArray[0], dArray[1]);
    }

    @Override
    public Cylinder computeBoundingCylinder(double d, Sector sector, double d2, double d3) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        double d4 = d2 * d;
        double d5 = d3 * d;
        if (sector.getDeltaLatDegrees() >= 180.0 || sector.getDeltaLonDegrees() >= 180.0) {
            return this.computeBoundsFromSectorLatitudeRange(sector, d4, d5);
        }
        return this.computeBoundsFromSectorQuadrilateral(sector, d4, d5);
    }

    @Override
    public SectorGeometryList tessellate(DrawContext drawContext) {
        if (this.tessellator == null) {
            this.tessellator = (Tessellator)WorldWind.createConfigurationComponent("gov.nasa.worldwind.avkey.TessellatorClassName");
        }
        return this.tessellator.tessellate(drawContext);
    }

    @Override
    public boolean isPointAboveElevation(Vec4 vec4, double d) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return vec4.x() * vec4.x() / ((this.equatorialRadius + d) * (this.equatorialRadius + d)) + vec4.y() * vec4.y() / ((this.polarRadius + d) * (this.polarRadius + d)) + vec4.z() * vec4.z() / ((this.equatorialRadius + d) * (this.equatorialRadius + d)) - 1.0 > 0.0;
    }

    protected Cylinder computeBoundsFromSectorQuadrilateral(Sector sector, double d, double d2) {
        Vec4 vec4;
        Vec4 vec42;
        Vec4 vec43;
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (Math.abs(sector.getMinLatitude().degrees) <= Math.abs(sector.getMaxLatitude().degrees)) {
            vec43 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d2);
            vec42 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2);
            vec4 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d2);
        } else {
            vec43 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d2);
            vec42 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d2);
            vec4 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2);
        }
        Vec4[] vec4Array = new Vec4[1];
        Vec4[] vec4Array2 = new Vec4[1];
        double[] dArray = new double[1];
        if (!this.computeCircleThroughPoints(vec43, vec42, vec4, vec4Array, vec4Array2, dArray)) {
            return this.computeBoundsFromSectorVertices(sector, d, d2);
        }
        Vec4 vec44 = vec4Array[0];
        Vec4 vec45 = vec4Array2[0];
        double d3 = dArray[0];
        Vec4 vec46 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d);
        double d4 = vec46.subtract3(vec44).dot3(vec45);
        vec46 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d);
        d4 = Math.min(d4, vec46.subtract3(vec44).dot3(vec45));
        LatLon latLon = sector.getCentroid();
        vec46 = this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d2);
        double d5 = vec46.subtract3(vec44).dot3(vec45);
        Vec4 vec47 = vec45.multiply3(d4).add3(vec44);
        Vec4 vec48 = vec45.multiply3(d5).add3(vec44);
        return new Cylinder(vec47, vec48, d3);
    }

    protected Cylinder computeBoundsFromSectorLatitudeRange(Sector sector, double d, double d2) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = Vec4.ZERO;
        Vec4 vec42 = Vec4.UNIT_Y;
        double d3 = this.getEquatorialRadius() + d2;
        Vec4 vec43 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d2);
        double d4 = vec43.subtract3(vec4).dot3(vec42);
        vec43 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d2);
        double d5 = vec43.subtract3(vec4).dot3(vec42);
        Vec4 vec44 = vec42.multiply3(d4).add3(vec4);
        Vec4 vec45 = vec42.multiply3(d5).add3(vec4);
        return new Cylinder(vec44, vec45, d3);
    }

    protected Cylinder computeBoundsFromSectorVertices(Sector sector, double d, double d2) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        Vec4 vec4 = this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d2);
        Vec4 vec42 = this.computeSurfaceNormalAtPoint(vec4);
        Vec4 vec43 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d);
        Vec4 vec44 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d);
        Vec4 vec45 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d);
        Vec4 vec46 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d);
        double d3 = vec43.subtract3(vec4).dot3(vec42);
        d3 = Math.min(d3, vec44.subtract3(vec4).dot3(vec42));
        d3 = Math.min(d3, vec45.subtract3(vec4).dot3(vec42));
        d3 = Math.min(d3, vec46.subtract3(vec4).dot3(vec42));
        Vec4 vec47 = vec42.multiply3(d3).add3(vec4);
        double d4 = vec4.distanceTo3(vec43);
        d4 = Math.max(d4, vec4.distanceTo3(vec44));
        d4 = Math.max(d4, vec4.distanceTo3(vec45));
        d4 = Math.max(d4, vec4.distanceTo3(vec46));
        return new Cylinder(vec47, vec4, d4);
    }

    private boolean computeCircleThroughPoints(Vec4 vec4, Vec4 vec42, Vec4 vec43, Vec4[] vec4Array, Vec4[] vec4Array2, double[] dArray) {
        if (vec4 == null || vec42 == null || vec43 == null) {
            String string = Logging.getMessage("nullValue.Vec4IsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec44 = vec42.subtract3(vec4);
        Vec4 vec45 = vec43.subtract3(vec42);
        Vec4 vec46 = vec43.subtract3(vec4);
        double d = vec44.dot3(vec46);
        double d2 = -vec44.dot3(vec45);
        double d3 = vec45.dot3(vec46);
        double d4 = d2 + d3;
        double d5 = d + d3;
        double d6 = d + d2;
        double d7 = d * d4;
        double d8 = d2 * d5;
        double d9 = d3 * d6;
        double d10 = Math.max(Math.max(d7, d8), d9);
        double d11 = Math.min(Math.min(d7, d8), d9);
        double d12 = d7 + d8 + d9;
        double d13 = 1.0E-6;
        if (Math.abs(d12) <= d13 * (d10 - d11)) {
            return false;
        }
        double d14 = 0.5 * d4 * d5 * d6 / d12;
        if (d14 < 0.0) {
            return false;
        }
        double d15 = Math.sqrt(d14);
        Vec4 vec47 = vec4.multiply3(d7 / d12);
        vec47 = vec47.add3(vec42.multiply3(d8 / d12));
        vec47 = vec47.add3(vec43.multiply3(d9 / d12));
        Vec4 vec48 = vec46.cross3(vec44);
        vec48 = vec48.normalize3();
        if (vec4Array != null) {
            vec4Array[0] = vec47;
        }
        if (vec4Array2 != null) {
            vec4Array2[0] = vec48;
        }
        if (dArray != null) {
            dArray[0] = d15;
        }
        return true;
    }

    protected class StateKey {
        protected Globe globe;
        protected final Tessellator tessellator;
        protected double verticalExaggeration;

        public StateKey(DrawContext drawContext) {
            this.globe = drawContext.getGlobe();
            this.tessellator = EllipsoidalGlobe.this.tessellator;
            this.verticalExaggeration = drawContext.getVerticalExaggeration();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            StateKey stateKey = (StateKey)object;
            if (Double.compare(stateKey.verticalExaggeration, this.verticalExaggeration) != 0) {
                return false;
            }
            if (this.globe != null ? !this.globe.equals(stateKey.globe) : stateKey.globe != null) {
                return false;
            }
            return !(this.tessellator != null ? !this.tessellator.equals(stateKey.tessellator) : stateKey.tessellator != null);
        }

        public int hashCode() {
            int n = this.globe != null ? this.globe.hashCode() : 0;
            n = 31 * n + (this.tessellator != null ? this.tessellator.hashCode() : 0);
            long l = this.verticalExaggeration != 0.0 ? Double.doubleToLongBits(this.verticalExaggeration) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }
    }
}

