/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.globes;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Matrix;
import gov.nasa.worldwind.geom.Plane;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.ElevationModel;
import gov.nasa.worldwind.globes.EllipsoidalGlobe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;

public class FlatGlobe
extends EllipsoidalGlobe {
    public static final String PROJECTION_LAT_LON = "gov.nasa.worldwind.globes.projectionLatLon";
    public static final String PROJECTION_MERCATOR = "gov.nasa.worldwind.globes.projectionMercator";
    public static final String PROJECTION_SINUSOIDAL = "gov.nasa.worldwind.globes.projectionSinusoidal";
    public static final String PROJECTION_MODIFIED_SINUSOIDAL = "gov.nasa.worldwind.globes.projectionModifiedSinusoidal";
    private String projection = "gov.nasa.worldwind.globes.projectionMercator";

    public FlatGlobe(double d, double d2, double d3, ElevationModel elevationModel) {
        super(d, d2, d3, elevationModel);
    }

    public Object getStateKey(DrawContext drawContext) {
        return new FlatStateKey(drawContext);
    }

    public double getRadiusAt(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getMaximumRadius();
    }

    public double getRadiusAt(LatLon latLon) {
        if (latLon == null) {
            String string = Logging.getMessage("nullValue.LatLonIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.getMaximumRadius();
    }

    public void setProjection(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (this.projection.equals(string)) {
            return;
        }
        this.projection = string;
        this.setTessellator(null);
    }

    public String getProjection() {
        return this.projection;
    }

    protected Intersection[] intersect(Line line, double d, double d2) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Plane plane = new Plane(0.0, 0.0, 1.0, -(d - this.equatorialRadius));
        Vec4 vec4 = plane.intersect(line);
        if (vec4 == null) {
            return null;
        }
        Position position = this.computePositionFromPoint(vec4);
        if (position == null) {
            return null;
        }
        if (position.getLatitude().degrees < -90.0 || position.getLatitude().degrees > 90.0 || position.getLongitude().degrees < -180.0 || position.getLongitude().degrees > 180.0) {
            return null;
        }
        return new Intersection[]{new Intersection(vec4, false)};
    }

    public boolean intersects(Line line) {
        if (line == null) {
            String string = Logging.getMessage("nullValue.LineIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.intersect(line) != null;
    }

    public boolean intersects(Plane plane) {
        if (plane == null) {
            String string = Logging.getMessage("nullValue.PlaneIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return !plane.getNormal().equals(Vec4.UNIT_Z);
    }

    public Vec4 computeSurfaceNormalAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Z;
    }

    public Vec4 computeSurfaceNormalAtPoint(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Z;
    }

    public Vec4 computeNorthPointingTangentAtLocation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return Vec4.UNIT_Y;
    }

    public Matrix computeTransformToPosition(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = this.geodeticToCartesian(angle, angle2, d);
        return Matrix.fromTranslation(vec4);
    }

    public Matrix computeTransformToPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.computeTransformToPosition(position.getLatitude(), position.getLongitude(), position.getElevation());
    }

    public double getElevation(Angle angle, Angle angle2) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (angle.degrees < -90.0 || angle.degrees > 90.0 || angle2.degrees < -180.0 || angle2.degrees > 180.0) {
            return 0.0;
        }
        return super.getElevation(angle, angle2);
    }

    protected Vec4 geodeticToCartesian(Angle angle, Angle angle2, double d) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Vec4 vec4 = null;
        if (this.projection.equals(PROJECTION_LAT_LON)) {
            vec4 = new Vec4(this.equatorialRadius * angle2.radians, this.equatorialRadius * angle.radians, d);
        } else if (this.projection.equals(PROJECTION_MERCATOR)) {
            if (angle.degrees > 75.0) {
                angle = Angle.fromDegrees(75.0);
            }
            if (angle.degrees < -75.0) {
                angle = Angle.fromDegrees(-75.0);
            }
            vec4 = new Vec4(this.equatorialRadius * angle2.radians, this.equatorialRadius * Math.log(Math.tan(0.7853981633974483 + angle.radians / 2.0)), d);
        } else if (this.projection.equals(PROJECTION_SINUSOIDAL)) {
            double d2 = angle.cos();
            vec4 = new Vec4(d2 > 0.0 ? this.equatorialRadius * angle2.radians * angle.cos() : 0.0, this.equatorialRadius * angle.radians, d);
        } else if (this.projection.equals(PROJECTION_MODIFIED_SINUSOIDAL)) {
            double d3 = angle.cos();
            vec4 = new Vec4(d3 > 0.0 ? this.equatorialRadius * angle2.radians * Math.pow(d3, 0.3) : 0.0, this.equatorialRadius * angle.radians, d);
        }
        return vec4;
    }

    protected Position cartesianToGeodetic(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position = null;
        if (this.projection.equals(PROJECTION_LAT_LON)) {
            position = Position.fromRadians(vec4.y / this.equatorialRadius, vec4.x / this.equatorialRadius, vec4.z);
        } else if (this.projection.equals(PROJECTION_MERCATOR)) {
            position = Position.fromRadians(Math.atan(Math.sinh(vec4.y / this.equatorialRadius)), vec4.x / this.equatorialRadius, vec4.z);
        } else if (this.projection.equals(PROJECTION_SINUSOIDAL)) {
            double d = Math.cos(vec4.y / this.equatorialRadius);
            position = Position.fromRadians(vec4.y / this.equatorialRadius, d > 0.0 ? vec4.x / this.equatorialRadius / Angle.fromRadians(d).cos() : 0.0, vec4.z);
        } else if (this.projection.equals(PROJECTION_MODIFIED_SINUSOIDAL)) {
            double d = Math.cos(vec4.y / this.equatorialRadius);
            position = Position.fromRadians(vec4.y / this.equatorialRadius, d > 0.0 ? vec4.x / this.equatorialRadius / Math.pow(d, 0.3) : 0.0, vec4.z);
        }
        return position;
    }

    public Cylinder computeBoundingCylinder(double d, Sector sector, double d2, double d3) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        LatLon latLon = sector.getCentroid();
        double d4 = d2 * d;
        double d5 = d3 * d;
        Vec4 vec4 = this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d5);
        Vec4 vec42 = this.computePointFromPosition(latLon.getLatitude(), latLon.getLongitude(), d4);
        Vec4 vec43 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMinLongitude(), d5);
        Vec4 vec44 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMaxLongitude(), d5);
        Vec4 vec45 = this.computePointFromPosition(sector.getMinLatitude(), sector.getMinLongitude(), d5);
        Vec4 vec46 = this.computePointFromPosition(sector.getMaxLatitude(), sector.getMaxLongitude(), d5);
        double d6 = vec45.distanceTo3(vec42);
        double d7 = vec44.distanceTo3(vec42);
        double d8 = vec46.distanceTo3(vec42);
        double d9 = vec43.distanceTo3(vec42);
        double d10 = Math.max(Math.max(d6, d7), Math.max(d8, d9));
        return new Cylinder(vec42, vec4, d10);
    }

    public boolean isPointAboveElevation(Vec4 vec4, double d) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.PointIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return vec4.z() > d;
    }

    private class FlatStateKey
    extends EllipsoidalGlobe.StateKey {
        protected final String projection;
        protected double verticalExaggeration;

        public FlatStateKey(DrawContext drawContext) {
            super(drawContext);
            this.projection = FlatGlobe.this.projection;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            FlatStateKey flatStateKey = (FlatStateKey)object;
            if (Double.compare(flatStateKey.verticalExaggeration, this.verticalExaggeration) != 0) {
                return false;
            }
            return !(this.projection != null ? !this.projection.equals(flatStateKey.projection) : flatStateKey.projection != null);
        }

        public int hashCode() {
            int n = super.hashCode();
            n = 31 * n + (this.projection != null ? this.projection.hashCode() : 0);
            long l = this.verticalExaggeration != 0.0 ? Double.doubleToLongBits(this.verticalExaggeration) : 0L;
            n = 31 * n + (int)(l ^ l >>> 32);
            return n;
        }
    }
}

