/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.view.OrbitView;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.opengl.GL;

public class CompassLayer
extends AbstractLayer {
    private String iconFilePath = "images/notched-compass.png";
    private double compassToViewportScale = 0.2;
    private double iconScale = 0.5;
    private int borderWidth = 20;
    private String position = "gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast";
    private String resizeBehavior = "gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly";
    private int iconWidth;
    private int iconHeight;
    private Vec4 locationCenter = null;
    private Vec4 locationOffset = null;
    private boolean showTilt = true;
    private PickSupport pickSupport = new PickSupport();
    private OrderedIcon orderedImage = new OrderedIcon();

    public CompassLayer() {
        this.setOpacity(0.8);
        this.setPickEnabled(false);
    }

    public CompassLayer(String string) {
        this.setIconFilePath(string);
        this.setOpacity(0.8);
        this.setPickEnabled(false);
    }

    public String getIconFilePath() {
        return this.iconFilePath;
    }

    public void setIconFilePath(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.IconFilePath");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.iconFilePath = string;
    }

    public double getCompassToViewportScale() {
        return this.compassToViewportScale;
    }

    public void setCompassToViewportScale(double d) {
        this.compassToViewportScale = d;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    public void setIconScale(double d) {
        this.iconScale = d;
    }

    public String getResizeBehavior() {
        return this.resizeBehavior;
    }

    public void setResizeBehavior(String string) {
        this.resizeBehavior = string;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.CompassPositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = string;
    }

    public Vec4 getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Vec4 vec4) {
        this.locationCenter = vec4;
    }

    public Vec4 getLocationOffset() {
        return this.locationOffset;
    }

    public void setLocationOffset(Vec4 vec4) {
        this.locationOffset = vec4;
    }

    protected void doRender(DrawContext drawContext) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    protected void doPick(DrawContext drawContext, Point point) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    public boolean isShowTilt() {
        return this.showTilt;
    }

    public void setShowTilt(boolean bl) {
        this.showTilt = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(DrawContext drawContext) {
        if (this.iconFilePath == null) {
            return;
        }
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            double d;
            gL.glPushAttrib(293121);
            bl = true;
            gL.glDisable(2929);
            double d2 = this.getScaledIconWidth();
            double d3 = this.getScaledIconHeight();
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            double d4 = d = d2 > d3 ? d2 : d3;
            if (d == 0.0) {
                d = 1.0;
            }
            gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -0.6 * d, 0.6 * d);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            double d5 = this.computeScale(rectangle);
            Vec4 vec4 = this.computeLocation(rectangle, d5);
            double d6 = this.computeHeading(drawContext.getView());
            double d7 = this.computePitch(drawContext.getView());
            gL.glTranslated(vec4.x, vec4.y, vec4.z);
            gL.glScaled(d5, d5, 1.0);
            if (!drawContext.isPickingMode()) {
                gL.glTranslated(d2 / 2.0, d3 / 2.0, 0.0);
                if (this.showTilt) {
                    gL.glRotated(70.0 * (d7 / 90.0), 1.0, 0.0, 0.0);
                }
                gL.glRotated(d6, 0.0, 0.0, 1.0);
                gL.glTranslated(-d2 / 2.0, -d3 / 2.0, 0.0);
                Texture texture = drawContext.getTextureCache().get(this);
                if (texture == null) {
                    this.initializeTexture(drawContext);
                    texture = drawContext.getTextureCache().get(this);
                    if (texture == null) {
                        // empty if block
                    }
                }
                if (texture != null) {
                    gL.glEnable(3553);
                    texture.bind();
                    gL.glColor4d(1.0, 1.0, 1.0, this.getOpacity());
                    gL.glEnable(3042);
                    gL.glBlendFunc(770, 771);
                    TextureCoords textureCoords = texture.getImageTexCoords();
                    gL.glScaled(d2, d3, 1.0);
                    drawContext.drawUnitQuad(textureCoords);
                }
            } else {
                this.pickSupport.clearPickList();
                this.pickSupport.beginPicking(drawContext);
                Vec4 vec42 = new Vec4(vec4.x + d2 * d5 / 2.0, vec4.y + d3 * d5 / 2.0, 0.0);
                double d8 = (double)drawContext.getPickPoint().x - vec42.x;
                double d9 = rectangle.getHeight() - (double)drawContext.getPickPoint().y - vec42.y;
                Angle angle = Angle.fromRadians(Math.atan2(d8, d9));
                angle = angle.degrees >= 0.0 ? angle : angle.addDegrees(360.0);
                Color color = drawContext.getUniquePickColor();
                int n = color.getRGB();
                PickedObject pickedObject = new PickedObject(n, this, null, false);
                pickedObject.setValue("Heading", angle);
                this.pickSupport.addPickableObject(pickedObject);
                gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                gL.glScaled(d2, d3, 1.0);
                drawContext.drawUnitQuad();
                this.pickSupport.endPicking(drawContext);
                this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), this);
            }
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private double computeScale(Rectangle rectangle) {
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly")) {
            return Math.min(1.0, this.compassToViewportScale * (double)rectangle.width / this.getScaledIconWidth());
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeStretch")) {
            return this.compassToViewportScale * (double)rectangle.width / this.getScaledIconWidth();
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeKeepFixedSize")) {
            return 1.0;
        }
        return 1.0;
    }

    private double getScaledIconWidth() {
        return (double)this.iconWidth * this.iconScale;
    }

    private double getScaledIconHeight() {
        return (double)this.iconHeight * this.iconScale;
    }

    private Vec4 computeLocation(Rectangle rectangle, double d) {
        double d2;
        double d3;
        double d4 = this.getScaledIconWidth();
        double d5 = this.getScaledIconHeight();
        double d6 = d * d4;
        double d7 = d * d5;
        if (this.locationCenter != null) {
            d3 = this.locationCenter.x - d6 / 2.0;
            d2 = this.locationCenter.y - d7 / 2.0;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast")) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast")) {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest")) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest")) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else {
            d3 = rectangle.getWidth() - d6 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d7 - (double)this.borderWidth;
        }
        if (this.locationOffset != null) {
            d3 += this.locationOffset.x;
            d2 += this.locationOffset.y;
        }
        return new Vec4(d3, d2, 0.0);
    }

    private double computeHeading(View view) {
        if (view == null) {
            return 0.0;
        }
        if (!(view instanceof OrbitView)) {
            return 0.0;
        }
        OrbitView orbitView = (OrbitView)view;
        return orbitView.getHeading().getDegrees();
    }

    private double computePitch(View view) {
        if (view == null) {
            return 0.0;
        }
        if (!(view instanceof OrbitView)) {
            return 0.0;
        }
        OrbitView orbitView = (OrbitView)view;
        return orbitView.getPitch().getDegrees();
    }

    private void initializeTexture(DrawContext drawContext) {
        Object object;
        Object object2;
        Texture texture = drawContext.getTextureCache().get(this);
        if (texture != null) {
            return;
        }
        try {
            object2 = this.getClass().getResourceAsStream("/" + this.iconFilePath);
            if (object2 == null && ((File)(object = new File(this.iconFilePath))).exists()) {
                object2 = new FileInputStream((File)object);
            }
            texture = TextureIO.newTexture((InputStream)object2, false, null);
            texture.bind();
            this.iconWidth = texture.getWidth();
            this.iconHeight = texture.getHeight();
            drawContext.getTextureCache().put(this, texture);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("layers.IOExceptionDuringInitialization");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, iOException);
        }
        object2 = drawContext.getGL();
        object2.glTexEnvf(8960, 8704, 8448.0f);
        object2.glTexParameteri(3553, 10241, 9729);
        object2.glTexParameteri(3553, 10240, 9729);
        object2.glTexParameteri(3553, 10242, 33071);
        object2.glTexParameteri(3553, 10243, 33071);
        object = new int[1];
        object2.glGetIntegerv(34047, (int[])object, 0);
        object2.glTexParameteri(3553, 34046, (int)object[0]);
    }

    public String toString() {
        return Logging.getMessage("layers.CompassLayer.Name");
    }

    private class OrderedIcon
    implements OrderedRenderable {
        private OrderedIcon() {
        }

        public double getDistanceFromEye() {
            return 0.0;
        }

        public void pick(DrawContext drawContext, Point point) {
            CompassLayer.this.draw(drawContext);
        }

        public void render(DrawContext drawContext) {
            CompassLayer.this.draw(drawContext);
        }
    }
}

