/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Earth;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.BasicTiledImageLayer;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.GregorianCalendar;

public class CountryBoundariesLayer
extends BasicTiledImageLayer {
    public CountryBoundariesLayer() {
        super(CountryBoundariesLayer.makeLevels(new URLBuilder()));
        this.setUseTransparentTextures(true);
    }

    private static LevelSet makeLevels(URLBuilder uRLBuilder) {
        long l = new GregorianCalendar(2009, 1, 25).getTimeInMillis();
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 512);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/PoliticalBoundaries");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://worldwind25.arc.nasa.gov/geoserver/wms");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", "topp:cia");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", ".dds");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 13);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(36.0), Angle.fromDegrees(36.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", Sector.FULL_SPHERE);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", uRLBuilder);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ExpiryTime", l);
        return new LevelSet(aVListImpl);
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.PoliticalBoundaries.Name");
    }

    private static class URLBuilder
    implements TileUrlBuilder {
        private URLBuilder() {
        }

        public URL getURL(Tile tile, String string) throws MalformedURLException {
            StringBuffer stringBuffer = new StringBuffer(tile.getLevel().getService());
            if (stringBuffer.lastIndexOf("?") != stringBuffer.length() - 1) {
                stringBuffer.append("?");
            }
            stringBuffer.append("request=GetMap");
            stringBuffer.append("&layers=");
            stringBuffer.append(tile.getLevel().getDataset());
            stringBuffer.append("&srs=EPSG:4326");
            stringBuffer.append("&width=");
            stringBuffer.append(tile.getLevel().getTileWidth());
            stringBuffer.append("&height=");
            stringBuffer.append(tile.getLevel().getTileHeight());
            Sector sector = tile.getSector();
            stringBuffer.append("&bbox=");
            stringBuffer.append(sector.getMinLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMinLatitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLongitude().getDegrees());
            stringBuffer.append(",");
            stringBuffer.append(sector.getMaxLatitude().getDegrees());
            stringBuffer.append("&format=image/png");
            stringBuffer.append("&styles=countryboundaries");
            stringBuffer.append("&bgcolor=0x000000");
            stringBuffer.append("&transparent=true");
            return new URL(stringBuffer.toString());
        }
    }
}

