/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers.Mercator.examples;

import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.layers.Mercator.BasicMercatorTiledImageLayer;
import gov.nasa.worldwind.layers.Mercator.MercatorSector;
import gov.nasa.worldwind.layers.Mercator.examples.VirtualEarthLogo;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.LevelSet;
import gov.nasa.worldwind.util.Tile;
import gov.nasa.worldwind.util.TileUrlBuilder;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;

public class VirtualEarthLayer
extends BasicMercatorTiledImageLayer {
    private VirtualEarthLogo logo = new VirtualEarthLogo();
    private final Dataset dataset;

    public VirtualEarthLayer() {
        this(Dataset.HYBRID);
    }

    public VirtualEarthLayer(Dataset dataset) {
        super(VirtualEarthLayer.makeLevels(dataset));
        if (dataset == null) {
            throw new NullPointerException("Dataset cannot be null");
        }
        this.dataset = dataset;
        this.setValue("gov.nasa.worldwind.avkey.DisplayName", "Microsoft Virtual Earth " + dataset.label);
        this.setSplitScale(1.3);
    }

    protected static LevelSet makeLevels(Dataset dataset) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileWidthKey", 256);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileHeightKey", 256);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DataCacheNameKey", "Earth/MS Virtual Earth Mercator/MSVE " + dataset.label);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.ServiceURLKey", "http://a0.ortho.tiles.virtualearth.net/tiles/");
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DatasetNameKey", dataset.dataset);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.FormatSuffixKey", dataset.formatSuffix);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumLevels", 16);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.NumEmptyLevels", 0);
        aVListImpl.setValue("gov.nasa.worldwind.avkey.LevelZeroTileDelta", new LatLon(Angle.fromDegrees(22.5), Angle.fromDegrees(45.0)));
        aVListImpl.setValue("gov.nasa.worldwind.avKey.Sector", new MercatorSector(-1.0, 1.0, Angle.NEG180, Angle.POS180));
        aVListImpl.setValue("gov.nasa.worldwind.avkey.TileURLBuilder", new URLBuilder());
        aVListImpl.setValue("gov.nasa.worldwind.avkey.DisplayName", "Microsoft Virtual Earth " + dataset.label);
        return new LevelSet(aVListImpl);
    }

    protected static String tileToQuadKey(int n, int n2, int n3) {
        String string = "";
        for (int i = n3; i >= 0; --i) {
            int n4 = 1 << i;
            int n5 = 0;
            if ((n & n4) != 0) {
                ++n5;
            }
            if ((n2 & n4) == 0) {
                n5 += 2;
            }
            string = string + n5;
        }
        return string;
    }

    public void render(DrawContext drawContext) {
        super.render(drawContext);
        if (this.isEnabled()) {
            drawContext.addOrderedRenderable(this.logo);
        }
    }

    protected boolean isTileValid(BufferedImage bufferedImage) {
        boolean bl = true;
        String string = this.getDataset().formatSuffix.toLowerCase();
        int n = string.contains("jpg") || string.contains("jpeg") ? 200 : 250;
        for (int i = 0; i < bufferedImage.getWidth(); ++i) {
            int n2;
            for (int j = 0; j < bufferedImage.getHeight() && (bl = this.isWhite(n2 = bufferedImage.getRGB(i, j), n)); ++j) {
            }
            if (!bl) break;
        }
        return !bl;
    }

    private boolean isWhite(int n, int n2) {
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 0 & 0xFF;
        int n5 = n >> 8 & 0xFF;
        return n3 + n4 + n5 > n2 * 3;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    private static class URLBuilder
    implements TileUrlBuilder {
        private URLBuilder() {
        }

        public URL getURL(Tile tile, String string) throws MalformedURLException {
            String string2 = VirtualEarthLayer.tileToQuadKey(tile.getColumn(), tile.getRow(), tile.getLevelNumber() + 2);
            return new URL(tile.getLevel().getService() + tile.getLevel().getDataset() + string2 + ".jpeg?g=1");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Dataset {
        AERIAL("Aerial", "a", ".jpg"),
        HYBRID("Hybrid", "h", ".jpg"),
        ROAD("Road", "r", ".png");

        public final String label;
        public final String dataset;
        public final String formatSuffix;

        private Dataset(String string2, String string3, String string4) {
            this.label = string2;
            this.dataset = string3;
            this.formatSuffix = string4;
        }
    }
}

