/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.j2d.TextRenderer;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class ScalebarLayer
extends AbstractLayer {
    public static final String UNIT_METRIC = "gov.nasa.worldwind.ScalebarLayer.Metric";
    public static final String UNIT_IMPERIAL = "gov.nasa.worldwind.ScalebarLayer.Imperial";
    private Dimension size = new Dimension(150, 10);
    private Color color = Color.white;
    private int borderWidth = 20;
    private String position = "gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast";
    private String resizeBehavior = "gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly";
    private String unit = "gov.nasa.worldwind.ScalebarLayer.Metric";
    private Font defaultFont = Font.decode("Arial-PLAIN-12");
    private double toViewportScale = 0.2;
    private PickSupport pickSupport = new PickSupport();
    private Vec4 locationCenter = null;
    private Vec4 locationOffset = null;
    private TextRenderer textRenderer = null;
    private Position referencePosition = null;
    private double pixelSize;
    private OrderedIcon orderedImage = new OrderedIcon();
    private final float[] compArray = new float[4];

    public ScalebarLayer() {
        this.setPickEnabled(false);
    }

    public Position getReferencePosition() {
        return this.referencePosition;
    }

    public double getPixelSize() {
        return this.pixelSize;
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension dimension) {
        if (dimension == null) {
            String string = Logging.getMessage("nullValue.DimensionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.size = dimension;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public double getToViewportScale() {
        return this.toViewportScale;
    }

    public void setToViewportScale(double d) {
        this.toViewportScale = d;
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.position = string;
    }

    public Vec4 getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Vec4 vec4) {
        this.locationCenter = vec4;
    }

    public Vec4 getLocationOffset() {
        return this.locationOffset;
    }

    public void setLocationOffset(Vec4 vec4) {
        this.locationOffset = vec4;
    }

    public String getResizeBehavior() {
        return this.resizeBehavior;
    }

    public void setResizeBehavior(String string) {
        this.resizeBehavior = string;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(int n) {
        this.borderWidth = n;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String string) {
        this.unit = string;
    }

    public Font getFont() {
        return this.defaultFont;
    }

    public void setFont(Font font) {
        if (font == null) {
            String string = Logging.getMessage("nullValue.FontIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.defaultFont = font;
    }

    public void doRender(DrawContext drawContext) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    public void doPick(DrawContext drawContext, Point point) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(293121);
            bl = true;
            gL.glDisable(3553);
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            gL.glDisable(2929);
            double d = this.size.width;
            double d2 = this.size.height;
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            double d3 = d > d2 ? d : d2;
            gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -0.6 * d3, 0.6 * d3);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            double d4 = this.computeScale(rectangle);
            Vec4 vec4 = this.computeLocation(rectangle, d4);
            gL.glTranslated(vec4.x(), vec4.y(), vec4.z());
            gL.glScaled(d4, d4, 1.0);
            this.referencePosition = drawContext.getViewportCenterPosition();
            if (this.referencePosition != null) {
                Vec4 vec42 = drawContext.getGlobe().computePointFromPosition(this.referencePosition);
                Double d5 = drawContext.getView().getEyePoint().distanceTo3(vec42);
                this.pixelSize = drawContext.getView().computePixelSizeAtDistance(d5);
                Double d6 = this.pixelSize * d * d4;
                String string = "m";
                if (this.unit.equals(UNIT_METRIC)) {
                    if (d6 > 10000.0) {
                        d6 = d6 / 1000.0;
                        string = "Km";
                    }
                } else if (this.unit.equals(UNIT_IMPERIAL)) {
                    d6 = d6 * 3.280839895;
                    string = "ft";
                    if (d6 > 5280.0) {
                        d6 = d6 / 5280.0;
                        string = "mile(s)";
                    }
                }
                int n = (int)Math.floor(Math.log10(d6));
                int n2 = Integer.parseInt(String.format("%.0f", d6).substring(0, 1));
                double d7 = (double)n2 * Math.pow(10.0, n);
                if (n2 >= 5) {
                    d7 = 5.0 * Math.pow(10.0, n);
                } else if (n2 >= 2) {
                    d7 = 2.0 * Math.pow(10.0, n);
                }
                double d8 = d * d7 / d6;
                if (!drawContext.isPickingMode()) {
                    Color color = this.getBackgroundColor(this.color);
                    float[] fArray = color.getRGBColorComponents(null);
                    gL.glColor4d(fArray[0], fArray[1], fArray[2], (double)color.getAlpha() / 255.0 * this.getOpacity());
                    gL.glTranslated((d - d8) / 2.0, 0.0, 0.0);
                    this.drawScale(drawContext, d8, d2);
                    fArray = this.color.getRGBColorComponents(null);
                    gL.glColor4d(fArray[0], fArray[1], fArray[2], this.getOpacity());
                    gL.glTranslated(-1.0 / d4, 1.0 / d4, 0.0);
                    this.drawScale(drawContext, d8, d2);
                    String string2 = String.format("%.0f ", d7) + string;
                    gL.glLoadIdentity();
                    gL.glDisable(2884);
                    this.drawLabel(string2, vec4.add3(new Vec4(d8 * d4 / 2.0 + (d - d8) / 2.0, d2 * d4, 0.0)));
                } else {
                    this.pickSupport.clearPickList();
                    this.pickSupport.beginPicking(drawContext);
                    Color color = drawContext.getUniquePickColor();
                    int n3 = color.getRGB();
                    this.pickSupport.addPickableObject(n3, this, this.referencePosition, false);
                    gL.glColor3ub((byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue());
                    gL.glTranslated((d - d8) / 2.0, 0.0, 0.0);
                    this.drawRectangle(drawContext, d8, d2);
                    this.pickSupport.endPicking(drawContext);
                    this.pickSupport.resolvePick(drawContext, drawContext.getPickPoint(), this);
                }
            }
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private void drawRectangle(DrawContext drawContext, double d, double d2) {
        GL gL = drawContext.getGL();
        gL.glBegin(9);
        gL.glVertex3d(0.0, d2, 0.0);
        gL.glVertex3d(0.0, 0.0, 0.0);
        gL.glVertex3d(d, 0.0, 0.0);
        gL.glVertex3d(d, d2, 0.0);
        gL.glVertex3d(0.0, d2, 0.0);
        gL.glEnd();
    }

    private void drawScale(DrawContext drawContext, double d, double d2) {
        GL gL = drawContext.getGL();
        gL.glBegin(3);
        gL.glVertex3d(0.0, d2, 0.0);
        gL.glVertex3d(0.0, 0.0, 0.0);
        gL.glVertex3d(d, 0.0, 0.0);
        gL.glVertex3d(d, d2, 0.0);
        gL.glEnd();
        gL.glBegin(3);
        gL.glVertex3d(d / 2.0, 0.0, 0.0);
        gL.glVertex3d(d / 2.0, d2 / 2.0, 0.0);
        gL.glEnd();
    }

    private void drawLabel(String string, Vec4 vec4) {
        if (this.textRenderer == null) {
            this.textRenderer = new TextRenderer(this.defaultFont, true, true);
        }
        Rectangle2D rectangle2D = this.textRenderer.getBounds(string);
        int n = (int)(vec4.x() - rectangle2D.getWidth() / 2.0);
        int n2 = (int)vec4.y();
        this.textRenderer.begin3DRendering();
        this.textRenderer.setColor(this.getBackgroundColor(this.color));
        this.textRenderer.draw(string, n + 1, n2 - 1);
        this.textRenderer.setColor(this.color);
        this.textRenderer.draw(string, n, n2);
        this.textRenderer.end3DRendering();
    }

    private Color getBackgroundColor(Color color) {
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), this.compArray);
        if ((double)this.compArray[2] > 0.5) {
            return new Color(0.0f, 0.0f, 0.0f, 0.7f);
        }
        return new Color(1.0f, 1.0f, 1.0f, 0.7f);
    }

    private double computeScale(Rectangle rectangle) {
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly")) {
            return Math.min(1.0, this.toViewportScale * (double)rectangle.width / (double)this.size.width);
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeStretch")) {
            return this.toViewportScale * (double)rectangle.width / (double)this.size.width;
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeKeepFixedSize")) {
            return 1.0;
        }
        return 1.0;
    }

    private Vec4 computeLocation(Rectangle rectangle, double d) {
        double d2;
        double d3;
        double d4 = d * (double)this.size.width;
        double d5 = d * (double)this.size.height;
        if (this.locationCenter != null) {
            d3 = this.locationCenter.x - d4 / 2.0;
            d2 = this.locationCenter.y - d5 / 2.0;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthEast")) {
            d3 = rectangle.getWidth() - d4 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d5 - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthEast")) {
            d3 = rectangle.getWidth() - d4 - (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.NorthWest")) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = rectangle.getHeight() - d5 - (double)this.borderWidth;
        } else if (this.position.equals("gov.nasa.worldwind.layers.ViewControlsLayer.SouthWest")) {
            d3 = 0.0 + (double)this.borderWidth;
            d2 = 0.0 + (double)this.borderWidth;
        } else {
            d3 = rectangle.getWidth() - d4 / 2.0 - (double)this.borderWidth;
            d2 = rectangle.getHeight() - d5 / 2.0 - (double)this.borderWidth;
        }
        if (this.locationOffset != null) {
            d3 += this.locationOffset.x;
            d2 += this.locationOffset.y;
        }
        return new Vec4(d3, d2, 0.0);
    }

    public void dispose() {
        if (GLContext.getCurrent() != null && this.textRenderer != null) {
            this.textRenderer.dispose();
            this.textRenderer = null;
        }
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.ScalebarLayer.Name");
    }

    private class OrderedIcon
    implements OrderedRenderable {
        private OrderedIcon() {
        }

        public double getDistanceFromEye() {
            return 0.0;
        }

        public void pick(DrawContext drawContext, Point point) {
            ScalebarLayer.this.draw(drawContext);
        }

        public void render(DrawContext drawContext) {
            ScalebarLayer.this.draw(drawContext);
        }
    }
}

