/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class StarsLayer
extends RenderableLayer {
    protected String starsFileName = "config/Hipparcos_Stars_Mag6x5044.tsv";
    private int glListId = -1;
    private float brightness = 1.0f;
    private boolean rebuild = false;
    private double radius = 6.356752E7;
    private Angle longitudeOffset = Angle.ZERO;
    private Angle latitudeOffset = Angle.ZERO;

    public StarsLayer() {
    }

    public StarsLayer(String string) {
        this.setStarsFileName(string);
    }

    public String getStarsFileName() {
        return this.starsFileName;
    }

    public void setStarsFileName(String string) {
        if (string == null || string.length() == 0) {
            String string2 = Logging.getMessage("nullValue.FilePathIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.starsFileName = string;
        this.rebuild = true;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public void setBrightness(float f) {
        this.brightness = Math.abs(f);
        this.rebuild = true;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = Math.abs(d);
        this.rebuild = true;
    }

    public Angle getLatitudeOffset() {
        return this.latitudeOffset;
    }

    public void setLatitudeOffset(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.latitudeOffset = angle;
    }

    public Angle getLongitudeOffset() {
        return this.longitudeOffset;
    }

    public void setLongitudeOffset(Angle angle) {
        if (angle == null) {
            String string = Logging.getMessage("nullValue.AngleIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.longitudeOffset = angle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRender(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.glListId == -1 || this.rebuild) {
            if (this.glListId != -1) {
                gL.glDeleteLists(this.glListId, 1);
            }
            this.loadStars(drawContext);
            this.rebuild = false;
        }
        if (this.glListId == -1) {
            return;
        }
        try {
            double d;
            gL.glPushAttrib(8201);
            bl = true;
            gL.glDisable(3553);
            gL.glDisable(2929);
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            double d2 = d = drawContext.getView().getEyePoint().getLength3();
            double d3 = this.radius + d;
            drawContext.getGLU().gluPerspective(drawContext.getView().getFieldOfView().degrees, drawContext.getView().getViewport().getWidth() / drawContext.getView().getViewport().getHeight(), d2, d3);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glRotatef((float)this.longitudeOffset.degrees, 0.0f, 1.0f, 0.0f);
            gL.glRotatef((float)(-this.latitudeOffset.degrees), 1.0f, 0.0f, 0.0f);
            gL.glCallList(this.glListId);
        }
        finally {
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private void loadStars(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        this.glListId = gL.glGenLists(1);
        gL.glNewList(this.glListId, 4864);
        this.drawStarsFromFile(drawContext);
        gL.glEndList();
    }

    private void drawStarsFromFile(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        try {
            String string;
            Object object;
            InputStream inputStream = this.getClass().getResourceAsStream("/" + this.starsFileName);
            if (inputStream == null && ((File)(object = new File(this.starsFileName))).exists()) {
                inputStream = new FileInputStream((File)object);
            }
            if (inputStream == null) {
                return;
            }
            object = new BufferedReader(new InputStreamReader(inputStream));
            int n = 2;
            int n2 = 3;
            int n3 = 4;
            int n4 = 5;
            boolean bl = false;
            gL.glBegin(0);
            while ((string = ((BufferedReader)object).readLine()) != null) {
                if (string.length() < 3 || string.substring(0, 1).equals("#")) continue;
                if (bl) {
                    String[] stringArray = string.trim().split(";");
                    String string2 = stringArray[n];
                    String string3 = stringArray[n2];
                    String string4 = stringArray[n3];
                    String string5 = n4 < stringArray.length ? stringArray[n4] : "";
                    double d = Double.parseDouble(string2.substring(0, 2));
                    double d2 = Double.parseDouble(string2.substring(3, 5));
                    double d3 = Double.parseDouble(string2.substring(6));
                    double d4 = d * 15.0 + d2 * 0.25 + d3 * 0.0041666 - 180.0;
                    String string6 = string3.substring(0, 1);
                    double d5 = Double.parseDouble(string3.substring(1, 3));
                    double d6 = Double.parseDouble(string3.substring(4, 6));
                    double d7 = Double.parseDouble(string3.substring(7));
                    double d8 = d5 + d6 / 60.0 + d7 / 3600.0;
                    if (string6.equals("-")) {
                        d8 *= -1.0;
                    }
                    double d9 = Double.parseDouble(string4);
                    double d10 = 255.0 - (d9 + 1.5) * 255.0 / 10.0;
                    if ((d10 *= (double)this.brightness) > 255.0) {
                        d10 = 255.0;
                    }
                    d10 /= 255.0;
                    double d11 = 0.0;
                    try {
                        d11 = Double.parseDouble(string5);
                    }
                    catch (Exception exception) {
                        d11 = 0.0;
                    }
                    Color color = StarsLayer.BVColor(d11);
                    gL.glColor3f((float)color.getRed() / 255.0f * (float)d10, (float)color.getGreen() / 255.0f * (float)d10, (float)color.getBlue() / 255.0f * (float)d10);
                    Vec4 vec4 = StarsLayer.SphericalToCartesian(d8, d4, this.radius);
                    gL.glVertex3d(vec4.getX(), vec4.getY(), vec4.getZ());
                }
                if (!string.substring(0, 3).equals("---")) continue;
                bl = true;
            }
            gL.glEnd();
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            String string = "IOException while loading stars data from " + this.starsFileName;
            Logging.logger().severe(string);
        }
        catch (Exception exception) {
            String string = "Error while loading stars data from " + this.starsFileName;
            Logging.logger().severe(string);
        }
    }

    private static Vec4 SphericalToCartesian(double d, double d2, double d3) {
        double d4 = d3 * Math.cos(d *= Math.PI / 180);
        return new Vec4(d4 * Math.sin(d2 *= Math.PI / 180), d3 * Math.sin(d), d4 * Math.cos(d2));
    }

    private static Color BVColor(double d) {
        if (d < 0.0) {
            return new Color(0.635f, 0.764f, 0.929f);
        }
        if (d < 0.5) {
            return new Color(1.0f, 1.0f, 1.0f);
        }
        if (d < 1.0) {
            return new Color(1.0f, 0.984f, 0.266f);
        }
        if (d < 1.5) {
            return new Color(0.964f, 0.725f, 0.0784f);
        }
        return new Color(0.921f, 0.376f, 0.0392f);
    }

    public void dispose() {
        if (this.glListId < 0) {
            return;
        }
        GLContext gLContext = GLContext.getCurrent();
        if (gLContext == null) {
            return;
        }
        gLContext.getGL().glDeleteLists(this.glListId, 1);
        this.glListId = -1;
    }

    public String toString() {
        return Logging.getMessage("layers.Earth.StarsLayer.Name");
    }
}

