/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.SurfaceImage;
import gov.nasa.worldwind.util.ImageTiler;
import gov.nasa.worldwind.util.ImageUtil;
import gov.nasa.worldwind.util.Logging;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SurfaceImageLayer
extends RenderableLayer {
    protected ImageTiler imageTiler = new ImageTiler();
    protected ConcurrentHashMap<String, ArrayList<SurfaceImage>> imageTable = new ConcurrentHashMap();

    public void addImage(String string) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        AVList aVList = ImageUtil.openSpatialImage(file);
        BufferedImage bufferedImage = (BufferedImage)aVList.getValue("gov.nasa.worldwind.avkey.Image");
        Sector sector = (Sector)aVList.getValue("gov.nasa.worldwind.avKey.Sector");
        if (bufferedImage == null || sector == null) {
            String string4 = bufferedImage == null ? "ImageUtil.ImageNotAvailable" : "ImageUtil.SectorNotAvailable";
            String string5 = Logging.getMessage(string4, string);
            Logging.logger().severe(string5);
            throw new IllegalStateException(string5);
        }
        this.addImage(string, bufferedImage, sector);
    }

    public void addImage(String string, Sector sector) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            String string4 = Logging.getMessage("generic.ImageReadFailed", file);
            Logging.logger().severe(string4);
            throw new WWRuntimeException(string4);
        }
        this.addImage(string, bufferedImage, sector);
    }

    public void addImage(String string, BufferedImage bufferedImage, Sector sector) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (bufferedImage == null) {
            String string3 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (sector == null) {
            String string4 = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (this.imageTable.contains(string)) {
            this.removeImage(string);
        }
        final ArrayList arrayList = new ArrayList();
        this.imageTable.put(string, arrayList);
        this.imageTiler.tileImage(bufferedImage, sector, new ImageTiler.ImageTilerListener(){

            @Override
            public void newTile(BufferedImage bufferedImage, Sector sector) {
                SurfaceImage surfaceImage = new SurfaceImage((Object)bufferedImage, sector);
                arrayList.add(surfaceImage);
                surfaceImage.setOpacity(SurfaceImageLayer.this.getOpacity());
                SurfaceImageLayer.this.addRenderable(surfaceImage);
            }

            @Override
            public void newTile(BufferedImage bufferedImage, List<? extends LatLon> list) {
            }
        });
    }

    public void addImage(String string, List<? extends LatLon> list) throws IOException {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        File file = new File(string);
        if (!file.exists()) {
            String string3 = Logging.getMessage("generic.FileNotFound", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            String string4 = Logging.getMessage("generic.ImageReadFailed", file);
            Logging.logger().severe(string4);
            throw new WWRuntimeException(string4);
        }
        this.addImage(string, bufferedImage, list);
    }

    public void addImage(String string, BufferedImage bufferedImage, List<? extends LatLon> list) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        if (bufferedImage == null) {
            String string3 = Logging.getMessage("nullValue.ImageSource");
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3);
        }
        if (list == null) {
            String string4 = Logging.getMessage("nullValue.LocationsListIsNull");
            Logging.logger().severe(string4);
            throw new IllegalArgumentException(string4);
        }
        if (this.imageTable.contains(string)) {
            this.removeImage(string);
        }
        final ArrayList arrayList = new ArrayList();
        this.imageTable.put(string, arrayList);
        this.imageTiler.tileImage(bufferedImage, list, new ImageTiler.ImageTilerListener(){

            @Override
            public void newTile(BufferedImage bufferedImage, Sector sector) {
            }

            @Override
            public void newTile(BufferedImage bufferedImage, List<? extends LatLon> list) {
                SurfaceImage surfaceImage = new SurfaceImage((Object)bufferedImage, list);
                arrayList.add(surfaceImage);
                surfaceImage.setOpacity(SurfaceImageLayer.this.getOpacity());
                SurfaceImageLayer.this.addRenderable(surfaceImage);
            }
        });
    }

    public void removeImage(String string) {
        ArrayList<SurfaceImage> arrayList = this.imageTable.get(string);
        if (arrayList == null) {
            return;
        }
        this.imageTable.remove(string);
        for (SurfaceImage surfaceImage : arrayList) {
            if (surfaceImage == null) continue;
            this.removeRenderable(surfaceImage);
        }
    }

    @Override
    public void setOpacity(double d) {
        super.setOpacity(d);
        for (Map.Entry<String, ArrayList<SurfaceImage>> entry : this.imageTable.entrySet()) {
            for (SurfaceImage surfaceImage : entry.getValue()) {
                if (surfaceImage == null) continue;
                surfaceImage.setOpacity(d);
            }
        }
    }

    public int getNumImages() {
        int n = 0;
        for (ArrayList<SurfaceImage> arrayList : this.imageTable.values()) {
            n += arrayList.size();
        }
        return n;
    }

    public BufferedImage composeImageForSector(Sector sector, int n, int n2, double d, BufferedImage bufferedImage) {
        if (sector == null) {
            String string = Logging.getMessage("nullValue.SectorIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (!this.getRenderables().iterator().hasNext()) {
            Logging.logger().severe(Logging.getMessage("generic.NoImagesAvailable"));
            return null;
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(n, n2, 1);
        }
        for (Renderable renderable : this.getRenderables()) {
            SurfaceImage surfaceImage = (SurfaceImage)renderable;
            if (surfaceImage.getImageSource() == null) continue;
            ImageUtil.mergeImage(sector, surfaceImage.getSector(), d, (BufferedImage)surfaceImage.getImageSource(), bufferedImage);
        }
        return bufferedImage;
    }
}

